/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.client;

import COM.ibm.raleigh.ddnssgui.common.TraceClient;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ClientMsg;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DlgAuthorize;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DlgError;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DlgMessage;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DlgStatus;
import COM.ibm.raleigh.tcp.tcpcfg2.client.HelpHandle;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MessageListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.Notebook;
import COM.ibm.raleigh.tcp.tcpcfg2.common.BaseProxy;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Cfg2Defines;
import COM.ibm.raleigh.tcp.tcpcfg2.common.ClientProxy;
import COM.ibm.raleigh.tcp.tcpcfg2.common.ConnectionStatus;
import COM.ibm.raleigh.tcp.tcpcfg2.common.FileLock;
import COM.ibm.raleigh.tcp.tcpcfg2.common.ServerProxy;
import COM.ibm.raleigh.tcp.tcpcfg2.common.TcpError;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import COM.ibm.raleigh.tcpauth.client_admin_auth;
import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ResourceBundle;

public class Tcpcfg2
extends Applet
implements Cfg2Defines,
MessageListener {
    private ResourceBundle myBundle;
    private Notebook myNotebook;
    private DlgAuthorize authorizationDialog;
    private DlgStatus statusDialog;
    private DlgMessage messageDialog;
    private BaseProxy myProxy;
    private client_admin_auth clientAuth;
    private TraceClient myTraceClient;
    private boolean emergencyShutdown = false;
    private FileLock myFileLock;
    private ConnectionStatus myConnectionStatus;
    private AppletContext myAppletContext;
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";

    public Tcpcfg2() {
    }

    public Tcpcfg2(String string) {
        ClientMsg.setBundle(string);
        this.myBundle = ClientMsg.getBundle();
    }

    public void stop() {
        super.stop();
    }

    public void destroy() {
        super.destroy();
        this.exitApplet();
    }

    public void init() {
        Object object;
        super.init();
        if (Utility.isRunningAsApplet()) {
            HelpHandle.setAppletHandle(this);
            this.myAppletContext = this.getAppletContext();
            object = null;
            String string = null;
            Utility.setLocalConfig(false);
            object = this.getParameter("LANG");
            string = this.getParameter("TRACE");
            if (string == null) {
                Utility.setTrace(false);
            } else if (string.compareTo("trace") == 0) {
                Utility.setTrace(true);
            } else {
                Utility.setTrace(false);
            }
            ClientMsg.setBundle((String)object);
            this.myBundle = ClientMsg.getBundle();
        }
        if (this.myBundle == null) {
            ClientMsg.setBundle(null);
            this.myBundle = ClientMsg.getBundle();
        }
        if (Utility.isTraceOn()) {
            System.out.println("*****************************************************************************");
            System.out.println("*****************************************************************************");
            System.out.println("*******  The JDK level is: " + Utility.getJDKlevel());
            System.out.println("*****************************************************************************");
            System.out.println("*****************************************************************************");
            object = Toolkit.getDefaultToolkit().getScreenSize();
            System.out.println(">>> screen width = " + ((Dimension)object).width + " >>> screen height = " + ((Dimension)object).height);
            if (Utility.isLocalConfig()) {
                System.out.println("this is a LOCAL config");
            } else {
                System.out.println("this is a REMOTE config");
            }
        }
        object = Toolkit.getDefaultToolkit().getScreenSize();
        Utility.setGraphicSizes(((Dimension)object).width, ((Dimension)object).height);
        boolean bl = false;
        this.setBackground(Utility.NOTEBOOK_COLOR);
        if (Utility.isLocalConfig()) {
            if (Utility.isRunningAsApplet()) {
                this.showStatusDialog(this.myBundle.getString("TCPCFG2_PROCESS_AUTHORIZATION"));
                bl = this.connectToLocalServer("127.0.0.1");
            } else {
                this.myFileLock = new FileLock();
                if (!this.myFileLock.getLock()) {
                    TcpError tcpError = new TcpError(this.myBundle.getString("TCPCFG2D_CANNOT_START"), 3);
                    DlgError dlgError = new DlgError(tcpError, new Frame(), true, Utility.getDimension(3));
                    dlgError.setVisible(true);
                    bl = false;
                } else {
                    this.showStatusDialog(this.myBundle.getString("TCPCFG2_PROCESS_AUTHORIZATION"));
                    bl = this.connectLocalWithNoServer("127.0.0.1");
                }
            }
        } else {
            this.showStatusDialog(this.myBundle.getString("TCPCFG2_PROCESS_AUTHORIZATION"));
            bl = this.connectToRemoteServer();
        }
        if (!bl) {
            this.exitApplet();
            return;
        }
        this.showNotebook();
    }

    private boolean connectLocalWithNoServer(String string) {
        if (Utility.isTraceOn()) {
            System.out.println("Tcpcfg2 - connecting local with no server.");
        }
        this.myProxy = new ClientProxy(this, string);
        return true;
    }

    private boolean connectToLocalServer(String string) {
        this.myConnectionStatus = new ConnectionStatus();
        this.myConnectionStatus.setAuthRequired(false);
        if (this.connectViaServerProxy(string)) {
            this.sendConnectionStatus();
            return !this.myProxy.isConnectionFailure();
        }
        return false;
    }

    private boolean connectViaServerProxy(String string) {
        if (Utility.isTraceOn()) {
            System.out.println("In Tcpcfg2.connectViaServerProxy - hostname = " + string);
        }
        this.myProxy = new ServerProxy(this, string, this.clientAuth);
        this.myProxy.connectToServer();
        return !this.myProxy.isConnectionFailure();
    }

    private boolean connectToRemoteServer() {
        this.myConnectionStatus = new ConnectionStatus();
        this.myConnectionStatus.setAuthRequired(true);
        return this.processAuthorizationDialog();
    }

    private void sendConnectionStatus() {
        this.myProxy.sendConnectionStatus(this.myConnectionStatus);
    }

    private boolean processAuthorizationDialog() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        while (!bl2) {
            this.showAuthorizationDialog();
            if (this.authorizationDialog.getStatus() == 1) {
                if (!bl3) {
                    bl2 = true;
                } else {
                    this.myConnectionStatus.setCancelled(true);
                    this.sendConnectionStatus();
                    bl2 = true;
                }
            } else if (!bl3) {
                bl3 = this.connectViaServerProxy(this.authorizationDialog.getHostName());
            }
            if (!bl3 || bl2) continue;
            this.sendConnectionStatus();
            if (this.myProxy.isConnectionFailure()) {
                return false;
            }
            if (Utility.isTraceOn()) {
                System.out.println("about to new and init client_admin_auth()");
            }
            this.clientAuth = new client_admin_auth();
            if (Utility.isTraceOn()) {
                System.out.println("about to clientAuth.init()");
            }
            client_admin_auth.init();
            Socket socket = null;
            try {
                socket = new Socket(this.authorizationDialog.getHostName(), 11223);
            }
            catch (IOException iOException) {
                this.setStatusMessage(this.myBundle.getString("TCPCFG2_CANNOT_AUTHORIZE"));
                bl2 = true;
            }
            int n = -1;
            boolean bl4 = true;
            try {
                socket.setSoTimeout(30000);
                n = client_admin_auth.auth((Socket)socket, (String)this.authorizationDialog.getPassword());
            }
            catch (SocketException socketException) {
                this.setStatusMessage(this.myBundle.getString("TCPCFG2_CANNOT_CONNECT2"));
                bl4 = false;
            }
            if (!bl4) continue;
            if (n == 0) {
                bl = true;
                this.myConnectionStatus.setAuthRequired(false);
                this.sendConnectionStatus();
                bl2 = true;
                continue;
            }
            this.showMessageDialog(this.myBundle.getString("TCPCFG2_INVALID_PASSWORD"), Utility.getDimension(3));
        }
        return bl;
    }

    public void setStatusMessage(String string) {
        this.showStatusDialog(string);
    }

    private void showAuthorizationDialog() {
        this.authorizationDialog = new DlgAuthorize(this);
        if (Utility.isRunningAsApplet()) {
            URL uRL = this.getCodeBase();
            InetAddress[] inetAddressArray = null;
            try {
                inetAddressArray = InetAddress.getAllByName(uRL.getHost());
                this.authorizationDialog.setProtectedHost(inetAddressArray[0].getHostAddress());
            }
            catch (UnknownHostException unknownHostException) {
                unknownHostException.printStackTrace(System.err);
            }
        }
        this.authorizationDialog.setVisible(true);
    }

    public void showMessageDialog(String string) {
        this.messageDialog = new DlgMessage(new Frame(), string, true, this);
        this.messageDialog.setVisible(true);
    }

    public void showMessageDialog(String string, Dimension dimension) {
        this.messageDialog = new DlgMessage(new Frame(), string, true, this);
        ((Component)this.messageDialog).setSize(dimension);
        this.messageDialog.setVisible(true);
    }

    public void showStatusDialog(String string) {
        if (this.statusDialog == null) {
            this.statusDialog = new DlgStatus(string, this);
        } else {
            this.statusDialog.setStatusMessage(string);
            this.statusDialog.requestFocus();
        }
        if (!this.statusDialog.isShowing()) {
            this.statusDialog.requestFocus();
            this.statusDialog.setVisible(true);
        }
    }

    public void showNotebook() {
        this.myNotebook = new Notebook(this, this.myProxy);
        this.myNotebook.setResizable(false);
        if (this.statusDialog != null) {
            this.statusDialog.dispose();
        }
        if (!this.emergencyShutdown) {
            this.myNotebook.setVisible(true);
            this.myNotebook.requestFocus();
        }
    }

    private void exitApplet() {
        if (this.myProxy != null) {
            this.myProxy.shutdown();
        }
        if (this.messageDialog != null) {
            this.messageDialog.dispose();
            this.messageDialog = null;
        }
        if (this.statusDialog != null) {
            this.statusDialog.dispose();
            this.statusDialog = null;
        }
        if (this.myFileLock != null) {
            this.myFileLock.releaseLock();
        }
        if (this.myNotebook != null) {
            this.myNotebook.dispose();
            this.myNotebook = null;
        }
        if (!Utility.isRunningAsApplet()) {
            System.exit(0);
        }
    }

    public void serverIsDown(String string) {
        TcpError tcpError = new TcpError(string, 3);
        DlgError dlgError = new DlgError(tcpError, new Frame());
        dlgError.setVisible(true);
    }

    public void shutDown() {
        this.setStatusMessage(this.myBundle.getString("NB_SHUTDOWN"));
        int n = 0;
        while (n < 500000) {
            ++n;
        }
        this.emergencyShutdown = true;
        this.exitApplet();
    }

    public AppletContext getTheContext() {
        return this.myAppletContext;
    }

    public void start() {
        super.start();
    }

    public void messageFinished(int n) {
        this.requestFocus();
    }
}

