/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.common;

import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCConstants;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCKeyword;
import COM.ibm.raleigh.tcp.tcpcfg2.common.CloneableItem;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NotebookData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;

public class AutostartService
extends NotebookData
implements Cloneable,
CloneableItem,
OOCConstants {
    public static final String BAU_tag = new String("Bau");
    public static final String EAU_tag = new String("Eau");
    private static final String myParameters_tag = new String("AParms");
    private static final String myServiceName_tag = new String("Aname");
    private static final String myAutostartState_tag = new String("A_yn");
    private static final String myDetachedState_tag = new String("D_yn");
    private static final String myForegroundState_tag = new String("F_yn");
    private static final String myInetdState_tag = new String("I_yn");
    private static final String myMinimizedState_tag = new String("M_yn");
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    private boolean myAutostartState = false;
    private boolean myDetachedState = false;
    private boolean myForegroundState = false;
    private boolean myInetdState = false;
    private boolean myMinimizedState = false;
    private String myParameters;
    private String myServiceName;
    private String startViaInetd;
    private OOCKeyword kwInetdState;
    private OOCKeyword kwAutostart;
    private OOCKeyword kwAutostartType;
    private OOCKeyword kwInetdAutostartType;
    private OOCKeyword kwParameters;
    private boolean myTrace = Utility.isTraceOn();

    public AutostartService() {
        if (this.myTrace) {
            System.out.println("in AutostartService constructor");
        }
        this.loadInit();
    }

    public AutostartService(ParsedVector parsedVector) {
        if (this.myTrace) {
            System.out.println("@@@@@@@@@ CONSRUCTING AutostartService from a ParsedVector");
        }
        this.fromString(parsedVector);
    }

    public Object clone() {
        if (this.myTrace) {
            System.out.println("in AutostartService.clone()");
        }
        AutostartService autostartService = new AutostartService();
        autostartService.setAutomaticallyStarted(this.myAutostartState);
        autostartService.setDetached(this.myDetachedState);
        autostartService.setForeground(this.myForegroundState);
        autostartService.setViaInetd(this.myInetdState);
        autostartService.setMinimized(this.myMinimizedState);
        autostartService.setServiceName(new String(this.myServiceName));
        autostartService.setParameters(new String(this.myParameters));
        return autostartService;
    }

    public String getParameters() {
        return this.myParameters;
    }

    public String getServiceName() {
        return this.myServiceName;
    }

    public boolean isAutomaticallyStarted() {
        return this.myAutostartState;
    }

    public boolean isDetached() {
        return this.myDetachedState;
    }

    public boolean isForeground() {
        return this.myForegroundState;
    }

    public boolean isMinimized() {
        return this.myMinimizedState;
    }

    public boolean isViaInetd() {
        return this.myInetdState;
    }

    private void loadInit() {
        if (this.myTrace) {
            System.out.println("in loadInit() of AutostartService");
        }
        this.myAutostartState = false;
        this.myDetachedState = false;
        this.myForegroundState = false;
        this.myInetdState = false;
        this.myMinimizedState = false;
        this.myParameters = new String("");
        this.myServiceName = new String("");
        this.loaded = true;
    }

    public void setAutomaticallyStarted(boolean bl) {
        this.myAutostartState = bl;
    }

    public void setDetached(boolean bl) {
        this.myDetachedState = bl;
    }

    public void setForeground(boolean bl) {
        this.myForegroundState = bl;
    }

    public void setMinimized(boolean bl) {
        this.myMinimizedState = bl;
    }

    public void setParameters(String string) {
        this.myParameters = string;
    }

    public void setViaInetd(boolean bl) {
        this.myInetdState = bl;
    }

    public void setServiceName(String string) {
        this.myServiceName = string;
    }

    public void loadServerFromOOCS(OOCKeyword oOCKeyword, OOCKeyword oOCKeyword2, String string) {
        this.myServiceName = string;
        if (this.myTrace) {
            System.out.println("(AutostartService.loadServiceFromOOCS) myServiceName = " + this.myServiceName);
        }
        String string2 = oOCKeyword.getValueOf("autostart_type");
        if (oOCKeyword2 != null) {
            this.startViaInetd = oOCKeyword2.getValueOf("autostart_type");
            if (this.startViaInetd.equals("INETD")) {
                this.myInetdState = true;
                this.myAutostartState = true;
                if (this.myTrace) {
                    System.out.println("(AutostartService.loadServiceFromOOCS) setting myInetdState = " + this.myInetdState);
                    System.out.println("(AutostartService.loadServiceFromOOCS) myAutostartState = " + this.myAutostartState);
                }
            }
        } else {
            String string3 = oOCKeyword.getValueOf("autostart");
            this.myAutostartState = string3.equals("Y");
            if (this.myTrace) {
                System.out.println("(AutostartService.loadServiceFromOOCS) myAutostartState = " + this.myAutostartState);
                System.out.println("(AutostartService.loadServiceFromOOCS) autostartType = " + string2);
                System.out.println("(AutostartService.loadServiceFromOOCS) startViaInetd = " + this.startViaInetd);
            }
            if (string2.equals("START_NORM")) {
                this.myForegroundState = true;
                if (this.myTrace) {
                    System.out.println("(AutostartService.loadServiceFromOOCS) setting myForegroundState = " + this.myForegroundState);
                }
            } else if (string2.equals("DET")) {
                this.myDetachedState = true;
                if (this.myTrace) {
                    System.out.println("(AutostartService.loadServiceFromOOCS) setting myDetachedState = " + this.myDetachedState);
                }
            } else if (string2.equals("START_MIN")) {
                this.myMinimizedState = true;
                this.myForegroundState = true;
                if (this.myTrace) {
                    System.out.println("(AutostartService.loadServiceFromOOCS) setting myMinimizedState = " + this.myMinimizedState);
                    System.out.println("(AutostartService.loadServiceFromOOCS) setting myForegroundState = " + this.myForegroundState);
                }
            }
        }
        this.myParameters = oOCKeyword.getValueOf("parameters");
        if (this.myTrace) {
            System.out.println("(AutostartService.loadServiceFromOOCS) myParameters = " + this.myParameters);
        }
    }

    public void saveServerToOOCS(OOCKeyword oOCKeyword, OOCKeyword oOCKeyword2, String string) {
        int n = 0;
        if (this.myAutostartState) {
            if (this.kwAutostart == null) {
                this.kwAutostart = oOCKeyword.createKeyword(1, "autostart", "Y", null);
            } else {
                this.kwAutostart.setValue("Y");
            }
        } else if (this.kwAutostart == null) {
            this.kwAutostart = oOCKeyword.createKeyword(1, "autostart", "N", null);
        } else {
            this.kwAutostart.setValue("N");
        }
        if (this.kwAutostartType == null) {
            this.kwAutostartType = oOCKeyword.createKeyword(1, "autostart_type", "", null);
        }
        if (this.myDetachedState) {
            this.kwAutostartType.setValue("DET");
        } else if (this.myForegroundState && this.myMinimizedState) {
            this.kwAutostartType.setValue("START_MIN");
        } else if (this.myForegroundState && !this.myMinimizedState) {
            this.kwAutostartType.setValue("START_NORM");
        } else if (this.myInetdState) {
            this.kwAutostartType.setValue("INETD");
        }
        if (this.kwParameters == null) {
            this.kwParameters = oOCKeyword.createKeyword(1, "parameters", this.myParameters, null);
        } else {
            this.kwParameters.setValue(this.myParameters);
        }
        if (oOCKeyword != null && oOCKeyword2 != null) {
            n = oOCKeyword2.merge(oOCKeyword);
        }
        if (this.myTrace) {
            System.out.println("(AutoStartService merge rc for " + string + " = " + n);
            System.out.println("(AutostartService.SaveServerToOOCS) myAutoStartState = " + this.myAutostartState);
            System.out.println("(AutostartService.SaveServerToOOCS) Autostart = " + this.kwAutostart.getValue());
            System.out.println("(AutostartService.SaveServerToOOCS) myDetachedState = " + this.myDetachedState);
            System.out.println("(AutostartService.SaveServerToOOCS) myForegroundState = " + this.myForegroundState);
            System.out.println("(AutostartService.SaveServerToOOCS) myMinimizedState = " + this.myMinimizedState);
            System.out.println("(AutostartService.SaveServerToOOCS) myInetdState = " + this.myInetdState);
            System.out.println("(AutostartService.SaveServerToOOCS) AutostartType = " + this.kwAutostartType.getValue());
            System.out.println("(AutostartService.SaveServerToOOCS) Parameters = " + this.kwParameters.getValue());
        }
    }

    public void fromString(ParsedVector parsedVector) {
        String[] stringArray = parsedVector.getKeys();
        int n = 0;
        while (n < stringArray.length) {
            Integer n2;
            String string;
            ParsedObject parsedObject;
            if (stringArray[n].equals(myServiceName_tag)) {
                parsedObject = parsedVector.getElement(myServiceName_tag);
                string = (String)parsedObject.getValue();
                this.myServiceName = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(myParameters_tag)) {
                parsedObject = parsedVector.getElement(myParameters_tag);
                string = (String)parsedObject.getValue();
                this.myParameters = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(myAutostartState_tag)) {
                parsedObject = parsedVector.getElement(myAutostartState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myAutostartState = n2 != 0;
                }
            } else if (stringArray[n].equals(myDetachedState_tag)) {
                parsedObject = parsedVector.getElement(myDetachedState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myDetachedState = n2 != 0;
                }
            } else if (stringArray[n].equals(myForegroundState_tag)) {
                parsedObject = parsedVector.getElement(myForegroundState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myForegroundState = n2 != 0;
                }
            } else if (stringArray[n].equals(myInetdState_tag)) {
                parsedObject = parsedVector.getElement(myInetdState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myInetdState = n2 != 0;
                }
            } else if (stringArray[n].equals(myMinimizedState_tag) && (string = (String)(parsedObject = parsedVector.getElement(myMinimizedState_tag)).getValue()) != null) {
                n2 = Integer.valueOf(string);
                this.myMinimizedState = n2 != 0;
            }
            ++n;
        }
        if (this.myTrace) {
            System.out.println("fromString.myServiceName = " + this.myServiceName);
            System.out.println("fromString.myParameters = " + this.myParameters);
            System.out.println("fromString.myAutostartState = " + this.myAutostartState);
            System.out.println("fromString.myDetachedState = " + this.myDetachedState);
            System.out.println("fromString.myForegroundState = " + this.myForegroundState);
            System.out.println("fromString.myInetdState = " + this.myInetdState);
            System.out.println("fromString.myMinimizedState = " + this.myMinimizedState);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(BAU_tag);
        stringBuffer.append("," + myServiceName_tag + "=" + this.myServiceName);
        stringBuffer.append("," + myParameters_tag + "=" + this.myParameters);
        if (this.myAutostartState) {
            stringBuffer.append("," + myAutostartState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myAutostartState_tag + "=" + 0);
        }
        if (this.myDetachedState) {
            stringBuffer.append("," + myDetachedState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myDetachedState_tag + "=" + 0);
        }
        if (this.myForegroundState) {
            stringBuffer.append("," + myForegroundState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myForegroundState_tag + "=" + 0);
        }
        if (this.myInetdState) {
            stringBuffer.append("," + myInetdState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myInetdState_tag + "=" + 0);
        }
        if (this.myMinimizedState) {
            stringBuffer.append("," + myMinimizedState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myMinimizedState_tag + "=" + 0);
        }
        stringBuffer.append("," + EAU_tag);
        return stringBuffer.toString();
    }
}

