/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.common;

import COM.ibm.raleigh.tcp.tcpcfg2.client.ClientMsg;
import COM.ibm.raleigh.tcp.tcpcfg2.client.HelpHandle;
import COM.ibm.raleigh.tcp.tcpcfg2.client.Tcpcfg2;
import COM.ibm.raleigh.tcp.tcpcfg2.common.BaseProxy;
import COM.ibm.raleigh.tcp.tcpcfg2.common.ErrorListController;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NotebookProfile;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import COM.ibm.raleigh.tcp.tcpcfg2.server.NativeData;
import COM.ibm.raleigh.tcpauth.client_admin_auth;
import java.util.ResourceBundle;

public class ClientProxy
extends BaseProxy {
    private ResourceBundle myBundle;
    private String theETCpath;
    private String myHostName;
    private NotebookProfile myProfile;
    private ErrorListController myErrorListController;
    private client_admin_auth myClientAuth;
    private boolean myTrace = Utility.isTraceOn();
    private Tcpcfg2 myOwner;
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";

    public ClientProxy(Tcpcfg2 tcpcfg2, String string) {
        this.myOwner = tcpcfg2;
        this.myHostName = string;
        this.myBundle = ClientMsg.getBundle();
        this.myProfile = new NotebookProfile();
        this.myErrorListController = new ErrorListController();
        NativeData.getPaths();
        NativeData.getLprPortdPorts();
        this.theETCpath = NativeData.getEtcPath();
        HelpHandle.setFileSeparator(System.getProperty("file.separator"));
        if (this.myTrace) {
            System.out.println("In ClientProxy constructor - hostname = " + string);
        }
    }

    public boolean connectToServer() {
        this.myProfile = new NotebookProfile();
        this.myErrorListController = new ErrorListController();
        return true;
    }

    private void init() {
        this.myProfile = null;
        this.myErrorListController = null;
        this.myOwner = null;
    }

    private void initTrace() {
    }

    public boolean isRebootRequired() {
        return this.myProfile.getSetupDataHandle().isUpdated() || this.myProfile.getConfigDataHandle().isUpdated() || this.myProfile.getTcpstartDataHandle().isUpdated();
    }

    private void doDropServer() {
    }

    public ErrorListController getErrorListControllerDataHandle() {
        return this.myErrorListController;
    }

    public void shutdown() {
    }

    public boolean talkToNetwork(int n) {
        switch (n) {
            case 1: {
                this.myProfile.loadDataForLocalClient(this.myOwner, this.myErrorListController);
                break;
            }
            case 2: {
                this.myProfile.saveDataForLocalClient(this.myOwner, this.myErrorListController);
                break;
            }
            case 7: {
                NativeData.rebootServer();
                break;
            }
            default: {
                return false;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
        }
        return true;
    }

    public String getHostName() {
        return this.myHostName;
    }

    public NotebookProfile getNotebookProfileDataHandle() {
        return this.myProfile;
    }

    public void networkExceptionOccurred(Exception exception) {
        if (this.myTrace) {
            System.out.println("in ClientProxy.networkExceptionOccured - calling shutdown");
        }
        this.myOwner.shutDown();
    }
}

