/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.common;

import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.tcp.tcpcfg2.common.TcpError;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class ErrorListController {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String BER_tag = new String("Ber");
    public static final String EER_tag = new String("Eer");
    public static final String DATA_ID = new String("ERRORLIST");
    public static final String GET_ID = new String("GET_ERROR_LIST");
    public static final String PROCESS_ID = new String("PROCESS_ERROR_LIST");
    private static final String myEmbeddedError_tag = new String("EMBEDDED_ERROR_BELONGS_TO_BER");
    private static final String mySevereErrorsListCnt_tag = new String("numSev");
    private static final String myWarningErrorsListCnt_tag = new String("numWarn");
    private static final String myInformationErrorsListCnt_tag = new String("numInfo");
    private static final String myFatalErrorsListCnt_tag = new String("numFatal");
    private static final String mySevereError_tag = new String("errSev");
    private static final String myWarningError_tag = new String("errWarn");
    private static final String myInformationError_tag = new String("errInfo");
    private static final String myFatalError_tag = new String("errFatal");
    private static final String myLastMessageShownIndex_tag = new String("lastIdx");
    private static final String myLastMessageTypeShown_tag = new String("lastType");
    private static final String myLoadMessagesState_tag = new String("loadMsg_yn");
    private int mySevereErrorsListCnt;
    private int myWarningErrorsListCnt;
    private int myInformationErrorsListCnt;
    private int myFatalErrorsListCnt;
    private int myLastMessageShownIndex;
    private int myLastMessageTypeShown = 3;
    private boolean myLoadMessagesState = true;
    private Vector mySevereErrorsList = new Vector();
    private Vector myWarningErrorsList = new Vector();
    private Vector myInformationErrorsList = new Vector();
    private Vector myFatalErrorsList = new Vector();
    private boolean fatalErrorsAreShown = false;
    private boolean severeErrorsAreShown = false;
    private boolean warningErrorsAreShown = false;
    private boolean informationErrorsAreShown = false;
    private boolean myTrace = Utility.isTraceOn();

    public ErrorListController() {
        if (this.myTrace) {
            System.out.println("in constructor of ErrorListController");
        }
        this.loadInit();
    }

    public ErrorListController(ParsedVector parsedVector) {
        if (this.myTrace) {
            System.out.println("in ErrorListController(ParsedVector v)");
        }
        this.fromString(parsedVector);
    }

    public void addError(TcpError tcpError) {
        switch (tcpError.getType()) {
            case 0: {
                this.mySevereErrorsList.addElement(tcpError);
                this.mySevereErrorsListCnt = this.getErrorListSize(0);
                if (!this.myTrace) break;
                System.out.println("Adding Error in E.L.C. SEVERE_ERROR count = " + this.mySevereErrorsListCnt);
                return;
            }
            case 1: {
                this.myWarningErrorsList.addElement(tcpError);
                this.myWarningErrorsListCnt = this.getErrorListSize(1);
                if (!this.myTrace) break;
                System.out.println("Adding Error in E.L.C. WARNING_ERROR count = " + this.myWarningErrorsListCnt);
                return;
            }
            case 2: {
                this.myInformationErrorsList.addElement(tcpError);
                this.myInformationErrorsListCnt = this.getErrorListSize(2);
                if (!this.myTrace) break;
                System.out.println("Adding Error in E.L.C. INFORMATION_ERROR count = " + this.myInformationErrorsListCnt);
                return;
            }
            case 3: {
                this.myFatalErrorsList.addElement(tcpError);
                this.myFatalErrorsListCnt = this.getErrorListSize(3);
                if (!this.myTrace) break;
                System.out.println("Adding Error in E.L.C. FATAL_ERROR count = " + this.myFatalErrorsListCnt);
                return;
            }
            default: {
                tcpError.setType(2);
                this.myInformationErrorsList.addElement(tcpError);
                this.myInformationErrorsListCnt = this.getErrorListSize(2);
                if (!this.myTrace) break;
                System.out.println("Adding default in E.L.C. INFORMATION_ERROR count = " + this.myInformationErrorsListCnt);
            }
        }
    }

    public int getErrorListSize(int n) {
        switch (n) {
            case 0: {
                return this.mySevereErrorsList.size();
            }
            case 1: {
                return this.myWarningErrorsList.size();
            }
            case 2: {
                return this.myInformationErrorsList.size();
            }
            case 3: {
                if (this.myTrace) {
                    System.out.println("---- FATAL error list size = " + this.myFatalErrorsList.size());
                }
                return this.myFatalErrorsList.size();
            }
        }
        return this.myInformationErrorsList.size();
    }

    public TcpError getError(int n, int n2) {
        switch (n) {
            case 0: {
                return (TcpError)this.mySevereErrorsList.elementAt(n2);
            }
            case 1: {
                return (TcpError)this.myWarningErrorsList.elementAt(n2);
            }
            case 2: {
                return (TcpError)this.myInformationErrorsList.elementAt(n2);
            }
            case 3: {
                return (TcpError)this.myFatalErrorsList.elementAt(n2);
            }
        }
        return (TcpError)this.myInformationErrorsList.elementAt(n2);
    }

    public int getLastMessageShownIndex() {
        return this.myLastMessageShownIndex;
    }

    public int getLastMessageTypeShown() {
        return this.myLastMessageTypeShown;
    }

    public boolean isLoadMessages() {
        return this.myLoadMessagesState;
    }

    public boolean isMoreMessages() {
        if (this.myTrace) {
            System.out.println("in isMoreMessages() of ErrorListController");
        }
        int n = 0;
        int n2 = 0;
        if (!this.fatalErrorsAreShown) {
            if (this.myTrace) {
                System.out.println("in isMoreMessages() FATAL lastIdx = " + n + " errSize = " + n2);
            }
            n = this.getLastMessageShownIndex();
            n2 = this.getErrorListSize(3);
            if (n2 > 0 && n < n2) {
                this.setLastMessageTypeShown(3);
                return true;
            }
            this.setLastMessageShownIndex(0);
            this.fatalErrorsAreShown = true;
        }
        if (!this.severeErrorsAreShown) {
            if (this.myTrace) {
                System.out.println("in isMoreMessages() SEVERE lastIdx = " + n + " errSize = " + n2);
            }
            n = this.getLastMessageShownIndex();
            n2 = this.getErrorListSize(0);
            if (n2 > 0 && n < n2) {
                this.setLastMessageTypeShown(0);
                return true;
            }
            this.setLastMessageShownIndex(0);
            this.severeErrorsAreShown = true;
        }
        if (!this.warningErrorsAreShown) {
            if (this.myTrace) {
                System.out.println("in isMoreMessages() WARNING lastIdx = " + n + " errSize = " + n2);
            }
            n = this.getLastMessageShownIndex();
            n2 = this.getErrorListSize(1);
            if (n2 > 0 && n < n2) {
                this.setLastMessageTypeShown(1);
                return true;
            }
            this.setLastMessageShownIndex(0);
            this.warningErrorsAreShown = true;
        }
        if (!this.informationErrorsAreShown) {
            if (this.myTrace) {
                System.out.println("in isMoreMessages() INFORMATION lastIdx = " + n + " errSize = " + n2);
            }
            n = this.getLastMessageShownIndex();
            n2 = this.getErrorListSize(2);
            if (n2 > 0 && n < n2) {
                this.setLastMessageTypeShown(2);
                return true;
            }
            this.informationErrorsAreShown = true;
        }
        if (this.myTrace) {
            System.out.println("leaving isMoreMessages() of ErrorListController");
        }
        return false;
    }

    private void loadInit() {
        if (this.myTrace) {
            System.out.println("in loadInit() of ErrorListController");
        }
        this.mySevereErrorsListCnt = 0;
        this.myWarningErrorsListCnt = 0;
        this.myInformationErrorsListCnt = 0;
        this.myFatalErrorsListCnt = 0;
        this.mySevereErrorsList = new Vector();
        this.myWarningErrorsList = new Vector();
        this.myInformationErrorsList = new Vector();
        this.myFatalErrorsList = new Vector();
        this.myLastMessageShownIndex = 0;
        this.myLastMessageTypeShown = 3;
        this.fatalErrorsAreShown = false;
        this.severeErrorsAreShown = false;
        this.warningErrorsAreShown = false;
        this.informationErrorsAreShown = false;
    }

    public void setLastMessageShownIndex(int n) {
        this.myLastMessageShownIndex = n;
    }

    public void setLoadMessages(boolean bl) {
        this.myLoadMessagesState = bl;
    }

    public void setLastMessageTypeShown(int n) {
        this.myLastMessageTypeShown = n;
    }

    public void fromString(ParsedVector parsedVector) {
        String[] stringArray = parsedVector.getKeys();
        if (this.myTrace) {
            System.out.println("the num of keys is " + String.valueOf(stringArray.length));
        }
        int n = 0;
        while (n < stringArray.length) {
            ParsedVector parsedVector2;
            int n2;
            Integer n3;
            String string;
            ParsedObject parsedObject;
            if (stringArray[n].equals(myLastMessageShownIndex_tag)) {
                parsedObject = parsedVector.getElement(myLastMessageShownIndex_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n3 = Integer.valueOf(string);
                    this.myLastMessageShownIndex = n3;
                }
            } else if (stringArray[n].equals(myLastMessageTypeShown_tag)) {
                parsedObject = parsedVector.getElement(myLastMessageTypeShown_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n3 = Integer.valueOf(string);
                    this.myLastMessageTypeShown = n3;
                }
            } else if (stringArray[n].equals(mySevereErrorsListCnt_tag)) {
                parsedObject = parsedVector.getElement(mySevereErrorsListCnt_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n3 = Integer.valueOf(string);
                    this.mySevereErrorsListCnt = n3;
                    if (this.mySevereErrorsListCnt > 0) {
                        if (this.myTrace) {
                            System.out.println("in E.L.C..fromString() Num of Sev is " + this.mySevereErrorsListCnt);
                        }
                        this.mySevereErrorsList = new Vector(this.mySevereErrorsListCnt);
                        n2 = 1;
                        while (n2 <= this.mySevereErrorsListCnt) {
                            parsedObject = parsedVector.get(n + n2);
                            parsedVector2 = (ParsedVector)parsedObject.getValue();
                            if (parsedVector2 != null) {
                                this.mySevereErrorsList.addElement(new TcpError(parsedVector2));
                            }
                            ++n2;
                        }
                    } else {
                        this.mySevereErrorsList = new Vector();
                    }
                } else {
                    this.mySevereErrorsList = new Vector();
                }
            } else if (stringArray[n].equals(myWarningErrorsListCnt_tag)) {
                parsedObject = parsedVector.getElement(myWarningErrorsListCnt_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n3 = Integer.valueOf(string);
                    this.myWarningErrorsListCnt = n3;
                    if (this.myWarningErrorsListCnt > 0) {
                        if (this.myTrace) {
                            System.out.println("in E.L.C..fromString() Num of Warn is " + this.myWarningErrorsListCnt);
                        }
                        this.myWarningErrorsList = new Vector(this.myWarningErrorsListCnt);
                        n2 = 1;
                        while (n2 <= this.myWarningErrorsListCnt) {
                            parsedObject = parsedVector.get(n + n2);
                            parsedVector2 = (ParsedVector)parsedObject.getValue();
                            if (parsedVector2 != null) {
                                this.myWarningErrorsList.addElement(new TcpError(parsedVector2));
                            }
                            ++n2;
                        }
                    } else {
                        this.myWarningErrorsList = new Vector();
                    }
                } else {
                    this.myWarningErrorsList = new Vector();
                }
            } else if (stringArray[n].equals(myInformationErrorsListCnt_tag)) {
                parsedObject = parsedVector.getElement(myInformationErrorsListCnt_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n3 = Integer.valueOf(string);
                    this.myInformationErrorsListCnt = n3;
                    if (this.myInformationErrorsListCnt > 0) {
                        if (this.myTrace) {
                            System.out.println("in E.L.C..fromString() Num of Info is " + this.myInformationErrorsListCnt);
                        }
                        this.myInformationErrorsList = new Vector(this.myInformationErrorsListCnt);
                        n2 = 1;
                        while (n2 <= this.myInformationErrorsListCnt) {
                            parsedObject = parsedVector.get(n + n2);
                            parsedVector2 = (ParsedVector)parsedObject.getValue();
                            if (parsedVector2 != null) {
                                this.myInformationErrorsList.addElement(new TcpError(parsedVector2));
                            }
                            ++n2;
                        }
                    } else {
                        this.myInformationErrorsList = new Vector();
                    }
                } else {
                    this.myInformationErrorsList = new Vector();
                }
            } else if (stringArray[n].equals(myFatalErrorsListCnt_tag)) {
                parsedObject = parsedVector.getElement(myFatalErrorsListCnt_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n3 = Integer.valueOf(string);
                    this.myFatalErrorsListCnt = n3;
                    if (this.myFatalErrorsListCnt > 0) {
                        if (this.myTrace) {
                            System.out.println("in E.L.C..fromString() Num of FATAL is " + this.myFatalErrorsListCnt);
                        }
                        this.myFatalErrorsList = new Vector(this.myFatalErrorsListCnt);
                        n2 = 1;
                        while (n2 <= this.myFatalErrorsListCnt) {
                            parsedObject = parsedVector.get(n + n2);
                            parsedVector2 = (ParsedVector)parsedObject.getValue();
                            if (parsedVector2 != null) {
                                this.myFatalErrorsList.addElement(new TcpError(parsedVector2));
                            }
                            ++n2;
                        }
                    } else {
                        this.myFatalErrorsList = new Vector();
                    }
                } else {
                    this.myFatalErrorsList = new Vector();
                }
            } else if (stringArray[n].equals(myLoadMessagesState_tag) && (string = (String)(parsedObject = parsedVector.getElement(myLoadMessagesState_tag)).getValue()) != null) {
                n3 = Integer.valueOf(string);
                this.myLoadMessagesState = n3 != 0;
            }
            ++n;
        }
    }

    public String toString() {
        TcpError tcpError;
        StringBuffer stringBuffer = new StringBuffer(BER_tag);
        if (this.myTrace) {
            System.out.println("in ErrorListController.toString() ");
        }
        stringBuffer.append("," + myLastMessageShownIndex_tag + "=" + this.myLastMessageShownIndex);
        stringBuffer.append("," + myLastMessageTypeShown_tag + "=" + this.myLastMessageTypeShown);
        stringBuffer.append("," + mySevereErrorsListCnt_tag + "=" + String.valueOf(this.mySevereErrorsList.size()));
        Enumeration enumeration = this.mySevereErrorsList.elements();
        while (enumeration.hasMoreElements()) {
            try {
                tcpError = (TcpError)enumeration.nextElement();
                stringBuffer.append("," + myEmbeddedError_tag);
                stringBuffer.append("," + tcpError.toString());
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
        }
        stringBuffer.append("," + myWarningErrorsListCnt_tag + "=" + String.valueOf(this.myWarningErrorsList.size()));
        enumeration = this.myWarningErrorsList.elements();
        while (enumeration.hasMoreElements()) {
            try {
                tcpError = (TcpError)enumeration.nextElement();
                stringBuffer.append("," + myEmbeddedError_tag);
                stringBuffer.append("," + tcpError.toString());
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
        }
        stringBuffer.append("," + myInformationErrorsListCnt_tag + "=" + String.valueOf(this.myInformationErrorsList.size()));
        enumeration = this.myInformationErrorsList.elements();
        while (enumeration.hasMoreElements()) {
            try {
                tcpError = (TcpError)enumeration.nextElement();
                stringBuffer.append("," + myEmbeddedError_tag);
                stringBuffer.append("," + tcpError.toString());
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
        }
        stringBuffer.append("," + myFatalErrorsListCnt_tag + "=" + String.valueOf(this.myFatalErrorsList.size()));
        enumeration = this.myFatalErrorsList.elements();
        while (enumeration.hasMoreElements()) {
            try {
                tcpError = (TcpError)enumeration.nextElement();
                stringBuffer.append("," + myEmbeddedError_tag);
                stringBuffer.append("," + tcpError.toString());
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
        }
        if (this.myLoadMessagesState) {
            stringBuffer.append("," + myLoadMessagesState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myLoadMessagesState_tag + "=" + 0);
        }
        stringBuffer.append("," + EER_tag);
        if (this.myTrace) {
            System.out.println("end of to string " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }
}

