/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.common;

import COM.ibm.raleigh.tcp.tcpcfg2.common.ErrorListController;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NFSData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NFSDirEntry;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import COM.ibm.raleigh.tcp.tcpcfg2.server.ServerMsg;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class ExportsDataLoader {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    ErrorListController myErrorListController;
    private NFSData myNFSData;
    private String myExportsFile;
    private ResourceBundle myBundle;
    private boolean myTrace = Utility.isTraceOn();
    private int existingDirIdx = -1;

    public ExportsDataLoader(String string, NFSData nFSData, ErrorListController errorListController) {
        if (this.myTrace) {
            System.out.println("in ExportsDataLoader() constructor2");
        }
        this.myNFSData = nFSData;
        this.myExportsFile = string;
        this.loadInit();
        this.myBundle = ServerMsg.getBundle();
        this.myErrorListController = errorListController;
    }

    private String appendAliasList(NFSDirEntry nFSDirEntry, StringTokenizer stringTokenizer) {
        StringBuffer stringBuffer = new StringBuffer(stringTokenizer.nextToken());
        boolean bl = false;
        String string = null;
        while (!bl) {
            try {
                string = stringTokenizer.nextToken();
                if (this.isAliasToken(string)) {
                    stringBuffer.append(" " + string);
                    continue;
                }
                bl = true;
                nFSDirEntry.setAlias(stringBuffer.toString());
                return string;
            }
            catch (NoSuchElementException noSuchElementException) {
                bl = true;
                nFSDirEntry.setAlias(stringBuffer.toString());
                return null;
            }
        }
        return null;
    }

    private String appendComment(NFSDirEntry nFSDirEntry, StringTokenizer stringTokenizer) {
        StringBuffer stringBuffer = new StringBuffer("# ");
        String string = null;
        boolean bl = false;
        while (!bl) {
            try {
                string = stringTokenizer.nextToken();
                stringBuffer.append(String.valueOf(string) + " ");
            }
            catch (NoSuchElementException noSuchElementException) {
                bl = true;
                return stringBuffer.toString();
            }
        }
        return stringBuffer.toString();
    }

    private String appendHostList(NFSDirEntry nFSDirEntry, StringTokenizer stringTokenizer, String string) {
        boolean bl = false;
        if (string.equalsIgnoreCase("-ro")) {
            nFSDirEntry.setReadOnly(true);
            while (!bl) {
                try {
                    string = stringTokenizer.nextToken();
                    if (this.isHostToken(string)) {
                        nFSDirEntry.setReadOnly(false);
                        nFSDirEntry.setSpecifyHosts(true);
                        if (nFSDirEntry.isHostInList(string, true)) continue;
                        nFSDirEntry.addReadHost(string);
                        continue;
                    }
                    bl = true;
                    return string;
                }
                catch (NoSuchElementException noSuchElementException) {
                    bl = true;
                    return null;
                }
            }
        } else {
            nFSDirEntry.setReadWrite(true);
            while (!bl) {
                try {
                    string = stringTokenizer.nextToken();
                    if (this.isHostToken(string)) {
                        nFSDirEntry.setReadWrite(false);
                        nFSDirEntry.setSpecifyHosts(true);
                        if (nFSDirEntry.isHostInList(string, false)) continue;
                        nFSDirEntry.addReadWriteHost(string);
                        continue;
                    }
                    bl = true;
                    return string;
                }
                catch (NoSuchElementException noSuchElementException) {
                    bl = true;
                    return null;
                }
            }
        }
        return null;
    }

    private void createLine(NFSDirEntry nFSDirEntry, BufferedWriter bufferedWriter) {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2;
        if (!Utility.hasValue(nFSDirEntry.getDirectory())) {
            StringBuffer stringBuffer3 = new StringBuffer();
            this.bufComments(nFSDirEntry, stringBuffer3);
            this.writeIt(bufferedWriter, stringBuffer3.toString());
            return;
        }
        int n = nFSDirEntry.getReadHostListSize();
        if (n > 0 && nFSDirEntry.isSpecifyHosts()) {
            stringBuffer2 = new StringBuffer();
            this.bufDir(nFSDirEntry, stringBuffer2);
            this.bufAlias(nFSDirEntry, stringBuffer2);
            this.bufHosts(nFSDirEntry, stringBuffer2, true);
            this.bufComments(nFSDirEntry, stringBuffer2);
            this.writeIt(bufferedWriter, stringBuffer2.toString());
        } else if (nFSDirEntry.isReadOnly()) {
            stringBuffer2 = new StringBuffer();
            this.bufDir(nFSDirEntry, stringBuffer2);
            this.bufAlias(nFSDirEntry, stringBuffer2);
            this.bufHosts(nFSDirEntry, stringBuffer2, true);
            this.bufComments(nFSDirEntry, stringBuffer2);
            this.writeIt(bufferedWriter, stringBuffer2.toString());
        }
        int n2 = nFSDirEntry.getReadWriteHostListSize();
        if (n2 > 0 && nFSDirEntry.isSpecifyHosts()) {
            stringBuffer = new StringBuffer();
            this.bufDir(nFSDirEntry, stringBuffer);
            this.bufAlias(nFSDirEntry, stringBuffer);
            this.bufHosts(nFSDirEntry, stringBuffer, false);
            this.bufComments(nFSDirEntry, stringBuffer);
            this.writeIt(bufferedWriter, stringBuffer.toString());
        } else if (nFSDirEntry.isReadWrite()) {
            stringBuffer = new StringBuffer();
            this.bufDir(nFSDirEntry, stringBuffer);
            this.bufAlias(nFSDirEntry, stringBuffer);
            this.bufHosts(nFSDirEntry, stringBuffer, false);
            this.bufComments(nFSDirEntry, stringBuffer);
            this.writeIt(bufferedWriter, stringBuffer.toString());
        }
        if (nFSDirEntry.isSpecifyHosts() && nFSDirEntry.getReadHostListSize() == 0 && nFSDirEntry.getReadWriteHostListSize() == 0) {
            stringBuffer = new StringBuffer();
            this.bufDir(nFSDirEntry, stringBuffer);
            this.bufAlias(nFSDirEntry, stringBuffer);
            this.bufComments(nFSDirEntry, stringBuffer);
            this.writeIt(bufferedWriter, stringBuffer.toString());
        }
        if (nFSDirEntry.isPublic()) {
            stringBuffer = new StringBuffer();
            this.bufDir(nFSDirEntry, stringBuffer);
            this.bufPublic(nFSDirEntry, stringBuffer);
            this.writeIt(bufferedWriter, stringBuffer.toString());
        }
    }

    private void writeIt(BufferedWriter bufferedWriter, String string) {
        try {
            bufferedWriter.write(string, 0, string.length());
            bufferedWriter.flush();
            bufferedWriter.newLine();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }

    private void bufDir(NFSDirEntry nFSDirEntry, StringBuffer stringBuffer) {
        if (Utility.hasPound(nFSDirEntry.getDirectory())) {
            stringBuffer.append("\"" + nFSDirEntry.getDirectory() + "\"");
            return;
        }
        stringBuffer.append(nFSDirEntry.getDirectory());
    }

    private void bufAlias(NFSDirEntry nFSDirEntry, StringBuffer stringBuffer) {
        if (Utility.hasValue(nFSDirEntry.getAlias())) {
            stringBuffer.append(" -alias ");
            StringTokenizer stringTokenizer = new StringTokenizer(nFSDirEntry.getAlias());
            if (stringTokenizer.countTokens() > 1) {
                stringBuffer.append("\"" + nFSDirEntry.getAlias() + "\"");
                return;
            }
            stringBuffer.append(nFSDirEntry.getAlias());
        }
    }

    private void bufComments(NFSDirEntry nFSDirEntry, StringBuffer stringBuffer) {
        if (Utility.hasValue(nFSDirEntry.getComments())) {
            stringBuffer.append(" " + nFSDirEntry.getComments());
        }
    }

    private void bufPublic(NFSDirEntry nFSDirEntry, StringBuffer stringBuffer) {
        stringBuffer.append(" public");
    }

    private void bufHosts(NFSDirEntry nFSDirEntry, StringBuffer stringBuffer, boolean bl) {
        int n = 0;
        if (bl) {
            n = nFSDirEntry.getReadHostListSize();
            stringBuffer.append(" -ro");
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(" " + nFSDirEntry.getReadHost(n2));
                ++n2;
            }
            return;
        }
        n = nFSDirEntry.getReadWriteHostListSize();
        stringBuffer.append(" -rw");
        int n3 = 0;
        while (n3 < n) {
            stringBuffer.append(" " + nFSDirEntry.getReadWriteHost(n3));
            ++n3;
        }
    }

    private boolean isHostToken(String string) {
        if (string == null) {
            return false;
        }
        return !string.startsWith("-") && !string.startsWith("#");
    }

    private boolean isAliasToken(String string) {
        if (string == null) {
            return false;
        }
        return !string.startsWith("-") && !string.startsWith("#");
    }

    private void dumpTokens(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        if (this.myTrace) {
            int n2 = 0;
            while (n2 < n) {
                System.out.println("dump = " + stringTokenizer.nextToken());
                ++n2;
            }
        }
    }

    private void loadInit() {
        if (this.myTrace) {
            System.out.println("in loadInit() of ExportsDataLoader");
        }
        this.myErrorListController = null;
    }

    private void parseTokens(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = null;
        try {
            string2 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
        NFSDirEntry nFSDirEntry = null;
        this.existingDirIdx = -1;
        if (!string2.startsWith("#")) {
            this.existingDirIdx = this.myNFSData.isDirCreated(string2);
        }
        nFSDirEntry = this.existingDirIdx >= 0 ? this.myNFSData.getNFSDirEntry(this.existingDirIdx) : new NFSDirEntry();
        if (string2.startsWith("#")) {
            nFSDirEntry.setComments(string);
            this.updateDirEntry(nFSDirEntry, this.existingDirIdx);
            return;
        }
        nFSDirEntry.setDirectory(string2);
        try {
            string2 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            this.updateDirEntry(nFSDirEntry, this.existingDirIdx);
            return;
        }
        if (string2.startsWith("#")) {
            this.appendComment(nFSDirEntry, stringTokenizer);
            this.updateDirEntry(nFSDirEntry, this.existingDirIdx);
            return;
        }
        if (string2.startsWith("-") && string2.equalsIgnoreCase("-alias") && (string2 = this.appendAliasList(nFSDirEntry, stringTokenizer)) == null) {
            this.updateDirEntry(nFSDirEntry, this.existingDirIdx);
            return;
        }
        if (string2.startsWith("-")) {
            string2 = this.appendHostList(nFSDirEntry, stringTokenizer, string2);
        }
        if (string2 == null) {
            this.updateDirEntry(nFSDirEntry, this.existingDirIdx);
            return;
        }
        if (string2.startsWith("-")) {
            string2 = this.appendHostList(nFSDirEntry, stringTokenizer, string2);
        }
        if (string2.startsWith("#")) {
            nFSDirEntry.setComments(this.appendComment(nFSDirEntry, stringTokenizer));
            this.updateDirEntry(nFSDirEntry, this.existingDirIdx);
            return;
        }
        if (string2 != null) {
            if (this.myTrace) {
                System.out.println("WHAT IS THIS??? ExportsDataLoader.parseTokens() token = " + string2 + " text = " + string);
                return;
            }
        } else {
            if (this.myTrace) {
                System.out.println("adding NFSDirEntry = " + nFSDirEntry.toString());
            }
            this.updateDirEntry(nFSDirEntry, this.existingDirIdx);
        }
    }

    private void updateDirEntry(NFSDirEntry nFSDirEntry, int n) {
        if (n < 0) {
            this.myNFSData.addNFSDirEntry(nFSDirEntry);
            return;
        }
        this.myNFSData.replaceNFSDirEntry(nFSDirEntry, n);
    }

    public void loadNFS() {
        if (this.myTrace) {
            System.out.println("in loadNFS() of NFSDataLoader");
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.myExportsFile));
            String string = null;
            boolean bl = true;
            while (bl) {
                try {
                    string = bufferedReader.readLine();
                    if (string == null) {
                        bl = false;
                        bufferedReader.close();
                        continue;
                    }
                    this.parseTokens(string);
                }
                catch (IOException iOException) {
                    bl = false;
                    iOException.printStackTrace();
                }
            }
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (this.myTrace) {
                System.out.println("File not found");
            }
            return;
        }
    }

    public void saveNFS() {
        if (this.myTrace) {
            System.out.println("in saveNFS() of NFSDataLoader");
        }
        int n = this.myNFSData.getNFSDirEntryListSize();
        try {
            BufferedWriter bufferedWriter = null;
            bufferedWriter = new BufferedWriter(new FileWriter(this.myExportsFile));
            if (n > 0) {
                int n2 = 0;
                while (n2 < n) {
                    NFSDirEntry nFSDirEntry = this.myNFSData.getNFSDirEntry(n2);
                    this.createLine(nFSDirEntry, bufferedWriter);
                    ++n2;
                }
            }
            bufferedWriter.close();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }
}

