/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.common;

import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCConfiguration;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCConstants;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCKeyword;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCMessageQueue;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCProductInfo;
import COM.ibm.raleigh.tcp.tcpcfg2.common.ErrorListController;
import COM.ibm.raleigh.tcp.tcpcfg2.common.HostsEntry;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NotebookData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.TcpError;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import COM.ibm.raleigh.tcp.tcpcfg2.server.NativeData;
import COM.ibm.raleigh.tcp.tcpcfg2.server.ServerMsg;
import java.io.File;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Vector;

public class HostsData
extends NotebookData
implements OOCConstants {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String BHD_tag = new String("Bhd");
    public static final String EHD_tag = new String("Ehd");
    public static final String DATA_ID = new String("HOSTSDATA");
    public static final String SAVE_ID = new String("SAVE_HOSTS_DATA");
    public static final String LOAD_ID = new String("LOAD_HOSTS_DATA");
    private static final String myHostsEntryListCnt_tag = new String("HDhecnt");
    private static final String myHostsEntryList_tag = new String("EMBEDDED_BHO_BELONGS_TO_BHD");
    private static final String myUpdatedState_tag = new String("updated_yn");
    private String myEtcPath;
    private Vector myHostsEntryList;
    private int myHostsEntryListCnt;
    private OOCProductInfo myHostsDataProductInfo;
    private OOCConfiguration myHostsDataConfiguration;
    private OOCMessageQueue myMessageQueue;
    private OOCKeyword kwHosts;
    private NativeData myNativeData;
    private String hostsdataDatFile;
    private String hostsdataConfigFile;
    private String logFile;
    private String hostsdatabakFile;
    private static final String hostsdataParseRules = "HOSTS_RULES";
    private boolean noExistingHostsData = false;
    private boolean noProductInfo = false;
    private boolean already_closed = false;
    ErrorListController myErrorListController;
    private ResourceBundle myBundle;
    private boolean myTrace = Utility.isTraceOn();

    public HostsData() {
        if (this.myTrace) {
            System.out.println("in HostsData() constructor");
        }
        this.loadInit();
        this.myBundle = ServerMsg.getBundle();
    }

    public HostsData(boolean bl, ErrorListController errorListController) {
        if (this.myTrace) {
            System.out.println("in HostsData() constructor2");
        }
        this.loadInit();
        this.myBundle = ServerMsg.getBundle();
        this.myErrorListController = errorListController;
        if (bl) {
            this.loadFromOOCS();
        }
    }

    public HostsData(ParsedVector parsedVector) {
        if (this.myTrace) {
            System.out.println("@@@@@@@@@ CONSRUCTING HostsData from a ParsedVector");
        }
        this.fromString(parsedVector);
    }

    public void addHostsEntry(HostsEntry hostsEntry) {
        this.myHostsEntryList.addElement(hostsEntry);
        this.myHostsEntryListCnt = this.getHostsEntryListSize();
    }

    private void loadInit() {
        if (this.myTrace) {
            System.out.println("in loadInit() of HostsData");
        }
        this.myHostsEntryList = new Vector();
        this.myHostsEntryListCnt = 0;
        this.myErrorListController = null;
    }

    public void deleteHostsEntry(int n) {
        this.myHostsEntryList.removeElementAt(n);
        this.myHostsEntryListCnt = this.getHostsEntryListSize();
    }

    public void deleteHostsList() {
        this.myHostsEntryList.removeAllElements();
        this.myHostsEntryListCnt = 0;
    }

    public int getHostsEntryListSize() {
        return this.myHostsEntryList.size();
    }

    public HostsEntry getHostsEntry(int n) {
        return (HostsEntry)this.myHostsEntryList.elementAt(n);
    }

    private void loadFromOOCS() {
        int n;
        if (this.myTrace) {
            System.out.println("in loadFromOOCS() of HostsData");
        }
        this.myEtcPath = NativeData.getEtcPath();
        this.hostsdataDatFile = String.valueOf(this.myEtcPath) + "dat" + File.separator + "toxhosts.dat";
        this.hostsdataConfigFile = String.valueOf(this.myEtcPath) + "hosts";
        this.hostsdatabakFile = String.valueOf(this.myEtcPath) + "hosts.nbk";
        this.logFile = String.valueOf(this.myEtcPath) + "tcpcfg2.log";
        this.myHostsDataProductInfo = new OOCProductInfo();
        if (this.myTrace) {
            System.out.println("(HostsData.loadFromOOCS) myHostsDataProductInfo setupDatFile = " + this.hostsdataDatFile);
        }
        if ((n = this.myHostsDataProductInfo.create(this.hostsdataDatFile)) == 0) {
            if (this.myTrace) {
                System.out.println("(HostsData.loadFromOOCS) myHostsDataProductInfo.create successful");
            }
            this.myHostsDataProductInfo.setFileOpenMode(3);
            this.myHostsDataProductInfo.setFileShareMode(0);
            this.myHostsDataProductInfo.setProcessingOptions(1, 1, 1);
            this.myHostsDataProductInfo.setParsingInfo(hostsdataParseRules);
            this.myHostsDataConfiguration = new OOCConfiguration();
            if (this.myTrace) {
                System.out.println("(HostsData.loadFromOOCS) mySetupConfiguration hostdataConfigFile = " + this.hostsdataConfigFile);
            }
            if ((n = this.myHostsDataConfiguration.open(this.myHostsDataProductInfo, this.hostsdataConfigFile)) == 2) {
                n = this.myHostsDataConfiguration.open(this.myHostsDataProductInfo, "");
                if (this.myTrace) {
                    System.out.println("(HostsData.loadFromOOCS) myHostsDataConfiguration.create successful...no preexisting file");
                }
                this.noExistingHostsData = true;
            }
            if (this.myTrace) {
                System.out.println("(HostsData.loadFromOOCS) myHostsDataConfiguration.create successful");
            }
        } else {
            this.noProductInfo = true;
            if (this.myTrace) {
                System.out.println("(HostsData.loadFromOOCS) ERROR: myHostsDataProductInfo.create failed");
            }
            OOCMessageQueue oOCMessageQueue = OOCMessageQueue.getStaticMsgQ();
            oOCMessageQueue.replaceLogFile(0);
            oOCMessageQueue.setLogFileName(this.logFile);
            oOCMessageQueue.setLogOption(2);
            oOCMessageQueue.logQueue();
            if (this.myTrace) {
                System.out.println("(SetupData.loadFromOOCS) Messages were logged to filename " + this.logFile);
            }
            return;
        }
        this.myHostsDataConfiguration.write(this.hostsdatabakFile, 1, 1, 1, 0, hostsdataParseRules);
        this.myMessageQueue = this.myHostsDataConfiguration.getMsgQ();
        this.myMessageQueue.replaceLogFile(0);
        this.myMessageQueue.setLogFileName(this.logFile);
        this.myMessageQueue.setLogOption(1);
        this.myMessageQueue.logQueue();
        this.myHostsDataProductInfo.close();
        this.kwHosts = this.myHostsDataConfiguration.get("hosts", "");
        while (this.kwHosts != null) {
            HostsEntry hostsEntry = new HostsEntry();
            hostsEntry.loadHostsEntryFromOOCS(this.kwHosts);
            this.addHostsEntry(hostsEntry);
            this.kwHosts = this.kwHosts.nextOf();
        }
    }

    public void saveToOOCS() {
        Object[] objectArray;
        int n;
        if (this.myTrace) {
            System.out.println("in saveToOOCS() of HostsData");
        }
        this.kwHosts = this.myHostsDataConfiguration.get("hosts", "");
        while (this.kwHosts != null) {
            this.myHostsDataConfiguration.deleteKeyword("hosts", "");
            this.kwHosts = this.kwHosts.nextOf();
        }
        int n2 = this.getHostsEntryListSize();
        if (this.myTrace) {
            System.out.println("numHosts = " + n2);
        }
        if (n2 > 0) {
            this.kwHosts = this.myHostsDataConfiguration.get("hosts", "");
            n = 0;
            while (n < n2) {
                objectArray = this.getHostsEntry(n);
                objectArray.saveHostsEntryToOOCS(this.myHostsDataConfiguration, this.kwHosts);
                ++n;
            }
        }
        if ((n = this.myHostsDataConfiguration.write(this.hostsdataConfigFile, 1, 1, 1, 0, hostsdataParseRules)) == 1) {
            if (this.myTrace) {
                System.out.println("(HostsData.saveToOOCS) Successful write to hosts");
            }
        } else {
            if (this.myTrace) {
                System.out.println("(HostsData.saveToOOCS) Unsuccessful write to hosts");
            }
            objectArray = new Object[]{"hosts"};
            TcpError tcpError = new TcpError(MessageFormat.format(this.myBundle.getString("WARNING_FILE_NOT_WRITTEN"), objectArray), 1);
            this.myErrorListController.addError(tcpError);
            this.myMessageQueue.logQueue();
        }
        this.closeOOCS();
    }

    public void closeOOCS() {
        if (this.already_closed) {
            return;
        }
        this.already_closed = true;
        int n = this.myHostsDataConfiguration.close();
        if (this.myTrace) {
            System.out.println("(HostsData.closeOOCS) rc from myHostsDataConfiguration.close = " + n);
        }
    }

    public void fromString(ParsedVector parsedVector) {
        String[] stringArray = parsedVector.getKeys();
        int n = 0;
        while (n < stringArray.length) {
            Integer n2;
            String string;
            ParsedObject parsedObject;
            if (stringArray[n].equals(myHostsEntryListCnt_tag)) {
                parsedObject = parsedVector.getElement(myHostsEntryListCnt_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myHostsEntryListCnt = n2;
                    if (this.myHostsEntryListCnt > 0) {
                        this.myHostsEntryList = new Vector(this.myHostsEntryListCnt);
                        int n3 = 1;
                        while (n3 <= this.myHostsEntryListCnt) {
                            parsedObject = parsedVector.get(n + n3);
                            ParsedVector parsedVector2 = (ParsedVector)parsedObject.getValue();
                            if (parsedVector2 != null) {
                                this.myHostsEntryList.addElement(new HostsEntry(parsedVector2));
                            }
                            ++n3;
                        }
                    } else {
                        this.myHostsEntryList = new Vector();
                    }
                } else {
                    this.myHostsEntryList = new Vector();
                }
            } else if (stringArray[n].equals(myUpdatedState_tag) && (string = (String)(parsedObject = parsedVector.getElement(myUpdatedState_tag)).getValue()) != null) {
                n2 = Integer.valueOf(string);
                if (n2 == 0) {
                    this.setUpdated(false);
                } else {
                    this.setUpdated(true);
                }
            }
            ++n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(BHD_tag);
        if (this.isUpdated()) {
            stringBuffer.append("," + myUpdatedState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myUpdatedState_tag + "=" + 0);
        }
        stringBuffer.append("," + myHostsEntryListCnt_tag + "=" + String.valueOf(this.myHostsEntryList.size()));
        Enumeration enumeration = this.myHostsEntryList.elements();
        while (enumeration.hasMoreElements()) {
            try {
                HostsEntry hostsEntry = (HostsEntry)enumeration.nextElement();
                stringBuffer.append("," + myHostsEntryList_tag);
                stringBuffer.append("," + hostsEntry.toString());
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
        }
        stringBuffer.append("," + EHD_tag);
        return stringBuffer.toString();
    }
}

