/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.common;

import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.tcp.tcpcfg2.common.CloneableItem;
import COM.ibm.raleigh.tcp.tcpcfg2.common.ErrorListController;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NotebookData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Vector;

public class NFSDirEntry
extends NotebookData
implements CloneableItem {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String BND_tag = new String("Bnd");
    public static final String END_tag = new String("End");
    private static final String myReadHostCount_tag = new String("Rcnt");
    private static final String myReadHost_tag = new String("Rlist");
    private static final String myReadWriteHostCount_tag = new String("RWcnt");
    private static final String myReadWriteHost_tag = new String("RWlist");
    private static final String myEnabledState_tag = new String("Est_yn");
    private static final String myUpdatedState_tag = new String("updated_yn");
    private static final String myDirectory_tag = new String("Dir");
    private static final String myAlias_tag = new String("Alias");
    private static final String myComments_tag = new String("com");
    private static final String myPublicState_tag = new String("pub_yn");
    private static final String mySpecifyState_tag = new String("spec_yn");
    private static final String myReadOnlyState_tag = new String("ro_yn");
    private static final String myReadWriteState_tag = new String("rw_yn");
    ErrorListController myErrorListController;
    private ResourceBundle myBundle;
    private boolean myTrace = Utility.isTraceOn();
    private Vector myReadHostList;
    private Vector myReadWriteHostList;
    private int myReadHostCount;
    private int myReadWriteHostCount;
    private boolean myPublicState = false;
    private boolean mySpecifyState = true;
    private boolean myReadOnlyState = false;
    private boolean myReadWriteState = false;
    private String myDirectory;
    private String myAlias;
    private String myComments;
    private boolean myEnabledState = false;

    public NFSDirEntry() {
        if (this.myTrace) {
            System.out.println("in NFSDirEntry() constructor");
        }
        this.loadInit();
    }

    public NFSDirEntry(String string) {
        if (this.myTrace) {
            System.out.println("in NFSDirEntry(String) constructor2");
        }
        this.loadInit();
        this.myDirectory = string;
    }

    public NFSDirEntry(ParsedVector parsedVector) {
        if (this.myTrace) {
            System.out.println("@@@@@@@@@ CONSRUCTING DirectRouteEntry from a ParsedVector");
        }
        this.fromString(parsedVector);
    }

    public Object clone() {
        NFSDirEntry nFSDirEntry = new NFSDirEntry();
        nFSDirEntry.setDirectory(new String(this.myDirectory));
        nFSDirEntry.setAlias(new String(this.myAlias));
        nFSDirEntry.setComments(new String(this.myComments));
        int n = this.getReadHostListSize();
        int n2 = 0;
        while (n2 < n) {
            nFSDirEntry.addReadHost(new String(this.getReadHost(n2)));
            ++n2;
        }
        int n3 = this.getReadWriteHostListSize();
        int n4 = 0;
        while (n4 < n3) {
            nFSDirEntry.addReadWriteHost(new String(this.getReadWriteHost(n4)));
            ++n4;
        }
        return nFSDirEntry;
    }

    public void addReadHost(String string) {
        if (this.myTrace) {
            System.out.println("in NFSDirEntry.addReadHost, host = " + string);
        }
        if (!this.isHostInList(string, true)) {
            this.myReadHostList.addElement(string);
            this.myReadHostCount = this.getReadHostListSize();
        }
    }

    public void addReadWriteHost(String string) {
        if (this.myTrace) {
            System.out.println("in NFSDirEntry.addReadWriteHost, host = " + string);
        }
        if (!this.isHostInList(string, false)) {
            this.myReadWriteHostList.addElement(string);
            this.myReadWriteHostCount = this.getReadWriteHostListSize();
        }
    }

    public void deleteReadHostList() {
        this.myReadHostList.removeAllElements();
        this.myReadHostCount = this.getReadHostListSize();
    }

    public void deleteReadWriteHostList() {
        this.myReadWriteHostList.removeAllElements();
        this.myReadWriteHostCount = this.getReadWriteHostListSize();
    }

    public String getDirectory() {
        return this.myDirectory;
    }

    public String getAlias() {
        return this.myAlias;
    }

    public String getComments() {
        return this.myComments;
    }

    public String getReadHost(int n) {
        if (this.myTrace) {
            if (this.myReadHostList == null) {
                System.out.println("In NFSDirEntry, getReadHost()  myReadHostList == null");
            } else {
                System.out.println("In NFSDirEntry, getReadHost()  myReadHostList != null");
            }
        }
        return (String)this.myReadHostList.elementAt(n);
    }

    public String getReadWriteHost(int n) {
        return (String)this.myReadWriteHostList.elementAt(n);
    }

    public int getReadHostListSize() {
        return this.myReadHostList.size();
    }

    public int getReadWriteHostListSize() {
        return this.myReadWriteHostList.size();
    }

    public boolean isHostInList(String string, boolean bl) {
        if (!Utility.hasValue(string)) {
            return false;
        }
        if (bl) {
            int n = this.getReadHostListSize();
            int n2 = 0;
            while (n2 < n) {
                String string2 = (String)this.myReadHostList.elementAt(n2);
                if (string2.compareTo(string) == 0) {
                    return true;
                }
                ++n2;
            }
        } else {
            int n = this.getReadWriteHostListSize();
            int n3 = 0;
            while (n3 < n) {
                String string3 = (String)this.myReadWriteHostList.elementAt(n3);
                if (string3.compareTo(string) == 0) {
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }

    public boolean isEnabled() {
        return this.myEnabledState;
    }

    public boolean isPublic() {
        return this.myPublicState;
    }

    public boolean isSpecifyHosts() {
        return this.mySpecifyState;
    }

    public boolean isReadOnly() {
        return this.myReadOnlyState;
    }

    public boolean isReadWrite() {
        return this.myReadWriteState;
    }

    private void loadInit() {
        if (this.myTrace) {
            System.out.println("in loadInit() of NFSDirEntry");
        }
        this.myReadHostList = new Vector();
        this.myReadWriteHostList = new Vector();
        this.myReadHostCount = 0;
        this.myReadWriteHostCount = 0;
        this.myEnabledState = false;
        this.myPublicState = false;
        this.mySpecifyState = true;
        this.myReadOnlyState = false;
        this.myReadWriteState = false;
        this.myDirectory = new String("");
        this.myAlias = new String("");
        this.myComments = new String("");
        this.myErrorListController = null;
    }

    public void setPublic(boolean bl) {
        this.myPublicState = bl;
    }

    public void setSpecifyHosts(boolean bl) {
        this.mySpecifyState = bl;
    }

    public void setReadOnly(boolean bl) {
        this.myReadOnlyState = bl;
    }

    public void setReadWrite(boolean bl) {
        this.myReadWriteState = bl;
    }

    public void setDirectory(String string) {
        this.myDirectory = string;
    }

    public void setAlias(String string) {
        this.myAlias = string;
    }

    public void setComments(String string) {
        this.myComments = string;
    }

    public void fromString(ParsedVector parsedVector) {
        String[] stringArray = parsedVector.getKeys();
        int n = 0;
        while (n < stringArray.length) {
            int n2;
            Integer n3;
            String string;
            ParsedObject parsedObject;
            if (stringArray[n].equals(myReadWriteHostCount_tag)) {
                parsedObject = parsedVector.getElement(myReadWriteHostCount_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n3 = Integer.valueOf(string);
                    this.myReadWriteHostCount = n3;
                    if (this.myReadWriteHostCount > 0) {
                        this.myReadWriteHostList = new Vector(this.myReadWriteHostCount);
                        n2 = 1;
                        while (n2 <= this.myReadWriteHostCount) {
                            parsedObject = parsedVector.get(n + n2);
                            string = (String)parsedObject.getValue();
                            if (string != null) {
                                this.myReadWriteHostList.addElement(new String(string));
                            }
                            ++n2;
                        }
                    } else {
                        this.myReadWriteHostList = new Vector();
                    }
                } else {
                    this.myReadWriteHostList = new Vector();
                }
            } else if (stringArray[n].equals(myReadHostCount_tag)) {
                parsedObject = parsedVector.getElement(myReadHostCount_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n3 = Integer.valueOf(string);
                    this.myReadHostCount = n3;
                    if (this.myReadHostCount > 0) {
                        this.myReadHostList = new Vector(this.myReadHostCount);
                        n2 = 1;
                        while (n2 <= this.myReadHostCount) {
                            parsedObject = parsedVector.get(n + n2);
                            string = (String)parsedObject.getValue();
                            if (string != null) {
                                if (this.myTrace) {
                                    System.out.println("Adding host to myReadHostList in NFSDirEntry.FromString()");
                                }
                                this.myReadHostList.addElement(new String(string));
                            }
                            ++n2;
                        }
                    } else {
                        this.myReadHostList = new Vector();
                    }
                } else {
                    this.myReadHostList = new Vector();
                }
            } else if (stringArray[n].equals(myUpdatedState_tag)) {
                parsedObject = parsedVector.getElement(myUpdatedState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n3 = Integer.valueOf(string);
                    if (n3 == 0) {
                        this.setUpdated(false);
                    } else {
                        this.setUpdated(true);
                    }
                }
            } else if (stringArray[n].equals(myDirectory_tag)) {
                parsedObject = parsedVector.getElement(myDirectory_tag);
                string = (String)parsedObject.getValue();
                this.myDirectory = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(myComments_tag)) {
                parsedObject = parsedVector.getElement(myComments_tag);
                string = (String)parsedObject.getValue();
                this.myComments = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(myAlias_tag)) {
                parsedObject = parsedVector.getElement(myAlias_tag);
                string = (String)parsedObject.getValue();
                this.myAlias = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(myPublicState_tag)) {
                parsedObject = parsedVector.getElement(myPublicState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n3 = Integer.valueOf(string);
                    this.myPublicState = n3 != 0;
                }
            } else if (stringArray[n].equals(mySpecifyState_tag)) {
                parsedObject = parsedVector.getElement(mySpecifyState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n3 = Integer.valueOf(string);
                    this.mySpecifyState = n3 != 0;
                }
            } else if (stringArray[n].equals(myReadOnlyState_tag)) {
                parsedObject = parsedVector.getElement(myReadOnlyState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n3 = Integer.valueOf(string);
                    this.myReadOnlyState = n3 != 0;
                }
            } else if (stringArray[n].equals(myReadWriteState_tag) && (string = (String)(parsedObject = parsedVector.getElement(myReadWriteState_tag)).getValue()) != null) {
                n3 = Integer.valueOf(string);
                this.myReadWriteState = n3 != 0;
            }
            ++n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(BND_tag);
        if (this.isUpdated()) {
            stringBuffer.append("," + myUpdatedState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myUpdatedState_tag + "=" + 0);
        }
        if (this.isPublic()) {
            stringBuffer.append("," + myPublicState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myPublicState_tag + "=" + 0);
        }
        if (this.isSpecifyHosts()) {
            stringBuffer.append("," + mySpecifyState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + mySpecifyState_tag + "=" + 0);
        }
        if (this.isReadOnly()) {
            stringBuffer.append("," + myReadOnlyState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myReadOnlyState_tag + "=" + 0);
        }
        if (this.isReadWrite()) {
            stringBuffer.append("," + myReadWriteState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myReadWriteState_tag + "=" + 0);
        }
        stringBuffer.append("," + myDirectory_tag + "=" + this.myDirectory);
        stringBuffer.append("," + myAlias_tag + "=" + this.myAlias);
        stringBuffer.append("," + myComments_tag + "=" + this.myComments);
        Enumeration enumeration = this.myReadHostList.elements();
        stringBuffer.append("," + myReadHostCount_tag + "=" + String.valueOf(this.myReadHostList.size()));
        while (enumeration.hasMoreElements()) {
            try {
                String string = (String)enumeration.nextElement();
                stringBuffer.append("," + myReadHost_tag + "=" + string);
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
        }
        Enumeration enumeration2 = this.myReadWriteHostList.elements();
        stringBuffer.append("," + myReadWriteHostCount_tag + "=" + String.valueOf(this.myReadWriteHostList.size()));
        while (enumeration2.hasMoreElements()) {
            try {
                String string = (String)enumeration2.nextElement();
                stringBuffer.append("," + myReadWriteHost_tag + "=" + string);
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
        }
        stringBuffer.append("," + END_tag);
        return stringBuffer.toString();
    }
}

