/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.common;

import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCConstants;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCKeyword;
import COM.ibm.raleigh.tcp.tcpcfg2.common.CloneableItem;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NotebookData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;

public class NfsAccess
extends NotebookData
implements Cloneable,
CloneableItem,
OOCConstants {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String BNA_tag = new String("Bna");
    public static final String ENA_tag = new String("Ena");
    public static final String myEnabledState_tag = new String("naEnab_yn");
    public static final String myUIDvalue_tag = new String("nauid");
    public static final String myGIDvalue_tag = new String("nagid");
    private boolean myEnabledState = false;
    private static final boolean myEnabledStateDefault = false;
    private static final String myUIDDefault = new String("");
    private static final String myGIDDefault = new String("");
    private String myUIDvalue;
    private String myGIDvalue;
    private OOCKeyword kwActive;
    private boolean myTrace = Utility.isTraceOn();

    NfsAccess() {
        if (this.myTrace) {
            System.out.println("in NfsAccess constructor");
        }
        this.loadInit();
    }

    public NfsAccess(ParsedVector parsedVector) {
        if (this.myTrace) {
            System.out.println("@@@@@@@@@ CONSRUCTING NfsAccess from a ParsedVector");
        }
        this.fromString(parsedVector);
    }

    public Object clone() {
        if (this.myTrace) {
            System.out.println("in NfsAccess.clone()");
        }
        NfsAccess nfsAccess = new NfsAccess();
        nfsAccess.setEnableUser(this.myEnabledState);
        if (this.myTrace) {
            System.out.println("(nfsaccess.clone) myUIDvalue is =" + this.myUIDvalue);
            System.out.println("(nfsaccess.clone) myGIDvalue is =" + this.myGIDvalue);
        }
        nfsAccess.setUID(new String(this.myUIDvalue));
        nfsAccess.setGID(new String(this.myGIDvalue));
        return nfsAccess;
    }

    public boolean getEnableUser() {
        return this.myEnabledState;
    }

    public String getUID() {
        return this.myUIDvalue;
    }

    public String getGID() {
        return this.myGIDvalue;
    }

    private void loadInit() {
        if (this.myTrace) {
            System.out.println("in loadInit() of NfsAccess");
        }
        this.myEnabledState = false;
        this.myUIDvalue = myUIDDefault;
        this.myGIDvalue = myGIDDefault;
    }

    public void setEnableUser(boolean bl) {
        this.myEnabledState = bl;
    }

    public void setUID(String string) {
        this.myUIDvalue = string;
    }

    public void setGID(String string) {
        this.myGIDvalue = string;
    }

    public boolean isConfigured() {
        return this.myEnabledState || this.myUIDvalue.compareTo(myUIDDefault) != 0 || this.myGIDvalue.compareTo(myGIDDefault) != 0;
    }

    public void fromString(ParsedVector parsedVector) {
        String[] stringArray = parsedVector.getKeys();
        int n = 0;
        while (n < stringArray.length) {
            String string;
            ParsedObject parsedObject;
            if (stringArray[n].equals(myEnabledState_tag)) {
                parsedObject = parsedVector.getElement(myEnabledState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    Integer n2 = Integer.valueOf(string);
                    this.myEnabledState = n2 != 0;
                }
            } else if (stringArray[n].equals(myUIDvalue_tag)) {
                parsedObject = parsedVector.getElement(myUIDvalue_tag);
                string = (String)parsedObject.getValue();
                this.myUIDvalue = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(myGIDvalue_tag)) {
                parsedObject = parsedVector.getElement(myGIDvalue_tag);
                string = (String)parsedObject.getValue();
                this.myGIDvalue = string != null ? new String(string) : new String("");
            }
            ++n;
        }
    }

    public String toString() {
        if (this.myTrace) {
            System.out.println("in UserEntry.toString() ");
        }
        StringBuffer stringBuffer = new StringBuffer(BNA_tag);
        stringBuffer.append("=start");
        if (this.myEnabledState) {
            stringBuffer.append("," + myEnabledState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myEnabledState_tag + "=" + 0);
        }
        stringBuffer.append("," + myUIDvalue_tag + "=" + this.myUIDvalue);
        stringBuffer.append("," + myGIDvalue_tag + "=" + this.myGIDvalue);
        stringBuffer.append("," + ENA_tag);
        stringBuffer.append("=end");
        return stringBuffer.toString();
    }

    public void loadNfsAccessFromOOCS(OOCKeyword oOCKeyword) {
        String string;
        if (this.myTrace) {
            System.out.println("***** in NfsAccess.loadNfsAccessFromOOCS");
        }
        this.myEnabledState = (string = oOCKeyword.getValueOf("active")).equals("1");
        if (this.myTrace) {
            System.out.println("(NfsAccess.loadNfsAccessFromOOCS) myEnabledState = " + this.myEnabledState);
        }
    }

    public void saveNfsAccessToOOCS(OOCKeyword oOCKeyword, OOCKeyword oOCKeyword2) {
        if (this.myTrace) {
            System.out.println("***** in NfsAccess.saveNfsAccessToOOCS");
            System.out.println("(NfsAccess.saveNfsAccessToOOCS) kwNfsd = " + oOCKeyword2);
        }
        if (oOCKeyword2 == null) {
            oOCKeyword2 = oOCKeyword.createKeyword(0, "nfsd", "", null);
            if (this.myTrace) {
                System.out.println("(NfsAccess.saveNfsAccessToOOCS) created new NFSD keyword = " + oOCKeyword2);
            }
        }
        this.kwActive = this.kwActive == null ? oOCKeyword2.createKeyword(1, "active", "", null) : oOCKeyword2.get("active", "");
        if (this.myEnabledState) {
            this.kwActive.setValue("1");
        } else {
            this.kwActive.setValue("0");
        }
        if (this.myTrace) {
            System.out.println("(NfsAccess.saveNfsAccessToOOCS) myEnabledState = " + this.myEnabledState);
        }
    }
}

