/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.common;

import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCConstants;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCKeyword;
import COM.ibm.raleigh.tcp.tcpcfg2.common.CloneableItem;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NotebookData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;

public class RshEntry
extends NotebookData
implements Cloneable,
OOCConstants,
CloneableItem {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String BRS_tag = new String("Brs");
    public static final String ERS_tag = new String("Ers");
    public static final String myHostname_tag = new String("rsHstName");
    public static final String myDomainName_tag = new String("rsDomName");
    public static final String myUser_tag = new String("rsUser");
    private String myHostname;
    private String myDomainName;
    private String myUser;
    private OOCKeyword kwRshUser;
    private OOCKeyword kwHostname;
    private OOCKeyword kwDomainName;
    private OOCKeyword kwUser;
    private boolean myTrace = Utility.isTraceOn();

    public RshEntry() {
        if (this.myTrace) {
            System.out.println("in RshEntry() constructor");
        }
        this.loadInit();
    }

    public RshEntry(String string, String string2, String string3) {
        if (this.myTrace) {
            System.out.println("in RshEntry() constructor2");
        }
        this.myHostname = string;
        this.myDomainName = string2;
        this.myUser = string3;
    }

    public RshEntry(ParsedVector parsedVector) {
        if (this.myTrace) {
            System.out.println("@@@@@@@@@ CONSRUCTING RshEntry from a ParsedVector");
        }
        this.fromString(parsedVector);
    }

    public Object clone() {
        RshEntry rshEntry = new RshEntry();
        rshEntry.setHostname(this.myHostname);
        rshEntry.setDomainName(this.myDomainName);
        rshEntry.setUser(this.myUser);
        return rshEntry;
    }

    public String getHostname() {
        return this.myHostname;
    }

    public String getDomainName() {
        return this.myDomainName;
    }

    public String getUser() {
        return this.myUser;
    }

    private void loadInit() {
        if (this.myTrace) {
            System.out.println("in loadInit() of RshEntry");
        }
        this.myHostname = new String("");
        this.myDomainName = new String("");
        this.myUser = new String("");
    }

    public void setHostname(String string) {
        this.myHostname = string;
    }

    public void setDomainName(String string) {
        this.myDomainName = string;
    }

    public void setUser(String string) {
        this.myUser = string;
    }

    public void loadRshAccessFromOOCS(OOCKeyword oOCKeyword) {
        this.myHostname = oOCKeyword.getValueOf("hostname");
        this.myDomainName = oOCKeyword.getValueOf("domain");
        this.myUser = oOCKeyword.getValueOf("username");
        if (this.myTrace) {
            System.out.println("(RshEntry.loadRshAccessFromOOCS) myHostname = " + this.myHostname);
            System.out.println("(RshEntry.loadRshAccessFromOOCS) myDomainName = " + this.myDomainName);
            System.out.println("(RshEntry.loadRshAccessFromOOCS) myUser = " + this.myUser);
        }
    }

    public void saveRshAccessToOOCS(OOCKeyword oOCKeyword) {
        if (NotebookData.hasValue(this.myHostname)) {
            this.kwHostname = oOCKeyword.createKeyword(1, "hostname", "", null);
            this.kwHostname.setValue(this.myHostname);
        }
        if (NotebookData.hasValue(this.myDomainName)) {
            this.kwDomainName = oOCKeyword.createKeyword(1, "domain", "", null);
            this.kwDomainName.setValue(this.myDomainName);
        }
        if (NotebookData.hasValue(this.myUser)) {
            this.kwUser = oOCKeyword.createKeyword(1, "username", "", null);
            this.kwUser.setValue(this.myUser);
        }
        if (this.myTrace) {
            System.out.println("(RshEntry.saveRshAccessToOOCS) myHostname = " + this.myHostname);
            System.out.println("(RshEntry.saveRshAccessToOOCS) myDomainName = " + this.myDomainName);
            System.out.println("(RshEntry.saveRshAccessToOOCS) myUser = " + this.myUser);
        }
    }

    public void fromString(ParsedVector parsedVector) {
        if (this.myTrace) {
            System.out.println("RshEntry.fromString()");
        }
        String[] stringArray = parsedVector.getKeys();
        int n = 0;
        while (n < stringArray.length) {
            String string;
            ParsedObject parsedObject;
            if (stringArray[n].equals(myHostname_tag)) {
                parsedObject = parsedVector.getElement(myHostname_tag);
                string = (String)parsedObject.getValue();
                this.myHostname = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(myDomainName_tag)) {
                parsedObject = parsedVector.getElement(myDomainName_tag);
                string = (String)parsedObject.getValue();
                this.myDomainName = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(myUser_tag)) {
                parsedObject = parsedVector.getElement(myUser_tag);
                string = (String)parsedObject.getValue();
                this.myUser = string != null ? new String(string) : new String("");
            }
            ++n;
        }
    }

    public String toString() {
        if (this.myTrace) {
            System.out.println("in RshEntry.toString() ");
        }
        StringBuffer stringBuffer = new StringBuffer(BRS_tag);
        stringBuffer.append("," + myHostname_tag + "=" + this.myHostname);
        stringBuffer.append("," + myDomainName_tag + "=" + this.myDomainName);
        stringBuffer.append("," + myUser_tag + "=" + this.myUser);
        stringBuffer.append("," + ERS_tag);
        return stringBuffer.toString();
    }
}

