/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.common;

import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCConfiguration;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCConstants;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCKeyword;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCMessageQueue;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCProductInfo;
import COM.ibm.raleigh.tcp.tcpcfg2.common.ErrorListController;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NotebookData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.SocksRouteEntry;
import COM.ibm.raleigh.tcp.tcpcfg2.common.SocksServerEntry;
import COM.ibm.raleigh.tcp.tcpcfg2.common.TcpError;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import COM.ibm.raleigh.tcp.tcpcfg2.server.NativeData;
import COM.ibm.raleigh.tcp.tcpcfg2.server.ServerMsg;
import java.io.File;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Vector;

public class SocksData
extends NotebookData
implements OOCConstants {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String BSO_tag = new String("Bso");
    public static final String ESO_tag = new String("Eso");
    public static final String DATA_ID = new String("SOCKSDATA");
    public static final String SAVE_ID = new String("SAVE_SOCKS_DATA");
    public static final String LOAD_ID = new String("LOAD_SOCKS_DATA");
    private static final String myUpdatedState_tag = new String("updated_yn");
    private static final String myUserID_tag = new String("Duid");
    private static final String myDomainCount_tag = new String("Dcnt");
    private static final String myDomain_tag = new String("Dlist");
    private static final String myRouteEntryCount_tag = new String("Rcnt");
    private static final String myRouteEntry_tag = new String("EMBEDDED_BDE_BELONGS_TO_BSO");
    private static final String myNameserverCount_tag = new String("DNScnt");
    private static final String myNameserver_tag = new String("DNS");
    private static final String myServerEntryCount_tag = new String("SEcnt");
    private static final String myServerEntry_tag = new String("EMBEDDED_BEE_BELONGS_TO_BSO");
    private static final String myEnabledState_tag = new String("Est_yn");
    private static final String myPassword_tag = new String("password");
    private Vector myDomainList;
    private Vector myNameserverList;
    private Vector mySocksRouteEntryList;
    private Vector mySocksServerEntryList;
    private String myUserID;
    private String myPassword;
    private int myDomainCount;
    private int myNameserverCount;
    private int mySocksRouteEntryCount;
    private int mySocksServerEntryCount;
    private boolean myEnabledState = false;
    private boolean noExistingCfgData = false;
    private boolean noExistingEnvData = false;
    private boolean noSocksEnvProductInfo = false;
    private boolean noSocksCfgProductInfo = false;
    private OOCProductInfo mySocksEnvProductInfo;
    private OOCProductInfo mySocksCfgProductInfo;
    private OOCConfiguration mySocksEnvConfiguration;
    private OOCConfiguration mySocksCfgConfiguration;
    private OOCMessageQueue myMessageQueue;
    private String mySocksDomain1;
    private String mySocksDomain2;
    private String mySocksDomain3;
    private String mySocksNS1;
    private String mySocksNS2;
    private String mySocksNS3;
    private String myDomain;
    private String myNameserver;
    private String myEtcPath;
    private NativeData myNativeData;
    private String socksenvDatFile;
    private String sockscfgDatFile;
    private String socksenvConfigFile;
    private String sockscfgConfigFile;
    private String sockscfgbakFile;
    private String socksenvbakFile;
    private String logFile;
    private static final String socksenvParseRules = "SOCKS_ENV_RULES";
    private static final String sockscfgParseRules = "SOCKS_CFG_RULES";
    private boolean already_closed = false;
    private OOCKeyword kwEnable;
    private OOCKeyword kwUserID;
    private OOCKeyword kwSocksDomain;
    private OOCKeyword kwSocksNS;
    private OOCKeyword kwDirect;
    private OOCKeyword kwSockd;
    private OOCKeyword kwSocksDomain1;
    private OOCKeyword kwSocksDomain2;
    private OOCKeyword kwSocksDomain3;
    private OOCKeyword kwSocksNS1;
    private OOCKeyword kwSocksNS2;
    private OOCKeyword kwSocksNS3;
    private OOCKeyword kwPassword;
    ErrorListController myErrorListController;
    private ResourceBundle myBundle;
    private byte[] myEncryptedPw;
    private MessageDigest messDigest;
    private boolean myPasswordChanged = false;
    private boolean myTrace = Utility.isTraceOn();

    SocksData() {
        if (this.myTrace) {
            System.out.println("in SocksData() constructor");
        }
        this.loadInit();
        this.myBundle = ServerMsg.getBundle();
    }

    public SocksData(boolean bl, ErrorListController errorListController) {
        if (this.myTrace) {
            System.out.println("in SocksData() constructor");
        }
        this.loadInit();
        this.myBundle = ServerMsg.getBundle();
        this.myErrorListController = errorListController;
        if (bl) {
            this.loadFromOOCS();
        }
    }

    public SocksData(ParsedVector parsedVector) {
        if (this.myTrace) {
            System.out.println("@@@@@@@@@ CONSRUCTING SocksData from a ParsedVector");
        }
        this.fromString(parsedVector);
    }

    public void addDomain(String string) {
        this.myDomainList.addElement(string);
        this.myDomainCount = this.getDomainListSize();
    }

    public void addNameserver(String string) {
        this.myNameserverList.addElement(string);
        this.myNameserverCount = this.getNameserverListSize();
    }

    public void addSocksRouteEntry(SocksRouteEntry socksRouteEntry) {
        this.mySocksRouteEntryList.addElement(socksRouteEntry);
        this.mySocksRouteEntryCount = this.getSocksRouteEntryListSize();
    }

    public void addSocksServerEntry(SocksServerEntry socksServerEntry) {
        this.mySocksServerEntryList.addElement(socksServerEntry);
        this.mySocksServerEntryCount = this.getSocksServerEntryListSize();
    }

    public void deleteDomainList() {
        this.myDomainList.removeAllElements();
        this.myDomainCount = this.getDomainListSize();
    }

    public void deleteNameserverList() {
        this.myNameserverList.removeAllElements();
        this.myNameserverCount = this.getNameserverListSize();
    }

    public void deleteSocksRouteEntry(int n) {
        this.mySocksRouteEntryList.removeElementAt(n);
        this.mySocksRouteEntryCount = this.getSocksRouteEntryListSize();
    }

    public void deleteSocksRouteEntryList() {
        this.mySocksRouteEntryList.removeAllElements();
        this.mySocksRouteEntryCount = this.getSocksRouteEntryListSize();
    }

    public void deleteSocksServerEntry(int n) {
        this.mySocksServerEntryList.removeElementAt(n);
        this.mySocksServerEntryCount = this.getSocksServerEntryListSize();
    }

    public void deleteSocksServerEntryList() {
        this.mySocksServerEntryList.removeAllElements();
        this.mySocksServerEntryCount = 0;
    }

    public String getDomain(int n) {
        return (String)this.myDomainList.elementAt(n);
    }

    public int getDomainListSize() {
        return this.myDomainList.size();
    }

    public String getNameserver(int n) {
        return (String)this.myNameserverList.elementAt(n);
    }

    public int getNameserverListSize() {
        return this.myNameserverList.size();
    }

    public SocksRouteEntry getSocksRouteEntry(int n) {
        return (SocksRouteEntry)this.mySocksRouteEntryList.elementAt(n);
    }

    public int getSocksRouteEntryListSize() {
        return this.mySocksRouteEntryList.size();
    }

    public SocksServerEntry getSocksServerEntry(int n) {
        return (SocksServerEntry)this.mySocksServerEntryList.elementAt(n);
    }

    public int getSocksServerEntryListSize() {
        return this.mySocksServerEntryList.size();
    }

    public String getUserID() {
        return this.myUserID;
    }

    public String getPassword() {
        return this.myPassword;
    }

    public boolean isEnabled() {
        return this.myEnabledState;
    }

    private void loadInit() {
        if (this.myTrace) {
            System.out.println("in loadInit() of SocksData");
        }
        this.myDomainList = new Vector();
        this.myNameserverList = new Vector();
        this.mySocksRouteEntryList = new Vector();
        this.mySocksServerEntryList = new Vector();
        this.myUserID = new String("");
        this.myPassword = new String("");
        this.myEncryptedPw = null;
        this.myPasswordChanged = false;
        this.myDomainCount = 0;
        this.myNameserverCount = 0;
        this.mySocksRouteEntryCount = 0;
        this.mySocksServerEntryCount = 0;
        this.myEnabledState = false;
        this.myErrorListController = null;
    }

    public void replaceSocksRouteEntry(SocksRouteEntry socksRouteEntry, int n) {
        this.mySocksRouteEntryList.removeElementAt(n);
        this.mySocksRouteEntryList.insertElementAt(socksRouteEntry, n);
    }

    public void replaceSocksServerEntry(SocksServerEntry socksServerEntry, int n) {
        this.mySocksServerEntryList.removeElementAt(n);
        this.mySocksServerEntryList.insertElementAt(socksServerEntry, n);
    }

    public void setDomainCount(int n) {
        this.myDomainCount = n;
    }

    public void setEnabled(boolean bl) {
        this.myEnabledState = bl;
    }

    public void setUserID(String string) {
        this.myUserID = string;
    }

    public void setPassword(String string) {
        this.myPassword = string;
    }

    public void setmyPasswordChanged(boolean bl) {
        this.myPasswordChanged = bl;
    }

    public boolean getmyPasswordChanged() {
        return this.myPasswordChanged;
    }

    private void loadFromOOCS() {
        OOCMessageQueue oOCMessageQueue;
        TcpError tcpError;
        Object object;
        int n;
        if (this.myTrace) {
            System.out.println("in loadFromOOCS() of SocksData");
        }
        this.myEtcPath = NativeData.getEtcPath();
        this.socksenvDatFile = String.valueOf(this.myEtcPath) + "dat" + File.separator + "toxsxenv.dat";
        this.sockscfgDatFile = String.valueOf(this.myEtcPath) + "dat" + File.separator + "toxsxcfg.dat";
        this.socksenvConfigFile = String.valueOf(this.myEtcPath) + "socks.env";
        this.sockscfgConfigFile = String.valueOf(this.myEtcPath) + "socks.cfg";
        this.socksenvbakFile = String.valueOf(this.myEtcPath) + "socksenv.nbk";
        this.sockscfgbakFile = String.valueOf(this.myEtcPath) + "sockscfg.nbk";
        this.logFile = String.valueOf(this.myEtcPath) + "tcpcfg2.log";
        this.mySocksEnvProductInfo = new OOCProductInfo();
        if (this.myTrace) {
            System.out.println("(SocksData.loadFromOOCS) mySocksEnvProductInfo socksenvDatFile = " + this.socksenvDatFile);
        }
        if ((n = this.mySocksEnvProductInfo.create(this.socksenvDatFile)) == 0) {
            if (this.myTrace) {
                System.out.println("(SocksData.loadFromOOCS) mySocksEnvProductInfo.create successful");
            }
            this.mySocksEnvProductInfo.setFileOpenMode(3);
            this.mySocksEnvProductInfo.setFileShareMode(0);
            this.mySocksEnvProductInfo.setProcessingOptions(1, 1, 1);
            this.mySocksEnvProductInfo.setParsingInfo(socksenvParseRules);
            this.mySocksEnvConfiguration = new OOCConfiguration();
            if (this.myTrace) {
                System.out.println("(SocksData.loadFromOOCS) mySocksEnvConfiguration socksenvConfigFile = " + this.socksenvConfigFile);
            }
            if ((n = this.mySocksEnvConfiguration.open(this.mySocksEnvProductInfo, this.socksenvConfigFile)) == 2) {
                n = this.mySocksEnvConfiguration.open(this.mySocksEnvProductInfo, "");
                if (this.myTrace) {
                    System.out.println("(SetupData.loadFromOOCS) mySocksEnvConfiguration.create successful...no preexisting file");
                }
                this.noExistingEnvData = true;
            }
            if (this.myTrace) {
                System.out.println("(SetupData.loadFromOOCS) mySocksEnvConfiguration.create successful");
            }
            this.mySocksEnvConfiguration.write(this.socksenvbakFile, 1, 1, 1, 0, socksenvParseRules);
            this.myMessageQueue = this.mySocksEnvConfiguration.getMsgQ();
            this.myMessageQueue.replaceLogFile(0);
            this.myMessageQueue.setLogFileName(this.logFile);
            this.myMessageQueue.setLogOption(1);
            this.myMessageQueue.logQueue();
            this.mySocksEnvProductInfo.close();
        } else {
            this.noSocksEnvProductInfo = true;
            if (this.myTrace) {
                System.out.println("(SockspData.loadFromOOCS) ERROR: mySocksEnvProductInfo.create failed");
            }
            object = new Object[]{this.socksenvDatFile, "socks.env"};
            tcpError = new TcpError(MessageFormat.format(this.myBundle.getString("WARNING_FILE_NOT_FOUND"), (Object[])object), 1);
            this.myErrorListController.addError(tcpError);
            oOCMessageQueue = OOCMessageQueue.getStaticMsgQ();
            oOCMessageQueue.replaceLogFile(0);
            oOCMessageQueue.setLogFileName(this.logFile);
            oOCMessageQueue.setLogOption(2);
            oOCMessageQueue.logQueue();
            if (this.myTrace) {
                System.out.println("(SocksData.loadFromOOCS) Messages were logged to filename " + this.logFile);
            }
        }
        this.mySocksCfgProductInfo = new OOCProductInfo();
        if (this.myTrace) {
            System.out.println("(SocksData.loadFromOOCS) mySocksfgProductInfo sockscfgDatFile = " + this.sockscfgDatFile);
        }
        if ((n = this.mySocksCfgProductInfo.create(this.sockscfgDatFile)) == 0) {
            if (this.myTrace) {
                System.out.println("(SocksData.loadFromOOCS) mySocksCfgProductInfo.create successful");
            }
            this.mySocksCfgProductInfo.setFileOpenMode(3);
            this.mySocksCfgProductInfo.setFileShareMode(0);
            this.mySocksCfgProductInfo.setProcessingOptions(1, 1, 1);
            this.mySocksCfgProductInfo.setParsingInfo(sockscfgParseRules);
            this.mySocksCfgConfiguration = new OOCConfiguration();
            if (this.myTrace) {
                System.out.println("(SocksData.loadFromOOCS) mySocksCfgConfiguration sockscfgConfigFile = " + this.sockscfgConfigFile);
            }
            if ((n = this.mySocksCfgConfiguration.open(this.mySocksCfgProductInfo, this.sockscfgConfigFile)) == 2) {
                n = this.mySocksCfgConfiguration.open(this.mySocksCfgProductInfo, "");
                if (this.myTrace) {
                    System.out.println("(SetupData.loadFromOOCS) mySocksCfgConfiguration.create successful...no preexisting file");
                }
                this.noExistingCfgData = true;
            }
            if (this.myTrace) {
                System.out.println("(SetupData.loadFromOOCS) mySocksCfgConfiguration.create successful");
            }
            this.mySocksCfgConfiguration.write(this.sockscfgbakFile, 1, 1, 1, 0, sockscfgParseRules);
            this.myMessageQueue = this.mySocksCfgConfiguration.getMsgQ();
            this.myMessageQueue.replaceLogFile(0);
            this.myMessageQueue.setLogFileName(this.logFile);
            this.myMessageQueue.setLogOption(1);
            this.myMessageQueue.logQueue();
            this.mySocksCfgProductInfo.close();
        } else {
            this.noSocksCfgProductInfo = true;
            if (this.myTrace) {
                System.out.println("(SockspData.loadFromOOCS) ERROR: mySocksCfgProductInfo.create failed");
            }
            object = new Object[]{this.sockscfgDatFile, "socks.cfg"};
            tcpError = new TcpError(MessageFormat.format(this.myBundle.getString("WARNING_FILE_NOT_FOUND"), (Object[])object), 1);
            this.myErrorListController.addError(tcpError);
            oOCMessageQueue = OOCMessageQueue.getStaticMsgQ();
            oOCMessageQueue.replaceLogFile(0);
            oOCMessageQueue.setLogFileName(this.logFile);
            oOCMessageQueue.setLogOption(2);
            oOCMessageQueue.logQueue();
            if (this.myTrace) {
                System.out.println("(SocksData.loadFromOOCS) Messages were logged to filename " + this.logFile);
            }
        }
        this.kwEnable = this.mySocksEnvConfiguration.get("enable_socks", "");
        if (this.kwEnable != null) {
            object = this.kwEnable.getValue();
            if (this.myTrace) {
                System.out.println("(SocksData.loadFromOOCS) temp = " + (String)object);
            }
            this.myEnabledState = ((String)object).equals("Y");
            if (this.myTrace) {
                System.out.println("(SocksData.loadFromOOCS) myEnabledState = " + this.myEnabledState);
            }
        }
        this.kwUserID = this.mySocksEnvConfiguration.get("socks_userid", "");
        if (this.kwUserID != null) {
            this.myUserID = this.kwUserID.getValue();
        }
        if (this.myTrace) {
            System.out.println("(SocksData.loadFromOOCS) mUserID = " + this.myUserID);
        }
        this.kwPassword = this.mySocksEnvConfiguration.get("socks_password", "");
        if (this.kwPassword != null) {
            this.myPassword = this.kwPassword.getValue();
        }
        this.setmyPasswordChanged(false);
        if (this.myTrace) {
            System.out.println("(SocksData.loadFromOOCS) myPassword = " + this.myPassword);
        }
        this.kwSocksDomain = this.mySocksEnvConfiguration.get("socks_domain", "");
        if (this.kwSocksDomain != null) {
            this.mySocksDomain1 = this.kwSocksDomain.getValueOf("domain1");
            this.mySocksDomain2 = this.kwSocksDomain.getValueOf("domain2");
            this.mySocksDomain3 = this.kwSocksDomain.getValueOf("domain3");
            if (!this.mySocksDomain1.equals("")) {
                this.addDomain(this.mySocksDomain1);
                if (this.myTrace) {
                    System.out.println("(SocksData.loadFromOOCS) mySocksDomain1 = " + this.mySocksDomain1);
                }
            }
            if (!this.mySocksDomain2.equals("")) {
                this.addDomain(this.mySocksDomain2);
                if (this.myTrace) {
                    System.out.println("(SocksData.loadFromOOCS) mySocksDomain2 = " + this.mySocksDomain2);
                }
            }
            if (!this.mySocksDomain3.equals("")) {
                this.addDomain(this.mySocksDomain3);
                if (this.myTrace) {
                    System.out.println("(SocksData.loadFromOOCS) mySocksDomain3 = " + this.mySocksDomain3);
                }
            }
        }
        this.kwSocksNS = this.mySocksEnvConfiguration.get("socks_nameserver", "");
        if (this.kwSocksNS != null) {
            this.mySocksNS1 = this.kwSocksNS.getValueOf("domain1");
            this.mySocksNS2 = this.kwSocksNS.getValueOf("domain2");
            this.mySocksNS3 = this.kwSocksNS.getValueOf("domain3");
            if (!this.mySocksNS1.equals("")) {
                this.addNameserver(this.mySocksNS1);
                if (this.myTrace) {
                    System.out.println("(SocksData.loadFromOOCS) mySocksNS1 = " + this.mySocksNS1);
                }
            }
            if (!this.mySocksNS2.equals("")) {
                this.addNameserver(this.mySocksNS2);
                if (this.myTrace) {
                    System.out.println("(SocksData.loadFromOOCS) mySocksNS2 = " + this.mySocksNS2);
                }
            }
            if (!this.mySocksNS3.equals("")) {
                this.addNameserver(this.mySocksNS3);
                if (this.myTrace) {
                    System.out.println("(SocksData.loadFromOOCS) mySocksNS3 = " + this.mySocksNS3);
                }
            }
        }
        this.kwDirect = this.mySocksCfgConfiguration.get("direct_routes", "");
        while (this.kwDirect != null) {
            object = new SocksRouteEntry();
            ((SocksRouteEntry)object).loadDirectRouteFromOOCS(this.kwDirect);
            this.addSocksRouteEntry((SocksRouteEntry)object);
            this.kwDirect = this.kwDirect.nextOf();
        }
        this.kwSockd = this.mySocksCfgConfiguration.get("sockd_server", "");
        while (this.kwSockd != null) {
            object = new SocksServerEntry();
            ((SocksServerEntry)object).loadSockdServerFromOOCS(this.kwSockd);
            this.addSocksServerEntry((SocksServerEntry)object);
            this.kwSockd = this.kwSockd.nextOf();
        }
    }

    public void saveToOOCS() {
        if (this.myTrace) {
            System.out.println("in saveToOOCS() of SocksData");
        }
        if (this.myEnabledState || !this.myEnabledState || NotebookData.hasValue(this.myUserID) || NotebookData.hasValue(this.myPassword) || NotebookData.hasValue(this.mySocksDomain1) || NotebookData.hasValue(this.mySocksDomain2) || NotebookData.hasValue(this.mySocksDomain3) || NotebookData.hasValue(this.mySocksNS1) || NotebookData.hasValue(this.mySocksNS2) || NotebookData.hasValue(this.mySocksNS3) || NotebookData.hasValue(this.myDomain) || NotebookData.hasValue(this.myNameserver)) {
            int n;
            int n2;
            OOCKeyword[] oOCKeywordArray;
            int n3;
            if (this.kwEnable == null) {
                this.kwEnable = this.mySocksEnvConfiguration.createKeyword(1, "enable_socks", "", null);
            }
            if (this.myEnabledState) {
                this.kwEnable.setValue("Y");
            } else {
                this.kwEnable.setValue("N");
            }
            if (this.myTrace) {
                System.out.println("(SocksData.saveToOOCS) myEnabledState = " + this.myEnabledState);
            }
            if (this.kwUserID == null) {
                this.kwUserID = this.mySocksEnvConfiguration.createKeyword(1, "socks_userid", "", null);
            }
            this.kwUserID.setValue(this.myUserID);
            if (this.myTrace) {
                System.out.println("(SocksData.saveToOOCS) mUserID = " + this.myUserID);
            }
            if (this.kwPassword == null) {
                this.kwPassword = this.mySocksEnvConfiguration.createKeyword(1, "socks_password", "", null);
            }
            this.kwPassword.setValue(this.myPassword);
            if (this.myTrace) {
                System.out.println("(SocksData.saveToOOCS) myPassword = " + this.myPassword);
            }
            if (this.kwSocksDomain != null) {
                this.kwSocksDomain.deleteKeyword("domain1", "");
                this.kwSocksDomain.deleteKeyword("domain2", "");
                this.kwSocksDomain.deleteKeyword("domain3", "");
                this.mySocksEnvConfiguration.deleteKeyword("socks_domain", "");
            }
            int n4 = this.getDomainListSize();
            if (this.myTrace) {
                System.out.println("(SocksData.saveToOOCS) number of socks domains = " + n4);
            }
            if (n4 > 0) {
                this.kwSocksDomain = this.mySocksEnvConfiguration.get("socks_domain", "");
                if (this.kwSocksDomain == null) {
                    this.kwSocksDomain = this.mySocksEnvConfiguration.createKeyword(0, "socks_domain", "", null);
                }
                n3 = 0;
                while (n3 < n4) {
                    this.myDomain = this.getDomain(n3);
                    if (n3 == 0) {
                        if (this.kwSocksDomain1 == null) {
                            this.kwSocksDomain1 = this.kwSocksDomain.createKeyword(1, "domain1", "", null);
                        }
                        this.kwSocksDomain1.setValue(this.myDomain);
                        if (this.myTrace) {
                            System.out.println("(SocksData.saveToOOCS) myDomain1 = " + this.myDomain);
                        }
                    }
                    if (n3 == 1) {
                        if (this.kwSocksDomain2 == null) {
                            this.kwSocksDomain2 = this.kwSocksDomain.createKeyword(1, "domain2", "", null);
                        }
                        this.kwSocksDomain2.setValue(this.myDomain);
                        if (this.myTrace) {
                            System.out.println("(SocksData.saveToOOCS) myDomain2 = " + this.myDomain);
                        }
                    }
                    if (n3 == 2) {
                        if (this.kwSocksDomain3 == null) {
                            this.kwSocksDomain3 = this.kwSocksDomain.createKeyword(1, "domain3", "", null);
                        }
                        this.kwSocksDomain3.setValue(this.myDomain);
                        if (this.myTrace) {
                            System.out.println("(SocksData.saveToOOCS) myDomain3 = " + this.myDomain);
                        }
                    }
                    ++n3;
                }
            }
            if (this.kwSocksNS != null) {
                this.kwSocksNS.deleteKeyword("domain1", "");
                this.kwSocksNS.deleteKeyword("domain2", "");
                this.kwSocksNS.deleteKeyword("domain3", "");
                this.mySocksEnvConfiguration.deleteKeyword("socks_nameserver", "");
            }
            n4 = this.getNameserverListSize();
            if (this.myTrace) {
                System.out.println("(SocksData.saveToOOCS) number of socks nameservers = " + n4);
            }
            if (n4 > 0) {
                this.kwSocksNS = this.mySocksEnvConfiguration.get("socks_nameserver", "");
                if (this.kwSocksNS == null) {
                    this.kwSocksNS = this.mySocksEnvConfiguration.createKeyword(0, "socks_nameserver", "", null);
                }
                this.kwSocksNS = this.mySocksEnvConfiguration.get("socks_nameserver", "");
                n3 = 0;
                while (n3 < n4) {
                    this.myNameserver = this.getNameserver(n3);
                    if (n3 == 0) {
                        if (this.kwSocksNS1 == null) {
                            this.kwSocksNS1 = this.kwSocksNS.createKeyword(1, "domain1", "", null);
                        }
                        this.kwSocksNS1.setValue(this.myNameserver);
                        if (this.myTrace) {
                            System.out.println("(SocksData.saveToOOCS) myNameserver1 = " + this.myNameserver);
                        }
                    }
                    if (n3 == 1) {
                        if (this.kwSocksNS2 == null) {
                            this.kwSocksNS2 = this.kwSocksNS.createKeyword(1, "domain2", "", null);
                        }
                        this.kwSocksNS2.setValue(this.myNameserver);
                        if (this.myTrace) {
                            System.out.println("(SocksData.saveToOOCS) myNameserver2 = " + this.myNameserver);
                        }
                    }
                    if (n3 == 2) {
                        if (this.kwSocksNS3 == null) {
                            this.kwSocksNS3 = this.kwSocksNS.createKeyword(1, "domain3", "", null);
                        }
                        this.kwSocksNS3.setValue(this.myNameserver);
                        if (this.myTrace) {
                            System.out.println("(SocksData.saveToOOCS) myNameserver3 = " + this.myNameserver);
                        }
                    }
                    ++n3;
                }
            }
            n3 = this.mySocksCfgConfiguration.numberOf("direct_routes");
            if (this.myTrace) {
                System.out.println("(SocksData.saveToOOCS) number of OOCS direct routes = " + n3);
            }
            if (n3 > 0) {
                oOCKeywordArray = new OOCKeyword[n3];
                oOCKeywordArray[0] = this.kwDirect = this.mySocksCfgConfiguration.get("direct_routes", "");
                int n5 = 1;
                while (n5 <= n3) {
                    this.kwDirect = this.kwDirect.nextOf();
                    if (this.kwDirect != null) {
                        oOCKeywordArray[n5] = this.kwDirect;
                    }
                    ++n5;
                }
                n2 = 0;
                while (n2 < n3) {
                    this.mySocksCfgConfiguration.deleteThisKeyword(oOCKeywordArray[n2]);
                    ++n2;
                }
            }
            n4 = this.getSocksRouteEntryListSize();
            if (this.myTrace) {
                System.out.println("(SocksData.saveToOOCS) number of GUI direct route entries = " + n4);
            }
            if (n4 > 0) {
                int n6 = 0;
                while (n6 < n4) {
                    SocksRouteEntry socksRouteEntry = this.getSocksRouteEntry(n6);
                    socksRouteEntry.saveDirectRouteToOOCS(this.mySocksCfgConfiguration, this.kwDirect);
                    ++n6;
                }
            }
            n3 = this.mySocksCfgConfiguration.numberOf("sockd_server");
            if (this.myTrace) {
                System.out.println("(SocksData.saveToOOCS) number of OOCS sockd entries = " + n3);
            }
            if (n3 > 0) {
                oOCKeywordArray = new OOCKeyword[n3];
                oOCKeywordArray[0] = this.kwSockd = this.mySocksCfgConfiguration.get("sockd_server", "");
                int n7 = 1;
                while (n7 <= n3) {
                    this.kwSockd = this.kwSockd.nextOf();
                    if (this.kwSockd != null) {
                        oOCKeywordArray[n7] = this.kwSockd;
                    }
                    ++n7;
                }
                n2 = 0;
                while (n2 < n3) {
                    this.mySocksCfgConfiguration.deleteThisKeyword(oOCKeywordArray[n2]);
                    ++n2;
                }
            }
            n4 = this.getSocksServerEntryListSize();
            if (this.myTrace) {
                System.out.println("(SocksData.saveToOOCS) number of GUI sockd entries = " + n4);
            }
            if (n4 > 0) {
                int n8 = 0;
                while (n8 < n4) {
                    SocksServerEntry socksServerEntry = this.getSocksServerEntry(n8);
                    socksServerEntry.saveSockdServerToOOCS(this.mySocksCfgConfiguration, this.kwSockd);
                    ++n8;
                }
            }
            if ((n = this.mySocksEnvConfiguration.write(this.socksenvConfigFile, 1, 1, 1, 0, socksenvParseRules)) == 1) {
                if (this.myTrace) {
                    System.out.println("(SocksData.saveToOOCS) Successful write to socks.env");
                }
            } else {
                if (this.myTrace) {
                    System.out.println("(SocksData.saveToOOCS) Unsuccessful write to socks.env");
                }
                Object[] objectArray = new Object[]{"socks.env"};
                TcpError tcpError = new TcpError(MessageFormat.format(this.myBundle.getString("WARNING_FILE_NOT_WRITTEN"), objectArray), 1);
                this.myErrorListController.addError(tcpError);
                this.myMessageQueue.logQueue();
            }
            if ((n = this.mySocksCfgConfiguration.write(this.sockscfgConfigFile, 1, 1, 1, 0, sockscfgParseRules)) == 1) {
                if (this.myTrace) {
                    System.out.println("(SocksData.saveToOOCS) Successful write to socks.cfg");
                }
            } else {
                if (this.myTrace) {
                    System.out.println("(SocksData.saveToOOCS) Unsuccessful write to socks.cfg");
                }
                Object[] objectArray = new Object[]{"socks.cfg"};
                TcpError tcpError = new TcpError(MessageFormat.format(this.myBundle.getString("WARNING_FILE_NOT_WRITTEN"), objectArray), 1);
                this.myErrorListController.addError(tcpError);
                this.myMessageQueue.logQueue();
            }
            this.closeOOCS();
            return;
        }
        this.closeOOCS();
    }

    public void closeOOCS() {
        if (this.already_closed) {
            return;
        }
        this.already_closed = true;
        int n = this.mySocksEnvConfiguration.close();
        int n2 = this.mySocksCfgConfiguration.close();
        if (this.myTrace) {
            System.out.println("(SocksData.closeOOCS) rc from mySocksEnvConfiguration.close = " + n);
            System.out.println("(SocksData.closeOOCS) rc from mySocksCfgConfiguration.close = " + n2);
        }
    }

    public void fromString(ParsedVector parsedVector) {
        String[] stringArray = parsedVector.getKeys();
        int n = 0;
        while (n < stringArray.length) {
            ParsedVector parsedVector2;
            int n2;
            Integer n3;
            String string;
            ParsedObject parsedObject;
            if (stringArray[n].equals(myDomainCount_tag)) {
                parsedObject = parsedVector.getElement(myDomainCount_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n3 = Integer.valueOf(string);
                    this.myDomainCount = n3;
                    if (this.myDomainCount > 0) {
                        this.myDomainList = new Vector(this.myDomainCount);
                        n2 = 1;
                        while (n2 <= this.myDomainCount) {
                            parsedObject = parsedVector.get(n + n2);
                            string = (String)parsedObject.getValue();
                            if (string != null) {
                                this.myDomainList.addElement(new String(string));
                            }
                            ++n2;
                        }
                    } else {
                        this.myDomainList = new Vector();
                    }
                } else {
                    this.myDomainList = new Vector();
                }
            } else if (stringArray[n].equals(myUserID_tag)) {
                parsedObject = parsedVector.getElement(myUserID_tag);
                string = (String)parsedObject.getValue();
                this.myUserID = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(myNameserverCount_tag)) {
                parsedObject = parsedVector.getElement(myNameserverCount_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n3 = Integer.valueOf(string);
                    this.myNameserverCount = n3;
                    if (this.myNameserverCount > 0) {
                        this.myNameserverList = new Vector(this.myNameserverCount);
                        n2 = 1;
                        while (n2 <= this.myNameserverCount) {
                            parsedObject = parsedVector.get(n + n2);
                            string = (String)parsedObject.getValue();
                            if (string != null) {
                                this.myNameserverList.addElement(new String(string));
                            }
                            ++n2;
                        }
                    } else {
                        this.myNameserverList = new Vector();
                    }
                } else {
                    this.myNameserverList = new Vector();
                }
            } else if (stringArray[n].equals(myRouteEntryCount_tag)) {
                if (this.myTrace) {
                    System.out.println("tag = myRouteEntryCount_tag");
                }
                if ((string = (String)(parsedObject = parsedVector.getElement(myRouteEntryCount_tag)).getValue()) != null) {
                    n3 = Integer.valueOf(string);
                    this.mySocksRouteEntryCount = n3;
                    if (this.mySocksRouteEntryCount > 0) {
                        if (this.myTrace) {
                            System.out.println("mySocksRouteEntryCount = " + this.mySocksRouteEntryCount);
                        }
                        this.mySocksRouteEntryList = new Vector(this.mySocksRouteEntryCount);
                        n2 = 1;
                        while (n2 <= this.mySocksRouteEntryCount) {
                            parsedObject = parsedVector.get(n + n2);
                            parsedVector2 = (ParsedVector)parsedObject.getValue();
                            if (parsedVector2 != null) {
                                if (this.myTrace) {
                                    System.out.println("imbeddedObjectVector != null");
                                }
                            } else if (this.myTrace) {
                                System.out.println("imbeddedObjectVector == null");
                            }
                            if (parsedVector2 != null) {
                                this.mySocksRouteEntryList.addElement(new SocksRouteEntry(parsedVector2));
                            }
                            ++n2;
                        }
                    } else {
                        this.mySocksRouteEntryList = new Vector();
                    }
                } else {
                    this.mySocksRouteEntryList = new Vector();
                }
            } else if (stringArray[n].equals(myUpdatedState_tag)) {
                parsedObject = parsedVector.getElement(myUpdatedState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n3 = Integer.valueOf(string);
                    if (n3 == 0) {
                        this.setUpdated(false);
                    } else {
                        this.setUpdated(true);
                    }
                }
            } else if (stringArray[n].equals(myServerEntryCount_tag)) {
                parsedObject = parsedVector.getElement(myServerEntryCount_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n3 = Integer.valueOf(string);
                    this.mySocksServerEntryCount = n3;
                    if (this.mySocksServerEntryCount > 0) {
                        this.mySocksServerEntryList = new Vector(this.mySocksServerEntryCount);
                        n2 = 1;
                        while (n2 <= this.mySocksServerEntryCount) {
                            parsedObject = parsedVector.get(n + n2);
                            parsedVector2 = (ParsedVector)parsedObject.getValue();
                            if (parsedVector2 != null) {
                                this.mySocksServerEntryList.addElement(new SocksServerEntry(parsedVector2));
                            }
                            ++n2;
                        }
                    } else {
                        this.mySocksServerEntryList = new Vector();
                    }
                } else {
                    this.mySocksServerEntryList = new Vector();
                }
            } else if (stringArray[n].equals(myEnabledState_tag) && (string = (String)(parsedObject = parsedVector.getElement(myEnabledState_tag)).getValue()) != null) {
                n3 = Integer.valueOf(string);
                this.myEnabledState = n3 != 0;
            }
            ++n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(BSO_tag);
        if (this.isUpdated()) {
            stringBuffer.append("," + myUpdatedState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myUpdatedState_tag + "=" + 0);
        }
        stringBuffer.append("," + myDomainCount_tag + "=" + String.valueOf(this.myDomainList.size()));
        Enumeration enumeration = this.myDomainList.elements();
        while (enumeration.hasMoreElements()) {
            try {
                String string = (String)enumeration.nextElement();
                stringBuffer.append("," + myDomain_tag + "=" + string);
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
        }
        stringBuffer.append("," + myUserID_tag + "=" + this.myUserID);
        stringBuffer.append("," + myNameserverCount_tag + "=" + String.valueOf(this.myNameserverList.size()));
        enumeration = this.myNameserverList.elements();
        while (enumeration.hasMoreElements()) {
            try {
                String string = (String)enumeration.nextElement();
                stringBuffer.append("," + myNameserver_tag + "=" + string);
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
        }
        stringBuffer.append("," + myRouteEntryCount_tag + "=" + String.valueOf(this.mySocksRouteEntryList.size()));
        enumeration = this.mySocksRouteEntryList.elements();
        while (enumeration.hasMoreElements()) {
            try {
                SocksRouteEntry socksRouteEntry = (SocksRouteEntry)enumeration.nextElement();
                stringBuffer.append("," + myRouteEntry_tag);
                stringBuffer.append("," + socksRouteEntry.toString());
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
        }
        stringBuffer.append("," + myServerEntryCount_tag + "=" + String.valueOf(this.mySocksServerEntryList.size()));
        enumeration = this.mySocksServerEntryList.elements();
        while (enumeration.hasMoreElements()) {
            try {
                SocksServerEntry socksServerEntry = (SocksServerEntry)enumeration.nextElement();
                stringBuffer.append("," + myServerEntry_tag);
                stringBuffer.append("," + socksServerEntry.toString());
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
        }
        if (this.myEnabledState) {
            stringBuffer.append("," + myEnabledState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myEnabledState_tag + "=" + 0);
        }
        stringBuffer.append("," + ESO_tag);
        return stringBuffer.toString();
    }
}

