/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.common;

import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCConfiguration;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCConstants;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCKeyword;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NotebookData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;

public class SocksRouteEntry
extends NotebookData
implements OOCConstants {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String BDE_tag = new String("Bde");
    public static final String EDE_tag = new String("Ede");
    private static final String myIPaddress_tag = new String("ipaddr");
    private static final String mySubnetMask_tag = new String("subnet");
    private String myIPaddress;
    private String mySubnetMask;
    private OOCKeyword kwDestination;
    private OOCKeyword kwNetmask;
    private boolean myTrace = Utility.isTraceOn();

    SocksRouteEntry() {
        if (this.myTrace) {
            System.out.println("in SocksRouteEntry() constructor");
        }
        this.loadInit();
    }

    public SocksRouteEntry(String string, String string2) {
        if (this.myTrace) {
            System.out.println("in SocksRouteEntry() constructor2");
        }
        this.myIPaddress = string;
        this.mySubnetMask = string2;
    }

    public SocksRouteEntry(ParsedVector parsedVector) {
        if (this.myTrace) {
            System.out.println("@@@@@@@@@ CONSRUCTING DirectRouteEntry from a ParsedVector");
        }
        this.fromString(parsedVector);
    }

    public String getIPaddress() {
        return this.myIPaddress;
    }

    public String getSubnetMask() {
        return this.mySubnetMask;
    }

    private void loadInit() {
        if (this.myTrace) {
            System.out.println("in loadInit() of SocksRouteEntry");
        }
        this.myIPaddress = new String("");
        this.mySubnetMask = new String("");
    }

    public void setIPaddress(String string) {
        this.myIPaddress = string;
    }

    public void setSubnetMask(String string) {
        this.mySubnetMask = string;
    }

    public void loadDirectRouteFromOOCS(OOCKeyword oOCKeyword) {
        this.myIPaddress = oOCKeyword.getValueOf("destination");
        this.mySubnetMask = oOCKeyword.getValueOf("netmask");
        if (this.myTrace) {
            System.out.println("(SocksRouteEntry.loadDirectRouteFromOOCS) myIPaddress = " + this.myIPaddress);
            System.out.println("(SocksRouteEntry.loadDirectRouteFromOOCS) mySubnetMask = " + this.mySubnetMask);
        }
    }

    public void saveDirectRouteToOOCS(OOCConfiguration oOCConfiguration, OOCKeyword oOCKeyword) {
        if (oOCKeyword == null) {
            oOCKeyword = oOCConfiguration.createKeyword(0, "direct_routes", "", null);
            if (this.kwNetmask == null) {
                this.kwDestination = oOCKeyword.createKeyword(1, "destination", "", null);
            }
            this.kwDestination.setValue(this.myIPaddress);
            if (this.myTrace) {
                System.out.println("(SocksRouteEntry.saveDirectRouteToOOCS) myIPaddress = " + this.myIPaddress);
            }
            if (this.kwNetmask == null) {
                this.kwNetmask = oOCKeyword.createKeyword(1, "netmask", "", null);
            }
            this.kwNetmask.setValue(this.mySubnetMask);
            if (this.myTrace) {
                System.out.println("(SocksRouteEntry.saveDirectRouteToOOCS) mySubnetMask = " + this.mySubnetMask);
                return;
            }
        } else {
            this.kwDestination = oOCKeyword.get("destination", "");
            this.kwDestination.setValue(this.myIPaddress);
            this.kwNetmask = oOCKeyword.get("netmask", "");
            this.kwNetmask.setValue(this.mySubnetMask);
            if (this.myTrace) {
                System.out.println("(SocksRouteEntry.saveDirectRouteToOOCS) myIPaddress = " + this.myIPaddress);
                System.out.println("(SocksRouteEntry.saveDirectRouteToOOCS) mySubnetMask = " + this.mySubnetMask);
            }
        }
    }

    public void fromString(ParsedVector parsedVector) {
        String[] stringArray = parsedVector.getKeys();
        int n = 0;
        while (n < stringArray.length) {
            String string;
            ParsedObject parsedObject;
            if (stringArray[n].equals(myIPaddress_tag)) {
                parsedObject = parsedVector.getElement(myIPaddress_tag);
                string = (String)parsedObject.getValue();
                this.myIPaddress = string != null ? new String(string) : new String("");
            }
            if (stringArray[n].equals(mySubnetMask_tag)) {
                parsedObject = parsedVector.getElement(mySubnetMask_tag);
                string = (String)parsedObject.getValue();
                this.mySubnetMask = string != null ? new String(string) : new String("");
            }
            ++n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(BDE_tag);
        stringBuffer.append("," + myIPaddress_tag + "=" + this.myIPaddress);
        stringBuffer.append("," + mySubnetMask_tag + "=" + this.mySubnetMask);
        stringBuffer.append("," + EDE_tag);
        return stringBuffer.toString();
    }
}

