/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.common;

import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCConfiguration;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCConstants;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCKeyword;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NotebookData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import java.security.MessageDigest;

public class SocksServerEntry
extends NotebookData
implements OOCConstants {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String BEE_tag = new String("Bee");
    public static final String EEE_tag = new String("Eee");
    private static final String mySocksServer_tag = new String("server");
    private static final String myIPaddress_tag = new String("ipaddr");
    private static final String mySubnetMask_tag = new String("subnet");
    private static final String myUserID_tag = new String("userid");
    private static final String myPassword_tag = new String("password");
    private static final String myVerifyPW_tag = new String("verifypw");
    private String mySocksServer;
    private String myIPaddress;
    private String mySubnetMask;
    private String myUserID;
    private String myPassword;
    private String myVerifyPW;
    private boolean myPasswordChanged = false;
    private OOCKeyword kwServer;
    private OOCKeyword kwDestination;
    private OOCKeyword kwNetmask;
    private OOCKeyword kwUserID;
    private OOCKeyword kwPassword;
    private OOCKeyword kwVerifyPW;
    private byte[] myEncryptedPw;
    private MessageDigest messDigest;
    private boolean myTrace = Utility.isTraceOn();

    SocksServerEntry() {
        if (this.myTrace) {
            System.out.println("in SocksServerEntry() constructor");
        }
        this.loadInit();
    }

    public SocksServerEntry(String string, String string2, String string3, String string4, String string5, boolean bl) {
        if (this.myTrace) {
            System.out.println("in SocksServerEntry() constructor2");
        }
        this.mySocksServer = string;
        this.myIPaddress = string2;
        this.mySubnetMask = string3;
        this.myUserID = string4;
        this.myPassword = string5;
        this.myPasswordChanged = bl;
    }

    public SocksServerEntry(ParsedVector parsedVector) {
        if (this.myTrace) {
            System.out.println("@@@@@@@@@ CONSRUCTING SocksServerEntry from a ParsedVector");
        }
        this.fromString(parsedVector);
    }

    public String getIPaddress() {
        return this.myIPaddress;
    }

    public String getServer() {
        return this.mySocksServer;
    }

    public String getSubnetMask() {
        return this.mySubnetMask;
    }

    public String getUserID() {
        return this.myUserID;
    }

    public String getPassword() {
        return this.myPassword;
    }

    public boolean getmyPasswordChange() {
        return this.myPasswordChanged;
    }

    private void loadInit() {
        if (this.myTrace) {
            System.out.println("in loadInit() of SocksServerEntry");
        }
        this.mySocksServer = new String("");
        this.myIPaddress = new String("");
        this.mySubnetMask = new String("");
        this.myUserID = new String("");
        this.myPassword = new String("");
        this.myVerifyPW = new String("");
    }

    public void setDest(String string) {
        this.myIPaddress = string;
    }

    public void setSocksServer(String string) {
        this.mySocksServer = string;
    }

    public void setSubnetMask(String string) {
        this.mySubnetMask = string;
    }

    public void setUsetID(String string) {
        this.myUserID = string;
    }

    public void setPassword(String string) {
        this.myPassword = string;
    }

    public void setmyPasswordChanged(boolean bl) {
        this.myPasswordChanged = bl;
    }

    public void loadSockdServerFromOOCS(OOCKeyword oOCKeyword) {
        this.mySocksServer = oOCKeyword.getValueOf("server");
        this.myIPaddress = oOCKeyword.getValueOf("destination");
        this.mySubnetMask = oOCKeyword.getValueOf("netmask");
        this.myUserID = oOCKeyword.getValueOf("userid");
        this.myPassword = oOCKeyword.getValueOf("password");
        this.setmyPasswordChanged(false);
        if (this.myTrace) {
            System.out.println("(SocksServerEntry.loadSockdServerFromOOCS) mySocksServer = " + this.mySocksServer);
            System.out.println("(SocksServerEntry.loadSockdServerFromOOCS) myIPaddress = " + this.myIPaddress);
            System.out.println("(SocksServerEntry.loadSockdServerFromOOCS) mySubnetMask = " + this.mySubnetMask);
        }
    }

    public void saveSockdServerToOOCS(OOCConfiguration oOCConfiguration, OOCKeyword oOCKeyword) {
        if (oOCKeyword == null) {
            oOCKeyword = oOCConfiguration.createKeyword(0, "sockd_server", "", null);
            if (this.kwServer == null) {
                this.kwServer = oOCKeyword.createKeyword(1, "server", "", null);
            }
            this.kwServer.setValue(this.mySocksServer);
            if (this.myTrace) {
                System.out.println("(SocksServerEntry.saveSockdServerToOOCS) mySocksServer = " + this.mySocksServer);
            }
            if (this.kwDestination == null) {
                this.kwDestination = oOCKeyword.createKeyword(1, "destination", "", null);
            }
            this.kwDestination.setValue(this.myIPaddress);
            if (this.myTrace) {
                System.out.println("(SocksServerEntry.saveSockdServerToOOCS) myIPaddress = " + this.myIPaddress);
            }
            if (this.kwNetmask == null) {
                this.kwNetmask = oOCKeyword.createKeyword(1, "netmask", "", null);
            }
            this.kwNetmask.setValue(this.mySubnetMask);
            if (this.myTrace) {
                System.out.println("(SocksServerEntry.saveSockdServerToOOCS) mySubnetMask = " + this.mySubnetMask);
            }
            if (this.kwUserID == null) {
                this.kwUserID = oOCKeyword.createKeyword(1, "userid", "", null);
            }
            this.kwUserID.setValue(this.myUserID);
            if (this.myTrace) {
                System.out.println("(SocksServerEntry.saveSockdServerToOOCS) myUserID = " + this.myUserID);
            }
            if (this.kwPassword == null) {
                this.kwPassword = oOCKeyword.createKeyword(1, "password", "", null);
            }
            this.kwPassword.setValue(this.myPassword);
            return;
        }
        this.kwServer = oOCKeyword.get("server", "");
        this.kwServer.setValue(this.mySocksServer);
        if (this.myTrace) {
            System.out.println("(SocksServerEntry.saveSockdServerToOOCS) mySocksServer = " + this.mySocksServer);
        }
        this.kwDestination = oOCKeyword.get("destination", "");
        this.kwDestination.setValue(this.myIPaddress);
        if (this.myTrace) {
            System.out.println("(SocksServerEntry.saveSockdServerToOOCS) myIPaddress = " + this.myIPaddress);
        }
        this.kwNetmask = oOCKeyword.get("netmask", "");
        this.kwNetmask.setValue(this.mySubnetMask);
        if (this.myTrace) {
            System.out.println("(SocksServerEntry.saveSockdServerToOOCS) mySubnetMask = " + this.mySubnetMask);
        }
        this.kwUserID = oOCKeyword.get("userid", "");
        this.kwUserID.setValue(this.myUserID);
        if (this.myTrace) {
            System.out.println("(SocksServerEntry.saveSockdServerToOOCS) myUserID = " + this.myUserID);
        }
        this.kwPassword = oOCKeyword.get("password", "");
        this.kwPassword.setValue(this.myPassword);
        if (this.myTrace) {
            System.out.println("(SocksServerEntry.saveSockdServerToOOCS) myPassword = " + this.myPassword);
        }
    }

    public void fromString(ParsedVector parsedVector) {
        String[] stringArray = parsedVector.getKeys();
        int n = 0;
        while (n < stringArray.length) {
            String string;
            ParsedObject parsedObject;
            if (stringArray[n].equals(mySocksServer_tag)) {
                parsedObject = parsedVector.getElement(mySocksServer_tag);
                string = (String)parsedObject.getValue();
                this.mySocksServer = string != null ? new String(string) : new String("");
            }
            if (stringArray[n].equals(myIPaddress_tag)) {
                parsedObject = parsedVector.getElement(myIPaddress_tag);
                string = (String)parsedObject.getValue();
                this.myIPaddress = string != null ? new String(string) : new String("");
            }
            if (stringArray[n].equals(mySubnetMask_tag)) {
                parsedObject = parsedVector.getElement(mySubnetMask_tag);
                string = (String)parsedObject.getValue();
                this.mySubnetMask = string != null ? new String(string) : new String("");
            }
            ++n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(BEE_tag);
        stringBuffer.append("," + mySocksServer_tag + "=" + this.mySocksServer.toString());
        stringBuffer.append("," + myIPaddress_tag + "=" + this.myIPaddress);
        stringBuffer.append("," + mySubnetMask_tag + "=" + this.mySubnetMask);
        stringBuffer.append("," + EEE_tag);
        return stringBuffer.toString();
    }
}

