/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.common;

import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCConstants;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCKeyword;
import COM.ibm.raleigh.tcp.tcpcfg2.common.CloneableItem;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NotebookData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;

public class TelnetAccess
extends NotebookData
implements Cloneable,
CloneableItem,
OOCConstants {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String BTA_tag = new String("Bta");
    public static final String ETA_tag = new String("Eta");
    public static final String myEnabledState_tag = new String("taEnab_yn");
    private static final boolean myEnabledStateDefault = false;
    private boolean myEnabledState = false;
    private OOCKeyword kwSrvrusr;
    private OOCKeyword kwActive;
    private boolean myTrace = Utility.isTraceOn();

    TelnetAccess() {
        if (this.myTrace) {
            System.out.println("in TelnetAccess constructor");
        }
        this.loadInit();
    }

    public TelnetAccess(ParsedVector parsedVector) {
        if (this.myTrace) {
            System.out.println("@@@@@@@@@ CONSRUCTING TelnetAccess from a ParsedVector");
        }
        this.fromString(parsedVector);
    }

    public Object clone() {
        if (this.myTrace) {
            System.out.println("in TelnetAccess.clone()");
        }
        TelnetAccess telnetAccess = new TelnetAccess();
        telnetAccess.setEnableUser(this.myEnabledState);
        return telnetAccess;
    }

    public boolean getEnableUser() {
        return this.myEnabledState;
    }

    public boolean isConfigured() {
        return this.myEnabledState;
    }

    private void loadInit() {
        if (this.myTrace) {
            System.out.println("in loadInit() of TelnetAccess");
        }
        this.myEnabledState = false;
        this.loaded = true;
    }

    public void setEnableUser(boolean bl) {
        this.myEnabledState = bl;
    }

    public void fromString(ParsedVector parsedVector) {
        String[] stringArray = parsedVector.getKeys();
        int n = 0;
        while (n < stringArray.length) {
            ParsedObject parsedObject;
            String string;
            if (stringArray[n].equals(myEnabledState_tag) && (string = (String)(parsedObject = parsedVector.getElement(myEnabledState_tag)).getValue()) != null) {
                Integer n2 = Integer.valueOf(string);
                this.myEnabledState = n2 != 0;
            }
            ++n;
        }
    }

    public String toString() {
        if (this.myTrace) {
            System.out.println("in TelnetAccess.toString() ");
        }
        StringBuffer stringBuffer = new StringBuffer(BTA_tag);
        stringBuffer.append("=start");
        if (this.myEnabledState) {
            stringBuffer.append("," + myEnabledState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myEnabledState_tag + "=" + 0);
        }
        stringBuffer.append("," + ETA_tag);
        stringBuffer.append("=end");
        return stringBuffer.toString();
    }

    public void loadTelnetAccessFromOOCS(OOCKeyword oOCKeyword) {
        String string;
        if (this.myTrace) {
            System.out.println("***** in TelnetAccess.loadTelnetAccessFromOOCS");
        }
        this.myEnabledState = (string = oOCKeyword.getValueOf("active")).equals("1");
        if (this.myTrace) {
            System.out.println("(TelnetAccess.loadTelnetAccessFromOOCS) myEnabledState = " + this.myEnabledState);
        }
    }

    public void saveTelnetAccessToOOCS(OOCKeyword oOCKeyword, OOCKeyword oOCKeyword2) {
        if (this.myTrace) {
            System.out.println("***** in TelnetAccess.saveTelnetAccessToOOCS");
        }
        if (oOCKeyword2 == null) {
            oOCKeyword2 = oOCKeyword.createKeyword(0, "telnetd", "", null);
        }
        this.kwActive = this.kwActive == null ? oOCKeyword2.createKeyword(1, "active", "", null) : oOCKeyword2.get("active", "");
        if (this.myEnabledState) {
            this.kwActive.setValue("1");
        } else {
            this.kwActive.setValue("0");
        }
        if (this.myTrace) {
            System.out.println("(TelnetAccess.saveTelnetAccessToOOCS) myEnabledState = " + this.myEnabledState);
        }
    }
}

