/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.common;

import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCConstants;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCKeyword;
import COM.ibm.raleigh.tcp.tcpcfg2.common.CloneableItem;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NotebookData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;

public class TftpaEntry
extends NotebookData
implements Cloneable,
OOCConstants,
CloneableItem {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String BTA_tag = new String("Btn");
    public static final String ETA_tag = new String("Etn");
    public static final String myAccess_tag = new String("tftpaAcess");
    public static final String myDirectory_tag = new String("tftpaDirectory");
    public static final String myAlias_tag = new String("tftpaAlias");
    private String myAccess;
    private String myDirectory;
    private String myAlias;
    private OOCKeyword kwTftpa;
    private OOCKeyword kwAccess;
    private OOCKeyword kwDirectory;
    private OOCKeyword kwAlias;
    private boolean myTrace = Utility.isTraceOn();

    public TftpaEntry() {
        if (this.myTrace) {
            System.out.println("in TftpaEntry() constructor");
        }
        this.loadInit();
    }

    public TftpaEntry(String string, String string2, String string3) {
        if (this.myTrace) {
            System.out.println("in TftpaEntry() constructor2");
        }
        this.myAccess = string;
        this.myDirectory = string2;
        this.myAlias = string3;
    }

    public TftpaEntry(ParsedVector parsedVector) {
        if (this.myTrace) {
            System.out.println("@@@@@@@@@ CONSRUCTING TftpaEntry from a ParsedVector");
        }
        this.fromString(parsedVector);
    }

    public Object clone() {
        TftpaEntry tftpaEntry = new TftpaEntry();
        tftpaEntry.setAccess(this.myAccess);
        tftpaEntry.setDirectory(this.myDirectory);
        tftpaEntry.setAlias(this.myAlias);
        return tftpaEntry;
    }

    public String getAccess() {
        return this.myAccess;
    }

    public String getDirectory() {
        return this.myDirectory;
    }

    public String getAlias() {
        return this.myAlias;
    }

    private void loadInit() {
        if (this.myTrace) {
            System.out.println("in loadInit() of TftpaEntry");
        }
        this.myAccess = new String("");
        this.myDirectory = new String("");
        this.myAlias = new String("");
    }

    public void setAccess(String string) {
        this.myAccess = string;
    }

    public void setDirectory(String string) {
        this.myDirectory = string;
    }

    public void setAlias(String string) {
        this.myAlias = string;
    }

    public void loadTftpaAccessFromOOCS(OOCKeyword oOCKeyword) {
        this.myAccess = oOCKeyword.getValueOf("tftpa_access");
        this.myDirectory = oOCKeyword.getValueOf("tftpa_directory");
        this.myAlias = oOCKeyword.getValueOf("tftpa_alias");
        if (this.myTrace) {
            System.out.println("(TftpaEntry.loadTftpaAccessFromOOCS) myAccess = " + this.myAccess);
            System.out.println("(TftpaEntry.loadTftpaAccessFromOOCS) myDirectory = " + this.myDirectory);
            System.out.println("(TftpaEntry.loadTftpaAccessFromOOCS) myAlias = " + this.myAlias);
        }
    }

    public void saveTftpaAccessToOOCS(OOCKeyword oOCKeyword) {
        if (NotebookData.hasValue(this.myAccess)) {
            this.kwAccess = oOCKeyword.createKeyword(1, "tftpa_access", "", null);
            this.kwAccess.setValue(this.myAccess);
        }
        if (NotebookData.hasValue(this.myDirectory)) {
            this.kwDirectory = oOCKeyword.createKeyword(1, "tftpa_directory", "", null);
            this.kwDirectory.setValue(this.myDirectory);
        }
        if (NotebookData.hasValue(this.myAlias)) {
            this.kwAlias = oOCKeyword.createKeyword(1, "tftpa_alias", "", null);
            this.kwAlias.setValue(this.myAlias);
        }
        if (this.myTrace) {
            System.out.println("(TftpaEntry.saveTftpaAccessToOOCS) myAccess = " + this.myAccess);
            System.out.println("(TftpaEntry.saveTftpaAccessToOOCS) myDirectory = " + this.myDirectory);
            System.out.println("(TftpaEntry.saveTftpaAccessToOOCS) myAlias  = " + this.myAlias);
        }
    }

    public void fromString(ParsedVector parsedVector) {
        if (this.myTrace) {
            System.out.println("TftpaEntry.fromString()");
        }
        String[] stringArray = parsedVector.getKeys();
        int n = 0;
        while (n < stringArray.length) {
            String string;
            ParsedObject parsedObject;
            if (stringArray[n].equals(myAccess_tag)) {
                parsedObject = parsedVector.getElement(myAccess_tag);
                string = (String)parsedObject.getValue();
                this.myAccess = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(myDirectory_tag)) {
                parsedObject = parsedVector.getElement(myDirectory_tag);
                string = (String)parsedObject.getValue();
                this.myDirectory = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(myAlias_tag)) {
                parsedObject = parsedVector.getElement(myAlias_tag);
                string = (String)parsedObject.getValue();
                this.myAlias = string != null ? new String(string) : new String("");
            }
            ++n;
        }
    }

    public String toString() {
        if (this.myTrace) {
            System.out.println("in TftpaEntry.toString() ");
        }
        StringBuffer stringBuffer = new StringBuffer(BTA_tag);
        stringBuffer.append("=start");
        stringBuffer.append("," + myAccess_tag + "=" + this.myAccess);
        stringBuffer.append("," + myDirectory_tag + "=" + this.myDirectory);
        stringBuffer.append("," + myAlias_tag + "=" + this.myAlias);
        stringBuffer.append("," + ETA_tag);
        stringBuffer.append("=end");
        return stringBuffer.toString();
    }
}

