/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.common;

import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCConfiguration;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCConstants;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCKeyword;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCMessageQueue;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCProductInfo;
import COM.ibm.raleigh.tcp.tcpcfg2.common.ErrorListController;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NotebookData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.RshEntry;
import COM.ibm.raleigh.tcp.tcpcfg2.common.TcpError;
import COM.ibm.raleigh.tcp.tcpcfg2.common.TftpEntry;
import COM.ibm.raleigh.tcp.tcpcfg2.common.TftpaEntry;
import COM.ibm.raleigh.tcp.tcpcfg2.common.UserDataStreamProcessor;
import COM.ibm.raleigh.tcp.tcpcfg2.common.UserEntry;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import COM.ibm.raleigh.tcp.tcpcfg2.server.NativeData;
import COM.ibm.raleigh.tcp.tcpcfg2.server.ServerMsg;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;

public class UserData
extends NotebookData
implements OOCConstants {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String BUD_tag = new String("Bud");
    public static final String EUD_tag = new String("Eud");
    public static final String DATA_ID = new String("USERDATA");
    public static final String SAVE_ID = new String("SAVE_USER_DATA");
    public static final String LOAD_ID = new String("LOAD_USER_DATA");
    private static final String myUserEntrySelectedIndex_tag = new String("usrSel");
    private static final String myTftpEntrySelectedIndex_tag = new String("tftpSel");
    private static final String myTftpaEntrySelectedIndex_tag = new String("tftpaSel");
    private static final String myRshEntrySelectedIndex_tag = new String("rshSel");
    private static final String myUserEntryListCnt_tag = new String("numUent");
    private static final String myUserEntryList_tag = new String("EMBEDDED_BUE_BELONGS_TO_BUD");
    public static final String myRshEntryList_tag = new String("ueRshSrvr");
    public static final String myTftpaEntryList_tag = new String("ueTftpaAuth");
    public static final String myTftpEntryList_tag = new String("EMBEDDED_BTF_BELONGS_TO_BUE");
    public static final String myRshEntryListCnt_tag = new String("ueRshCnt");
    public static final String myTftpaEntryListCnt_tag = new String("ueTftpaCnt");
    public static final String myTftpEntryListCnt_tag = new String("ueTftpCnt");
    public static final String myUsersOnDiskCnt_tag = new String("ueTot");
    public static final String myLastUserLoadedCnt_tag = new String("ueLastCnt");
    public static final String COMMIT_EXCEPTION = new String("Bad vector identifier passed to UserData.commit(int)");
    public static final String DECOMMIT_EXCEPTION = new String("Bad vector identifier passed to UserData.decommit(int)");
    private Vector myUserEntryList;
    private Vector mySavedUserEntryList;
    private Vector myRshEntryList;
    private Vector myTftpEntryList;
    private Vector myTftpaEntryList;
    private Vector mySavedRshEntryList;
    private Vector mySavedTftpEntryList;
    private Vector mySavedTftpaEntryList;
    private int myRshEntryListCnt;
    private int myTftpEntryListCnt;
    private int myTftpSelectedIndex;
    private int myTftpaEntryListCnt;
    private int myTftpaSelectedIndex;
    private int myUserEntrySelectedIndex;
    private int myTftpEntrySelectedIndex;
    private int myTftpaEntrySelectedIndex;
    private int myRshEntrySelectedIndex;
    private int myUserEntryListCnt;
    private int myUsersOnDiskCnt;
    private int myLastUserLoadedCnt;
    private OOCProductInfo myUserDataProductInfo;
    private OOCProductInfo myRshDataProductInfo;
    private OOCProductInfo myTftpDataProductInfo;
    private OOCProductInfo myTftpaDataProductInfo;
    private OOCConfiguration myUserDataConfiguration;
    private OOCConfiguration myRshDataConfiguration;
    private OOCConfiguration myTftpDataConfiguration;
    private OOCConfiguration myTftpaDataConfiguration;
    private OOCMessageQueue myMessageQueue;
    private OOCKeyword kwSrvrusr;
    private OOCKeyword kwRshUser;
    private OOCKeyword kwTftpDir;
    private OOCKeyword kwTftpUser;
    private OOCKeyword kwTftpaAuthorization;
    private NativeData myNativeData;
    private String userdataDatFile;
    private String userdataConfigFile;
    private String userdatabakFile;
    private String rshdataDatFile;
    private String rshdataConfigFile;
    private String rshdatabakFile;
    private String tftpdataDatFile;
    private String tftpdataConfigFile;
    private String tftpdatabakFile;
    private String tftpadataDatFile;
    private String tftpadataConfigFile;
    private String tftpadatabakFile;
    private String logFile;
    private static final String userdataParseRules = "TCPNBK_PARSING";
    private static final String rshdataParseRules = "RHOSTS_RULES";
    private static final String tftpdataParseRules = "TFPATH_RULES";
    private static final String tftpadataParseRules = "TFTPA_RULES";
    private boolean noExistingUserdata = false;
    private boolean noExistingRshdata = false;
    private boolean noExistingTftpdata = false;
    private boolean noExistingTftpadata = false;
    private boolean noUserProductInfo = false;
    private boolean noRshProductInfo = false;
    private boolean noTftpProductInfo = false;
    private boolean noTftpaProductInfo = false;
    private boolean already_closed = false;
    private String myEtcPath;
    public static final int TFTP_ENTRY = 0;
    public static final int RSH_ENTRY = 1;
    public static final int USER_ENTRY = 2;
    public static final int TFTPA_ENTRY = 3;
    ErrorListController myErrorListController;
    private ResourceBundle myBundle;
    private boolean myTrace = Utility.isTraceOn();

    public UserData() {
        if (this.myTrace) {
            System.out.println("in UserData() constructor");
        }
        this.loadInit();
        this.myBundle = ServerMsg.getBundle();
    }

    public UserData(boolean bl, ErrorListController errorListController) {
        if (this.myTrace) {
            System.out.println("in UserData() constructor2");
        }
        this.loadInit();
        this.myErrorListController = errorListController;
        this.myBundle = ServerMsg.getBundle();
        if (bl) {
            this.loadFromOOCS();
        }
    }

    public UserData(ParsedVector parsedVector) {
        if (this.myTrace) {
            System.out.println("@@@@@@@@@ CONSRUCTING UserData from a ParsedVector");
        }
        this.fromString(parsedVector);
    }

    public void addRshEntry(RshEntry rshEntry) {
        this.myRshEntryList.addElement(rshEntry);
        this.myRshEntryListCnt = this.getRshEntryListSize();
    }

    public void addTftpEntry(TftpEntry tftpEntry) {
        this.myTftpEntryList.addElement(tftpEntry);
        this.myTftpEntryListCnt = this.getTftpEntryListSize();
    }

    public void addTftpaEntry(TftpaEntry tftpaEntry) {
        this.myTftpaEntryList.addElement(tftpaEntry);
        this.myTftpaEntryListCnt = this.getTftpaEntryListSize();
    }

    public void addUserEntry(UserEntry userEntry) {
        this.myUserEntryList.addElement(userEntry);
        if (this.myTrace) {
            System.out.println(" in UserData.addUserEntry - about to add user");
            System.out.println(" in UserData.addUserEntry - user added, size = " + this.getUserEntryListSize());
        }
        this.myUserEntryListCnt = this.getUserEntryListSize();
    }

    public void changeRshEntry(RshEntry rshEntry, int n) {
        this.myRshEntryList.setElementAt(rshEntry, n);
    }

    public void changeTftpEntry(TftpEntry tftpEntry, int n) {
        this.myTftpEntryList.setElementAt(tftpEntry, n);
    }

    public void changeTftpaEntry(TftpaEntry tftpaEntry, int n) {
        this.myTftpaEntryList.setElementAt(tftpaEntry, n);
    }

    public void commit(int n) {
        if (this.myTrace) {
            System.out.println(" in UserData.commit()");
        }
        switch (n) {
            case 2: {
                if (this.myTrace) {
                    System.out.println(" in UserData.commit() - USER_ENTRY");
                }
                this.mySavedUserEntryList.removeAllElements();
                this.mySavedUserEntryList = (Vector)this.myUserEntryList.clone();
                this.cloneVectorContents(this.myUserEntryList, this.mySavedUserEntryList);
                break;
            }
            case 1: {
                if (this.myTrace) {
                    System.out.println(" in UserData.commit() - RSH_ENTRY");
                }
                this.mySavedRshEntryList.removeAllElements();
                this.mySavedRshEntryList = (Vector)this.myRshEntryList.clone();
                this.cloneVectorContents(this.myRshEntryList, this.mySavedRshEntryList);
                break;
            }
            case 0: {
                if (this.myTrace) {
                    System.out.println(" in UserData.commit() - TFTP_ENTRY");
                }
                this.mySavedTftpEntryList.removeAllElements();
                this.mySavedTftpEntryList = (Vector)this.myTftpEntryList.clone();
                this.cloneVectorContents(this.myTftpEntryList, this.mySavedTftpEntryList);
                break;
            }
            case 3: {
                if (this.myTrace) {
                    System.out.println(" in UserData.commit() - TFTPA_ENTRY");
                }
                this.mySavedTftpaEntryList.removeAllElements();
                this.mySavedTftpaEntryList = (Vector)this.myTftpaEntryList.clone();
                this.cloneVectorContents(this.myTftpaEntryList, this.mySavedTftpaEntryList);
                break;
            }
            default: {
                throw new IllegalArgumentException(COMMIT_EXCEPTION);
            }
        }
        if (this.myTrace) {
            System.out.println(" leaving UserData.commit()");
        }
    }

    public void deCommit(int n) {
        if (this.myTrace) {
            System.out.println(" in UserData.deCommit()");
        }
        switch (n) {
            case 2: {
                if (this.myTrace) {
                    System.out.println(" in UserData.deCommit() - USER_ENTRY");
                }
                if (this.myUserEntryList.size() > 0) {
                    this.myUserEntryList.removeAllElements();
                }
                this.myUserEntryList = (Vector)this.mySavedUserEntryList.clone();
                this.cloneVectorContents(this.mySavedUserEntryList, this.myUserEntryList);
                return;
            }
            case 1: {
                if (this.myTrace) {
                    System.out.println(" in UserData.deCommit() - RSH_ENTRY");
                }
                if (this.myRshEntryList.size() > 0) {
                    this.myRshEntryList.removeAllElements();
                }
                this.myRshEntryList = (Vector)this.mySavedRshEntryList.clone();
                this.cloneVectorContents(this.mySavedRshEntryList, this.myRshEntryList);
                return;
            }
            case 0: {
                if (this.myTrace) {
                    System.out.println(" in UserData.deCommit() - TFTP_ENTRY");
                }
                if (this.myTftpEntryList.size() > 0) {
                    this.myTftpEntryList.removeAllElements();
                }
                this.myTftpEntryList = (Vector)this.mySavedTftpEntryList.clone();
                this.cloneVectorContents(this.mySavedTftpEntryList, this.myTftpEntryList);
                return;
            }
            case 3: {
                if (this.myTrace) {
                    System.out.println(" in UserData.deCommit() - TFTPA_ENTRY");
                }
                if (this.myTftpaEntryList.size() > 0) {
                    this.myTftpaEntryList.removeAllElements();
                }
                this.myTftpaEntryList = (Vector)this.mySavedTftpaEntryList.clone();
                this.cloneVectorContents(this.mySavedTftpaEntryList, this.myTftpaEntryList);
                return;
            }
        }
        throw new IllegalArgumentException(DECOMMIT_EXCEPTION);
    }

    public void deleteRshEntry(int n) {
        this.myRshEntryList.removeElementAt(n);
        this.myRshEntryListCnt = this.getRshEntryListSize();
    }

    public void deleteRshEntryList() {
        this.myRshEntryList.removeAllElements();
        this.myRshEntryListCnt = this.getRshEntryListSize();
    }

    public void deleteTftpEntry(int n) {
        this.myTftpEntryList.removeElementAt(n);
        this.myTftpEntryListCnt = this.getTftpEntryListSize();
    }

    public void deleteTftpEntryList() {
        this.myTftpEntryList.removeAllElements();
        this.myTftpEntryListCnt = this.getTftpEntryListSize();
    }

    public void deleteTftpaEntry(int n) {
        this.myTftpaEntryList.removeElementAt(n);
        this.myTftpaEntryListCnt = this.getTftpaEntryListSize();
    }

    public void deleteTftpaEntryList() {
        this.myTftpaEntryList.removeAllElements();
        this.myTftpaEntryListCnt = this.getTftpaEntryListSize();
    }

    public void deleteUserEntryList() {
        this.myUserEntryList.removeAllElements();
        this.myUserEntryListCnt = this.getUserEntryListSize();
    }

    public void deleteUserEntry(int n) {
        this.myUserEntryList.removeElementAt(n);
        this.myUserEntryListCnt = this.getUserEntryListSize();
    }

    public int getLastUserLoaded() {
        return this.myLastUserLoadedCnt;
    }

    public RshEntry getRshEntry(int n) {
        return (RshEntry)this.myRshEntryList.elementAt(n);
    }

    public TftpEntry getTftpEntry(int n) {
        return (TftpEntry)this.myTftpEntryList.elementAt(n);
    }

    public int getTftpSelectedIndex() {
        return this.myTftpSelectedIndex;
    }

    public TftpaEntry getTftpaEntry(int n) {
        return (TftpaEntry)this.myTftpaEntryList.elementAt(n);
    }

    public int getTftpaSelectedIndex() {
        return this.myTftpaSelectedIndex;
    }

    public int getRshEntryListSize() {
        return this.myRshEntryList.size();
    }

    public int getTftpEntryListSize() {
        return this.myTftpEntryList.size();
    }

    public int getTftpaEntryListSize() {
        return this.myTftpaEntryList.size();
    }

    public int getUserEntryListSize() {
        return this.myUserEntryList.size();
    }

    public int getUsersOnDiskCnt() {
        return this.myUsersOnDiskCnt;
    }

    public UserEntry getUserEntry(int n) {
        if (this.myTrace) {
            System.out.println("in UserData.getUserEntry()");
        }
        return (UserEntry)this.myUserEntryList.elementAt(n);
    }

    public int getUserSelectedIndex() {
        return this.myUserEntrySelectedIndex;
    }

    public void initCommit() {
        this.mySavedUserEntryList = new Vector();
        this.mySavedRshEntryList = new Vector();
        this.mySavedTftpEntryList = new Vector();
        this.mySavedTftpaEntryList = new Vector();
        this.commit(2);
        this.commit(1);
        this.commit(0);
        this.commit(3);
    }

    private void loadInit() {
        if (this.myTrace) {
            System.out.println("in loadInit() of UserData");
        }
        this.myUserEntryList = new Vector();
        this.mySavedUserEntryList = new Vector();
        this.mySavedRshEntryList = new Vector();
        this.mySavedTftpEntryList = new Vector();
        this.mySavedTftpaEntryList = new Vector();
        this.myRshEntryList = new Vector();
        this.myTftpEntryList = new Vector();
        this.myTftpaEntryList = new Vector();
        this.myUserEntryListCnt = 0;
        this.myRshEntryListCnt = 0;
        this.myTftpEntryListCnt = 0;
        this.myTftpaEntryListCnt = 0;
        this.myTftpSelectedIndex = 0;
        this.myUsersOnDiskCnt = 0;
        this.myLastUserLoadedCnt = 0;
    }

    public void setLastUserLoadedCnt(int n) {
        this.myLastUserLoadedCnt = n;
    }

    public void setTftpSelectedIndex(int n) {
        this.myTftpSelectedIndex = n;
    }

    public void setTftpaSelectedIndex(int n) {
        this.myTftpaSelectedIndex = n;
    }

    public void setUserSelectedIndex(int n) {
        this.myUserEntrySelectedIndex = n;
    }

    public void setUsersOnDiskCnt(int n) {
        this.myUsersOnDiskCnt = n;
    }

    private void loadFromOOCS() {
        OOCMessageQueue oOCMessageQueue;
        TcpError tcpError;
        Object object;
        int n;
        if (this.myTrace) {
            System.out.println("......in UserData.loadFromOOCS() of UserData");
        }
        this.myEtcPath = NativeData.getEtcPath();
        this.userdataDatFile = String.valueOf(this.myEtcPath) + "dat" + File.separator + "tcpnbk.dat";
        this.userdataConfigFile = String.valueOf(this.myEtcPath) + "tcpnbk.lst";
        this.userdatabakFile = String.valueOf(this.myEtcPath) + "tcpnbk.nbk";
        this.rshdataDatFile = String.valueOf(this.myEtcPath) + "dat" + File.separator + "toxrhost.dat";
        this.rshdataConfigFile = String.valueOf(this.myEtcPath) + "rhosts";
        this.rshdatabakFile = String.valueOf(this.myEtcPath) + "rhosts.nbk";
        this.tftpdataDatFile = String.valueOf(this.myEtcPath) + "dat" + File.separator + "toxtftp.dat";
        this.tftpdataConfigFile = String.valueOf(this.myEtcPath) + "tftpauth";
        this.tftpdatabakFile = String.valueOf(this.myEtcPath) + "tftpauth.nbk";
        this.tftpadataDatFile = String.valueOf(this.myEtcPath) + "dat" + File.separator + "toxtftpa.dat";
        this.tftpadataConfigFile = String.valueOf(this.myEtcPath) + "tftpacc.ctl";
        this.tftpadatabakFile = String.valueOf(this.myEtcPath) + "tftpacc.nbk";
        this.logFile = String.valueOf(this.myEtcPath) + "tcpcfg2.log";
        this.myUserDataProductInfo = new OOCProductInfo();
        if (this.myTrace) {
            System.out.println("(UserData.loadFromOOCS) myUserDataProductInfo userdataDatFile = " + this.userdataDatFile);
        }
        if ((n = this.myUserDataProductInfo.create(this.userdataDatFile)) == 0) {
            if (this.myTrace) {
                System.out.println("(UserData.loadFromOOCS) myUserDataProductInfo.create successful");
            }
            this.myUserDataProductInfo.setFileOpenMode(3);
            this.myUserDataProductInfo.setFileShareMode(0);
            this.myUserDataProductInfo.setProcessingOptions(1, 1, 1);
            this.myUserDataProductInfo.setParsingInfo(userdataParseRules);
            this.myUserDataConfiguration = new OOCConfiguration();
            if (this.myTrace) {
                System.out.println("(UserData.loadFromOOCS) myUserDataConfiguration userdataConfigFile = " + this.userdataConfigFile);
            }
            if ((n = this.myUserDataConfiguration.open(this.myUserDataProductInfo, this.userdataConfigFile)) == 2) {
                n = this.myUserDataConfiguration.open(this.myUserDataProductInfo, "");
                if (this.myTrace) {
                    System.out.println("(UserData.loadFromOOCS) myUserDataConfiguration.create successful...no preexisting file");
                }
                this.noExistingUserdata = true;
            }
            if (this.myTrace) {
                System.out.println("(UserData.loadFromOOCS) myUserDataConfiguration.create successful");
            }
            this.myUserDataConfiguration.write(this.userdatabakFile, 1, 1, 1, 0, userdataParseRules);
            this.myMessageQueue = this.myUserDataConfiguration.getMsgQ();
            this.myMessageQueue.replaceLogFile(0);
            this.myMessageQueue.setLogFileName(this.logFile);
            this.myMessageQueue.setLogOption(1);
            this.myMessageQueue.logQueue();
            this.myUserDataProductInfo.close();
        } else {
            this.noUserProductInfo = true;
            if (this.myTrace) {
                System.out.println("(UserData.loadFromOOCS) ERROR: myUserDataProductInfo.create failed");
            }
            object = new Object[]{this.userdataDatFile, "tcpnbk.lst"};
            tcpError = new TcpError(MessageFormat.format(this.myBundle.getString("WARNING_FILE_NOT_FOUND"), (Object[])object), 1);
            this.myErrorListController.addError(tcpError);
            oOCMessageQueue = OOCMessageQueue.getStaticMsgQ();
            oOCMessageQueue.replaceLogFile(0);
            oOCMessageQueue.setLogFileName(this.logFile);
            oOCMessageQueue.setLogOption(2);
            oOCMessageQueue.logQueue();
            if (this.myTrace) {
                System.out.println("(UserData.loadFromOOCS) Messages were logged to filename " + this.logFile);
            }
        }
        this.myRshDataProductInfo = new OOCProductInfo();
        if (this.myTrace) {
            System.out.println("(UserData.loadFromOOCS) myRshDataProductInfo rshdataDatFile = " + this.rshdataDatFile);
        }
        if ((n = this.myRshDataProductInfo.create(this.rshdataDatFile)) == 0) {
            if (this.myTrace) {
                System.out.println("(UserData.loadFromOOCS) myRshDataProductInfo.create successful");
            }
            this.myRshDataProductInfo.setFileOpenMode(3);
            this.myRshDataProductInfo.setFileShareMode(0);
            this.myRshDataProductInfo.setProcessingOptions(1, 1, 1);
            this.myRshDataProductInfo.setParsingInfo(rshdataParseRules);
            this.myRshDataConfiguration = new OOCConfiguration();
            if (this.myTrace) {
                System.out.println("(UserData.loadFromOOCS) myRshDataConfiguration rshdataConfigFile = " + this.rshdataConfigFile);
            }
            if ((n = this.myRshDataConfiguration.open(this.myRshDataProductInfo, this.rshdataConfigFile)) == 2) {
                n = this.myRshDataConfiguration.open(this.myRshDataProductInfo, "");
                if (this.myTrace) {
                    System.out.println("(UserData.loadFromOOCS) myRshDataConfiguration.create successful...no preexisting file");
                }
                this.noExistingRshdata = true;
            }
            if (this.myTrace) {
                System.out.println("(UserData.loadFromOOCS) myRshDataConfiguration.create successful");
            }
            this.myRshDataConfiguration.write(this.rshdatabakFile, 1, 1, 1, 0, rshdataParseRules);
            this.myMessageQueue = this.myRshDataConfiguration.getMsgQ();
            this.myMessageQueue.replaceLogFile(0);
            this.myMessageQueue.setLogFileName(this.logFile);
            this.myMessageQueue.setLogOption(1);
            this.myMessageQueue.logQueue();
            this.myRshDataProductInfo.close();
        } else {
            this.noRshProductInfo = true;
            if (this.myTrace) {
                System.out.println("(UserData.loadFromOOCS) ERROR: myRshDataProductInfo.create failed");
            }
            object = new Object[]{this.rshdataDatFile, "rhosts"};
            tcpError = new TcpError(MessageFormat.format(this.myBundle.getString("WARNING_FILE_NOT_FOUND"), (Object[])object), 1);
            this.myErrorListController.addError(tcpError);
            oOCMessageQueue = OOCMessageQueue.getStaticMsgQ();
            oOCMessageQueue.replaceLogFile(0);
            oOCMessageQueue.setLogFileName(this.logFile);
            oOCMessageQueue.setLogOption(2);
            oOCMessageQueue.logQueue();
            if (this.myTrace) {
                System.out.println("(UserData.loadFromOOCS) Messages were logged to filename " + this.logFile);
            }
        }
        this.myTftpDataProductInfo = new OOCProductInfo();
        if (this.myTrace) {
            System.out.println("(UserData.loadFromOOCS) myTftpDataProductInfo tftpdataDatFile = " + this.tftpdataDatFile);
        }
        if ((n = this.myTftpDataProductInfo.create(this.tftpdataDatFile)) == 0) {
            if (this.myTrace) {
                System.out.println("(UserData.loadFromOOCS) myTftpDataProductInfo.create successful");
            }
            this.myTftpDataProductInfo.setFileOpenMode(3);
            this.myTftpDataProductInfo.setFileShareMode(0);
            this.myTftpDataProductInfo.setProcessingOptions(1, 1, 1);
            this.myTftpDataProductInfo.setParsingInfo(tftpdataParseRules);
            this.myTftpDataConfiguration = new OOCConfiguration();
            if (this.myTrace) {
                System.out.println("(UserData.loadFromOOCS) myTftpDataConfiguration tftpdataConfigFile = " + this.tftpdataConfigFile);
            }
            if ((n = this.myTftpDataConfiguration.open(this.myTftpDataProductInfo, this.tftpdataConfigFile)) == 2) {
                n = this.myTftpDataConfiguration.open(this.myTftpDataProductInfo, "");
                if (this.myTrace) {
                    System.out.println("(UserData.loadFromOOCS) myTftpDataConfiguration.create successful...no preexisting file");
                }
                this.noExistingTftpdata = true;
            }
            if (this.myTrace) {
                System.out.println("(UserData.loadFromOOCS) myTftpDataConfiguration.create successful");
            }
            this.myTftpDataConfiguration.write(this.tftpdatabakFile, 1, 1, 1, 0, tftpdataParseRules);
            this.myMessageQueue = this.myTftpDataConfiguration.getMsgQ();
            this.myMessageQueue.replaceLogFile(0);
            this.myMessageQueue.setLogFileName(this.logFile);
            this.myMessageQueue.setLogOption(1);
            this.myMessageQueue.logQueue();
            this.myTftpDataProductInfo.close();
        } else {
            this.noTftpProductInfo = true;
            if (this.myTrace) {
                System.out.println("(UserData.loadFromOOCS) ERROR: myTftpDataProductInfo.create failed");
            }
            object = new Object[]{this.tftpdataDatFile, "tftpauth"};
            tcpError = new TcpError(MessageFormat.format(this.myBundle.getString("WARNING_FILE_NOT_FOUND"), (Object[])object), 1);
            this.myErrorListController.addError(tcpError);
            oOCMessageQueue = OOCMessageQueue.getStaticMsgQ();
            oOCMessageQueue.replaceLogFile(0);
            oOCMessageQueue.setLogFileName(this.logFile);
            oOCMessageQueue.setLogOption(2);
            oOCMessageQueue.logQueue();
            if (this.myTrace) {
                System.out.println("(UserData.loadFromOOCS) Messages were logged to filename " + this.logFile);
            }
        }
        this.myTftpaDataProductInfo = new OOCProductInfo();
        if (this.myTrace) {
            System.out.println("(UserData.loadFromOOCS) myTftpaDataProductInfo tftpadataDatFile = " + this.tftpadataDatFile);
        }
        if ((n = this.myTftpaDataProductInfo.create(this.tftpadataDatFile)) == 0) {
            if (this.myTrace) {
                System.out.println("(UserData.loadFromOOCS) myTftpaDataProductInfo.create successful");
            }
            this.myTftpaDataProductInfo.setFileOpenMode(3);
            this.myTftpaDataProductInfo.setFileShareMode(0);
            this.myTftpaDataProductInfo.setProcessingOptions(1, 1, 1);
            this.myTftpaDataProductInfo.setParsingInfo(tftpadataParseRules);
            this.myTftpaDataConfiguration = new OOCConfiguration();
            if (this.myTrace) {
                System.out.println("(UserData.loadFromOOCS) myTftpaDataConfiguration tftpadataConfigFile = " + this.tftpadataConfigFile);
            }
            if ((n = this.myTftpaDataConfiguration.open(this.myTftpaDataProductInfo, this.tftpadataConfigFile)) == 2) {
                n = this.myTftpaDataConfiguration.open(this.myTftpaDataProductInfo, "");
                if (this.myTrace) {
                    System.out.println("(UserData.loadFromOOCS) myTftpaDataConfiguration.create successful...no preexisting file");
                }
                this.noExistingTftpdata = true;
            }
            if (this.myTrace) {
                System.out.println("(UserData.loadFromOOCS) myTftpaDataConfiguration.create successful");
            }
            this.myTftpaDataConfiguration.write(this.tftpadatabakFile, 1, 1, 1, 0, tftpadataParseRules);
            this.myMessageQueue = this.myTftpaDataConfiguration.getMsgQ();
            this.myMessageQueue.replaceLogFile(0);
            this.myMessageQueue.setLogFileName(this.logFile);
            this.myMessageQueue.setLogOption(1);
            this.myMessageQueue.logQueue();
            this.myTftpaDataProductInfo.close();
        } else {
            this.noTftpaProductInfo = true;
            if (this.myTrace) {
                System.out.println("(UserData.loadFromOOCS) ERROR: myTftpaDataProductInfo.create failed");
            }
            object = new Object[]{this.tftpadataDatFile, "tftpacc.ctl"};
            tcpError = new TcpError(MessageFormat.format(this.myBundle.getString("WARNING_FILE_NOT_FOUND"), (Object[])object), 1);
            this.myErrorListController.addError(tcpError);
            oOCMessageQueue = OOCMessageQueue.getStaticMsgQ();
            oOCMessageQueue.replaceLogFile(0);
            oOCMessageQueue.setLogFileName(this.logFile);
            oOCMessageQueue.setLogOption(2);
            oOCMessageQueue.logQueue();
            if (this.myTrace) {
                System.out.println("(UserData.loadFromOOCS) Messages were logged to filename " + this.logFile);
            }
        }
        this.kwSrvrusr = this.myUserDataConfiguration.get("srvrusr", "");
        while (this.kwSrvrusr != null) {
            object = new UserEntry();
            ((UserEntry)object).loadUserEntryFromOOCS(this.kwSrvrusr);
            this.addUserEntry((UserEntry)object);
            this.kwSrvrusr = this.kwSrvrusr.nextOf();
        }
        this.kwRshUser = this.myRshDataConfiguration.get("rsh_user", "");
        while (this.kwRshUser != null) {
            object = new RshEntry();
            ((RshEntry)object).loadRshAccessFromOOCS(this.kwRshUser);
            this.addRshEntry((RshEntry)object);
            this.kwRshUser = this.kwRshUser.nextOf();
        }
        this.kwTftpDir = this.myTftpDataConfiguration.get("tftp_access", "");
        while (this.kwTftpDir != null) {
            object = new TftpEntry();
            ((TftpEntry)object).loadTftpAccessFromOOCS(this.kwTftpDir);
            this.addTftpEntry((TftpEntry)object);
            this.kwTftpDir = this.kwTftpDir.nextOf();
        }
        this.kwTftpaAuthorization = this.myTftpaDataConfiguration.get("tftpa_entry", "");
        while (this.kwTftpaAuthorization != null) {
            object = new TftpaEntry();
            ((TftpaEntry)object).loadTftpaAccessFromOOCS(this.kwTftpaAuthorization);
            this.addTftpaEntry((TftpaEntry)object);
            this.kwTftpaAuthorization = this.kwTftpaAuthorization.nextOf();
        }
        this.myUsersOnDiskCnt = this.getUserEntryListSize();
    }

    public void saveToOOCS() {
        int n;
        Object object;
        Object[] objectArray;
        int n2;
        if (this.myTrace) {
            System.out.println("in saveToOOCS() of UserData");
        }
        int n3 = this.myUserDataConfiguration.numberOf("srvrusr");
        if (this.myTrace) {
            System.out.println("(UserData.saveToOOCS) numberOf(srvrusr) = " + n3);
        }
        if (n3 > 0) {
            this.kwSrvrusr = this.myUserDataConfiguration.get("srvrusr", "");
            n2 = 1;
            while (n2 <= n3) {
                this.myUserDataConfiguration.deleteKeyword("srvrusr", "");
                this.kwSrvrusr = this.kwSrvrusr.nextOf();
                ++n2;
            }
        }
        n2 = this.getUserEntryListSize();
        if (this.myTrace) {
            System.out.println("(UserData.saveToOOCS) numberOfEntries = " + n2);
        }
        this.kwSrvrusr = this.myUserDataConfiguration.get("srvrusr", "");
        int n4 = 0;
        while (n4 < n2) {
            UserEntry userEntry = this.getUserEntry(n4);
            userEntry.saveUserEntryToOOCS(this.myUserDataConfiguration, this.kwSrvrusr);
            ++n4;
        }
        int n5 = this.myUserDataConfiguration.write(this.userdataConfigFile, 1, 1, 1, 0, userdataParseRules);
        if (n5 == 1) {
            if (this.myTrace) {
                System.out.println("(UserData.saveToOOCS) Successful write to tcpnbk.lst");
            }
        } else {
            if (this.myTrace) {
                System.out.println("(UserData.saveToOOCS) Unsuccessful write to tcpnbk.lst");
            }
            objectArray = new Object[]{"tcpnbk.lst"};
            object = new TcpError(MessageFormat.format(this.myBundle.getString("WARNING_FILE_NOT_WRITTEN"), objectArray), 1);
            this.myErrorListController.addError((TcpError)object);
            this.myMessageQueue.logQueue();
        }
        n3 = this.myRshDataConfiguration.numberOf("rsh_user");
        if (this.myTrace) {
            System.out.println("(UserData.saveToOOCS) original rhosts entries = " + n3);
        }
        if (n3 > 0) {
            this.kwRshUser = this.myRshDataConfiguration.get("rsh_user", "");
            int n6 = 1;
            while (n6 <= n3) {
                this.kwRshUser.deleteKeyword("hostname", "");
                this.kwRshUser.deleteKeyword("domain", "");
                this.kwRshUser.deleteKeyword("username", "");
                this.kwRshUser = this.kwRshUser.nextOf();
                ++n6;
            }
        }
        n3 = this.getRshEntryListSize();
        if (this.myTrace) {
            System.out.println("(UserData.saveToOOCS) total RSHEntries = " + n3);
        }
        if (n3 > 0) {
            int n7 = 0;
            while (n7 < n3) {
                this.kwRshUser = this.myRshDataConfiguration.createKeyword(0, "rsh_user", "", null);
                object = this.getRshEntry(n7);
                ((RshEntry)object).saveRshAccessToOOCS(this.kwRshUser);
                ++n7;
            }
        }
        if ((n5 = this.myRshDataConfiguration.write(this.rshdataConfigFile, 1, 1, 1, 0, rshdataParseRules)) == 1) {
            if (this.myTrace) {
                System.out.println("(UserData.saveToOOCS) Successful write to rhosts");
            }
        } else {
            if (this.myTrace) {
                System.out.println("(UserData.saveToOOCS) Unsuccessful write to rhosts");
            }
            objectArray = new Object[]{"rhosts"};
            object = new TcpError(MessageFormat.format(this.myBundle.getString("WARNING_FILE_NOT_WRITTEN"), objectArray), 1);
            this.myErrorListController.addError((TcpError)object);
            this.myMessageQueue.logQueue();
        }
        n3 = this.myTftpDataConfiguration.numberOf("tftp_access");
        if (this.myTrace) {
            System.out.println("(UserData.saveToOOCS) original TFTPAUTH entries= " + n3);
        }
        if (n3 > 0) {
            objectArray = new OOCKeyword[n3];
            this.kwTftpDir = this.myTftpDataConfiguration.get("tftp_access", "");
            objectArray[0] = this.kwTftpDir;
            int n8 = 1;
            while (n8 <= n3) {
                this.kwTftpDir = this.kwTftpDir.nextOf();
                if (this.kwTftpDir != null) {
                    objectArray[n8] = this.kwTftpDir;
                }
                ++n8;
            }
            n = 0;
            while (n < n3) {
                this.myTftpDataConfiguration.deleteThisKeyword((OOCKeyword)objectArray[n]);
                ++n;
            }
        }
        n3 = this.getTftpEntryListSize();
        if (this.myTrace) {
            System.out.println("(UserData.saveToOOCS) total TFTPEntries = " + n3);
        }
        if (n3 > 0) {
            int n9 = 0;
            while (n9 < n3) {
                this.kwTftpDir = this.myTftpDataConfiguration.createKeyword(0, "tftp_access", "", null);
                TftpEntry tftpEntry = this.getTftpEntry(n9);
                tftpEntry.saveTftpAccessToOOCS(this.kwTftpDir);
                ++n9;
            }
        }
        if ((n5 = this.myTftpDataConfiguration.write(this.tftpdataConfigFile, 1, 1, 1, 0, tftpdataParseRules)) == 1) {
            if (this.myTrace) {
                System.out.println("(TftpData.saveToOOCS) Successful write to tftpauth");
            }
        } else {
            if (this.myTrace) {
                System.out.println("(TftpData.saveToOOCS) Unsuccessful write to tftpauth");
            }
            Object[] objectArray2 = new Object[]{"tftpauth"};
            TcpError tcpError = new TcpError(MessageFormat.format(this.myBundle.getString("WARNING_FILE_NOT_WRITTEN"), objectArray2), 1);
            this.myErrorListController.addError(tcpError);
            this.myMessageQueue.logQueue();
        }
        n3 = this.myTftpaDataConfiguration.numberOf("tftpa_entry");
        if (this.myTrace) {
            System.out.println("(UserData.saveToOOCS) original TFTPA entries= " + n3);
        }
        if (n3 > 0) {
            OOCKeyword[] oOCKeywordArray = new OOCKeyword[n3];
            oOCKeywordArray[0] = this.kwTftpaAuthorization = this.myTftpaDataConfiguration.get("tftpa_entry", "");
            int n10 = 1;
            while (n10 <= n3) {
                this.kwTftpaAuthorization = this.kwTftpaAuthorization.nextOf();
                if (this.kwTftpaAuthorization != null) {
                    oOCKeywordArray[n10] = this.kwTftpaAuthorization;
                }
                ++n10;
            }
            n = 0;
            while (n < n3) {
                this.myTftpaDataConfiguration.deleteThisKeyword(oOCKeywordArray[n]);
                ++n;
            }
        }
        n3 = this.getTftpaEntryListSize();
        if (this.myTrace) {
            System.out.println("(UserData.saveToOOCS) total TFTPA = " + n3);
        }
        if (n3 > 0) {
            int n11 = 0;
            while (n11 < n3) {
                this.kwTftpaAuthorization = this.myTftpaDataConfiguration.createKeyword(0, "tftpa_entry", "", null);
                TftpaEntry tftpaEntry = this.getTftpaEntry(n11);
                tftpaEntry.saveTftpaAccessToOOCS(this.kwTftpaAuthorization);
                ++n11;
            }
        }
        if ((n5 = this.myTftpaDataConfiguration.write(this.tftpadataConfigFile, 1, 1, 1, 0, tftpadataParseRules)) == 1) {
            if (this.myTrace) {
                System.out.println("(TftpaData.saveToOOCS) Successful write to tftpaauthorization");
            }
        } else {
            if (this.myTrace) {
                System.out.println("(TftpaData.saveToOOCS) Unsuccessful write to tftpaauthorization");
            }
            Object[] objectArray3 = new Object[]{"tftpaauthorization"};
            TcpError tcpError = new TcpError(MessageFormat.format(this.myBundle.getString("WARNING_FILE_NOT_WRITTEN"), objectArray3), 1);
            this.myErrorListController.addError(tcpError);
            this.myMessageQueue.logQueue();
        }
        this.closeOOCS();
    }

    public void closeOOCS() {
        if (this.already_closed) {
            return;
        }
        this.already_closed = true;
        int n = this.myUserDataConfiguration.close();
        int n2 = this.myRshDataConfiguration.close();
        int n3 = this.myTftpDataConfiguration.close();
        int n4 = this.myTftpaDataConfiguration.close();
        if (this.myTrace) {
            System.out.println("(UserData.closeOOCS) rc from myUserDataConfiguration.close = " + n);
            System.out.println("(UserData.closeOOCS) rc from myRshDataConfiguration.close = " + n2);
            System.out.println("(UserData.closeOOCS) rc from myTftpDataConfiguration.close = " + n3);
            System.out.println("(UserData.closeOOCS) rc from myTftpaDataConfiguration.close = " + n4);
        }
    }

    public void fromString(ParsedVector parsedVector) {
        UserDataStreamProcessor userDataStreamProcessor = new UserDataStreamProcessor(this);
        String[] stringArray = parsedVector.getKeys();
        int n = stringArray.length - 1;
        while (n >= 0) {
            Integer n2;
            ParsedObject parsedObject;
            String string;
            if (stringArray[n].equals(myUserEntryListCnt_tag)) {
                if (this.myTrace) {
                    System.out.println("tag = myUserEntryListCnt_tag");
                }
                if ((string = (String)(parsedObject = parsedVector.getElement(myUserEntryListCnt_tag)).getValue()) != null) {
                    n2 = Integer.valueOf(string);
                    this.myUserEntryListCnt = n2;
                    if (this.myUserEntryListCnt > 0) {
                        if (this.myTrace) {
                            System.out.println("myUserEntryListCnt = " + this.myUserEntryListCnt);
                        }
                        this.myUserEntryList = new Vector(this.myUserEntryListCnt);
                    } else {
                        this.myUserEntryList = new Vector();
                    }
                } else {
                    this.myUserEntryList = new Vector();
                }
            } else if (stringArray[n].equals(myUsersOnDiskCnt_tag)) {
                parsedObject = parsedVector.getElement(myUsersOnDiskCnt_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myUsersOnDiskCnt = n2;
                }
            } else if (stringArray[n].equals(myLastUserLoadedCnt_tag)) {
                parsedObject = parsedVector.getElement(myLastUserLoadedCnt_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myLastUserLoadedCnt = n2;
                }
            } else if (stringArray[n].equals(myUserEntrySelectedIndex_tag)) {
                parsedObject = parsedVector.getElement(myUserEntrySelectedIndex_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myUserEntrySelectedIndex = n2;
                }
            } else if (stringArray[n].equals(myRshEntryListCnt_tag)) {
                if (this.myTrace) {
                    System.out.println("tag = myRshEntryListCnt_tag");
                }
                if ((string = (String)(parsedObject = parsedVector.getElement(myRshEntryListCnt_tag)).getValue()) != null) {
                    n2 = Integer.valueOf(string);
                    this.myRshEntryListCnt = n2;
                    if (this.myRshEntryListCnt > 0) {
                        if (this.myTrace) {
                            System.out.println("myRshEntryListCnt = " + this.myRshEntryListCnt);
                        }
                        this.myRshEntryList = new Vector(this.myRshEntryListCnt);
                    } else {
                        this.myRshEntryList = new Vector();
                    }
                } else {
                    this.myRshEntryList = new Vector();
                }
            } else if (stringArray[n].equals(myTftpEntryListCnt_tag)) {
                if (this.myTrace) {
                    System.out.println("tag = myTftpEntryListCnt_tag");
                }
                if ((string = (String)(parsedObject = parsedVector.getElement(myTftpEntryListCnt_tag)).getValue()) != null) {
                    n2 = Integer.valueOf(string);
                    this.myTftpEntryListCnt = n2;
                    if (this.myTftpEntryListCnt > 0) {
                        if (this.myTrace) {
                            System.out.println("myTftpEntryListCnt = " + this.myTftpEntryListCnt);
                        }
                        this.myTftpEntryList = new Vector(this.myTftpEntryListCnt);
                    } else {
                        this.myTftpEntryList = new Vector();
                    }
                } else {
                    this.myTftpEntryList = new Vector();
                }
            } else if (stringArray[n].equals(myTftpaEntryListCnt_tag)) {
                if (this.myTrace) {
                    System.out.println("tag = myTftpaEntryListCnt_tag");
                }
                if ((string = (String)(parsedObject = parsedVector.getElement(myTftpaEntryListCnt_tag)).getValue()) != null) {
                    n2 = Integer.valueOf(string);
                    this.myTftpaEntryListCnt = n2;
                    if (this.myTftpaEntryListCnt > 0) {
                        if (this.myTrace) {
                            System.out.println("myTftpaEntryListCnt = " + this.myTftpaEntryListCnt);
                        }
                        this.myTftpaEntryList = new Vector(this.myTftpaEntryListCnt);
                    } else {
                        this.myTftpaEntryList = new Vector();
                    }
                } else {
                    this.myTftpaEntryList = new Vector();
                }
            } else if (stringArray[n].equals(myUserEntrySelectedIndex_tag)) {
                parsedObject = parsedVector.getElement(myUserEntrySelectedIndex_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myUserEntrySelectedIndex = n2;
                }
            } else if (stringArray[n].equals(myTftpEntrySelectedIndex_tag)) {
                parsedObject = parsedVector.getElement(myTftpEntrySelectedIndex_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myTftpEntrySelectedIndex = n2;
                }
            } else if (stringArray[n].equals(myRshEntrySelectedIndex_tag)) {
                parsedObject = parsedVector.getElement(myRshEntrySelectedIndex_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myRshEntrySelectedIndex = n2;
                }
            } else if (stringArray[n].equals(myTftpaEntrySelectedIndex_tag)) {
                parsedObject = parsedVector.getElement(myTftpaEntrySelectedIndex_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myTftpaEntrySelectedIndex = n2;
                }
            } else {
                userDataStreamProcessor.processTag(stringArray[n], (String)parsedVector.get(n).getValue());
            }
            --n;
        }
        this.initCommit();
    }

    public String toString() {
        if (this.myTrace) {
            System.out.println("in UserData.toString()");
        }
        StringBuffer stringBuffer = new StringBuffer(BUD_tag);
        stringBuffer.append("," + myUsersOnDiskCnt_tag + "=" + this.myUsersOnDiskCnt);
        stringBuffer.append("," + myLastUserLoadedCnt_tag + "=" + this.myLastUserLoadedCnt);
        int n = this.myUserEntryList.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            UserEntry userEntry = (UserEntry)this.myUserEntryList.elementAt(n2);
            stringBuffer.append("," + userEntry.toString());
            --n2;
        }
        stringBuffer.append("," + myUserEntryListCnt_tag + "=" + String.valueOf(this.myUserEntryList.size()));
        stringBuffer.append("," + myUserEntrySelectedIndex_tag + "=" + this.myUserEntrySelectedIndex);
        n = this.myTftpEntryList.size();
        int n3 = n - 1;
        while (n3 >= 0) {
            TftpEntry tftpEntry = (TftpEntry)this.myTftpEntryList.elementAt(n3);
            stringBuffer.append("," + tftpEntry.toString());
            --n3;
        }
        stringBuffer.append("," + myTftpEntryListCnt_tag + "=" + String.valueOf(this.myTftpEntryList.size()));
        stringBuffer.append("," + myTftpEntrySelectedIndex_tag + "=" + this.myTftpEntrySelectedIndex);
        n = this.myRshEntryList.size();
        int n4 = n - 1;
        while (n4 >= 0) {
            RshEntry rshEntry = (RshEntry)this.myRshEntryList.elementAt(n4);
            stringBuffer.append("," + rshEntry.toString());
            --n4;
        }
        stringBuffer.append("," + myRshEntryListCnt_tag + "=" + String.valueOf(this.myRshEntryList.size()));
        stringBuffer.append("," + myRshEntrySelectedIndex_tag + "=" + this.myRshEntrySelectedIndex);
        n = this.myTftpaEntryList.size();
        int n5 = n - 1;
        while (n5 >= 0) {
            TftpaEntry tftpaEntry = (TftpaEntry)this.myTftpaEntryList.elementAt(n5);
            stringBuffer.append("," + tftpaEntry.toString());
            --n5;
        }
        stringBuffer.append("," + myTftpaEntryListCnt_tag + "=" + String.valueOf(this.myTftpaEntryList.size()));
        stringBuffer.append("," + myTftpaEntrySelectedIndex_tag + "=" + this.myTftpaEntrySelectedIndex);
        stringBuffer.append("," + EUD_tag);
        return stringBuffer.toString();
    }
}

