/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.dtco.dbcsutil;

import COM.ibm.raleigh.tcp.tcpcfg2.dtco.dbcsutil.TopBottomChecker;
import java.util.Locale;

public class BreakPointFinder {
    private String teststring;
    private int current;
    private boolean[] mask;
    private TopBottomChecker topbottomchecker;
    public static int DONE = -1;

    public BreakPointFinder(String string) {
        this(string, Locale.getDefault());
    }

    public BreakPointFinder(String string, Locale locale) {
        this.teststring = string;
        this.current = 0;
        this.topbottomchecker = new TopBottomChecker(locale);
        this.checkMask();
    }

    private void checkMask() {
        this.mask = new boolean[this.teststring.length()];
        this.mask[0] = true;
        int n = 0;
        while (n < this.teststring.length() - 1) {
            this.mask[n + 1] = this.topbottomchecker.isBottomOkay(this.teststring.charAt(n));
            ++n;
        }
        this.mask[this.teststring.length() - 1] = true;
    }

    public int getCurrent() {
        return this.current;
    }

    public int next() {
        if (this.current >= this.teststring.length() - 1) {
            return DONE;
        }
        int n = ++this.current;
        while (!this.topbottomchecker.isTopOkay(this.teststring.charAt(n)) || !this.mask[n]) {
            if (n >= this.teststring.length() - 1) {
                return DONE;
            }
            ++n;
        }
        this.current = n;
        return this.current;
    }

    public int previous() {
        if (this.current <= 0) {
            return DONE;
        }
        int n = this.current - 1;
        while (!this.topbottomchecker.isTopOkay(this.teststring.charAt(n)) || !this.mask[n]) {
            if (n <= 0) {
                return DONE;
            }
            --n;
        }
        this.current = n;
        return this.current;
    }

    public void setText(String string) {
        this.teststring = string;
        this.current = 0;
    }

    public void setBegin() {
        this.current = 0;
    }
}

