/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.animationCanvas;

import com.ibm.eNetwork.onDemand.common.Timer;
import com.ibm.eNetwork.onDemand.common.TimerListener;
import com.ibm.eNetwork.onDemand.common.gui.common.DBCanvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.util.Enumeration;
import java.util.Vector;

public class AnimationCanvas
extends DBCanvas
implements TimerListener {
    protected static Timer timer = null;
    protected int iSpeed = 500;
    protected int iStep = 1;
    protected int iImageIndex;
    protected int iMaxIndex;
    protected Image image;
    protected Vector vImages;
    protected static Rectangle area = null;
    protected Dimension dimSize;
    protected boolean bPainting = false;

    public AnimationCanvas(int iSpeed, int iStep, Vector vImages) {
        this.cfcColor.addColor(SystemColor.control, 0);
        this.setAttribs();
        this.iSpeed = iSpeed;
        this.iStep = iStep;
        this.vImages = vImages;
        this.iMaxIndex = vImages.size() - 1;
        this.dimSize = this.calcPreferredSize();
        timer = new Timer(iSpeed);
    }

    protected Dimension calcPreferredSize() {
        int iWidth = 0;
        int iMaxWidth = 0;
        int iHeight = 0;
        int iMaxHeight = 0;
        Image imageTemp = null;
        Enumeration enumeration = this.vImages.elements();
        while (enumeration.hasMoreElements()) {
            imageTemp = (Image)enumeration.nextElement();
            iWidth = imageTemp.getWidth(this);
            iHeight = imageTemp.getHeight(this);
            iMaxWidth = Math.max(iWidth, iMaxWidth);
            iMaxHeight = Math.max(iHeight, iMaxHeight);
        }
        area = new Rectangle(0, 0, iMaxWidth, iMaxHeight);
        return new Dimension(iMaxWidth, iMaxHeight);
    }

    public Dimension getPreferredSize() {
        return this.dimSize;
    }

    public void start() {
        timer.addTimerListener(this);
    }

    public void stop() {
        timer.removeTimerListener(this);
    }

    public synchronized void draw(Graphics g) {
        this.image = (Image)this.vImages.elementAt(this.iImageIndex);
        if (this.image == null) {
            return;
        }
        this.ifcImage.addImage(this.image, 0);
        this.ifcImage.drawImage(0, g, area);
    }

    public void timerFired() {
        if (this.bPainting) {
            return;
        }
        this.bPainting = true;
        this.incrementImagePosition(this.iStep);
        Graphics g = this.getGraphics();
        this.update(g);
        this.bPainting = false;
    }

    protected void incrementImagePosition(int iNum) {
        this.iImageIndex += iNum;
        if (this.iImageIndex > this.iMaxIndex) {
            this.iImageIndex = this.iImageIndex - this.iMaxIndex - 1;
        }
    }
}

