/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.attribView;

import com.ibm.eNetwork.onDemand.common.gui.attribView.AttribFieldEvent;
import com.ibm.eNetwork.onDemand.common.gui.attribView.AttribFieldEventListener;
import com.ibm.eNetwork.onDemand.common.gui.attribView.AttribView;
import com.ibm.eNetwork.onDemand.common.gui.attribView.AttribViewCanvas;
import com.ibm.eNetwork.onDemand.common.gui.attribView.AttribViewNode;
import com.ibm.eNetwork.onDemand.common.gui.common.Controler;
import com.ibm.eNetwork.onDemand.common.gui.common.ExtendedCanvas;
import com.ibm.eNetwork.onDemand.common.gui.treeView.TreeView;
import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;

public class AttribViewControler
extends Controler
implements MouseListener,
MouseMotionListener {
    protected AttribViewCanvas avc;
    protected AttribView av;
    protected Cursor curEast = new Cursor(11);
    protected Cursor curNorm;
    protected TreeView tv;

    public AttribViewControler(TreeView tv, AttribView av) {
        this.av = av;
        this.tv = tv;
    }

    public void register(ExtendedCanvas ec) {
        try {
            AttribViewCanvas avc = (AttribViewCanvas)ec;
            avc.addMouseListener(this);
            avc.addMouseMotionListener(this);
            this.avc = avc;
        }
        catch (Exception exception) {}
    }

    public void unregister(ExtendedCanvas ec) {
        try {
            AttribViewCanvas avc = (AttribViewCanvas)ec;
            avc.removeMouseListener(this);
            avc.removeMouseMotionListener(this);
            this.avc = null;
        }
        catch (Exception exception) {}
    }

    public void mouseReleased(MouseEvent e) {
        try {
            boolean bSignalChange = this.avc.setDragging(false);
            if (bSignalChange) {
                this.av.fieldSizesChanged();
            }
        }
        catch (Exception exception) {}
    }

    public void mouseEntered(MouseEvent e) {
        try {
            if (this.curNorm == null) {
                this.curNorm = this.avc.getCursor();
            }
        }
        catch (Exception exception) {}
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        try {
            Point p = e.getPoint();
            if (this.avc.isDraggablepoint(p)) {
                this.avc.setDragging(true);
            } else {
                AttribViewNode node = (AttribViewNode)this.avc.findOnMouseDown(p.x, p.y);
                if (node != null && node.getSortable()) {
                    int iConstraints = this.avc.selectNode(node);
                    this.createEvent(node, iConstraints);
                }
            }
        }
        catch (Exception exception) {}
    }

    public void mouseClicked(MouseEvent e) {
    }

    protected boolean isMyEvent(AWTEvent e) {
        try {
            if (e instanceof AttribFieldEvent) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    protected boolean sendEvent(AWTEvent e) {
        try {
            Enumeration enumeration = this.hListeners.elements();
            AttribFieldEvent afe = (AttribFieldEvent)e;
            while (enumeration.hasMoreElements()) {
                AttribFieldEventListener listener = (AttribFieldEventListener)enumeration.nextElement();
                afe.sendEvent(listener);
            }
        }
        catch (Exception exception) {}
        return true;
    }

    protected boolean createEvent(AttribViewNode avn, int iConstraints) {
        try {
            AttribFieldEvent afe = new AttribFieldEvent(this.tv, avn, iConstraints, 828);
            this.postEvent(afe);
        }
        catch (Exception exception) {}
        return true;
    }

    public void mouseDragged(MouseEvent e) {
        try {
            Point p = e.getPoint();
            this.avc.drag(p);
        }
        catch (Exception exception) {}
    }

    public void mouseMoved(MouseEvent e) {
        try {
            Point p = e.getPoint();
            boolean bShowDrawCursor = this.avc.isDraggablepoint(p);
            if (bShowDrawCursor) {
                this.avc.setCursor(this.curEast);
            } else {
                this.avc.setCursor(this.curNorm);
            }
        }
        catch (Exception exception) {}
    }
}

