/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.common;

import com.ibm.eNetwork.onDemand.common.gui.common.ColorsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.FontsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.ImagesForCanvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;

public abstract class DrawableObject {
    protected ColorsForCanvas cfcColor = new ColorsForCanvas();
    protected FontsForCanvas ffcFont = new FontsForCanvas();
    protected ImagesForCanvas ifcImage = new ImagesForCanvas();
    protected String sText = "";
    protected boolean bFocus = false;
    Dimension dimSize = new Dimension(1, 1);
    Point pStart = new Point(0, 0);
    Shape shape;
    public static final int TEXT = 1;
    public static final int GRAPHIC = 2;

    public abstract void setSelected(boolean var1);

    public abstract boolean getSelected();

    public abstract void draw(Graphics var1, Rectangle var2);

    public abstract void committ();

    public DrawableObject(ColorsForCanvas cfcColor, FontsForCanvas ffcFont, ImagesForCanvas ifcImage) {
        this.updateAttribs(cfcColor, ffcFont, ifcImage);
    }

    public int getHeight() {
        return this.dimSize.height;
    }

    public int getWidth() {
        return this.dimSize.width;
    }

    public Dimension getSize() {
        return this.dimSize;
    }

    public void setSize(Dimension dimSize) {
        if (dimSize != null) {
            this.setSize(dimSize.width, dimSize.height);
        }
    }

    public void setSize(int width, int height) {
        Dimension dimSize = new Dimension(width, height);
        if (dimSize != null) {
            this.dimSize = dimSize;
        }
    }

    public Point getLocation() {
        return this.pStart;
    }

    public void setLocation(Point pStart) {
        this.pStart = pStart;
    }

    public void setText(String sText) {
        if (sText == null) {
            return;
        }
        this.sText = sText;
    }

    public String getText() {
        return this.sText;
    }

    public ColorsForCanvas getColors() {
        return this.cfcColor;
    }

    public FontsForCanvas getFonts() {
        return this.ffcFont;
    }

    public ImagesForCanvas getImage() {
        return this.ifcImage;
    }

    public String toString() {
        return this.sText;
    }

    public void updateAttribs(ColorsForCanvas cfcColor, FontsForCanvas ffcFont, ImagesForCanvas ifcImage) {
        this.setColors(cfcColor);
        this.setFonts(ffcFont);
        this.setImage(ifcImage);
    }

    public void setColors(ColorsForCanvas cfcColor) {
        this.cfcColor = cfcColor == null ? new ColorsForCanvas() : cfcColor;
    }

    public void setFonts(FontsForCanvas ffcFont) {
        this.ffcFont = ffcFont == null ? new FontsForCanvas() : ffcFont;
    }

    public void setImage(ImagesForCanvas ifcImage) {
        this.ifcImage = ifcImage == null ? new ImagesForCanvas() : ifcImage;
    }

    public void setFocus(boolean bFocus) {
        this.bFocus = bFocus;
    }

    public boolean hasFocus() {
        return this.bFocus;
    }
}

