/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.common;

import com.ibm.eNetwork.onDemand.common.gui.common.StorageObject;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;

public class FontsForCanvas
extends StorageObject {
    protected static Font fontNormal = new Font("Helvetica", 0, 12);
    protected static Font fontSelected = new Font("Helvetica", 1, 12);
    protected static Toolkit t = Toolkit.getDefaultToolkit();
    protected FontMetrics fm;
    protected Font font;
    protected static final int NO_FONT = -1;
    protected static final int FONTSFORCANVAS_FIRST = 0;
    protected static final int FONTSFORCANVAS_LAST = 1;
    public static final int SELECTED = 0;
    public static final int NORMAL = 0;

    public FontsForCanvas() {
    }

    public boolean isValidRange(int iNum) {
        return iNum >= 0 && iNum <= 1;
    }

    public FontsForCanvas(Font fontNormal, Font fontSelected) {
        this.addFont(fontNormal, 0);
        this.addFont(fontSelected, 0);
    }

    public void setDefaults() {
        this.addFont(fontNormal, 0);
        this.addFont(fontSelected, 0);
    }

    public void addFont(Font font, int id) {
        this.add(font, id);
    }

    public Font getFont(int id) {
        return (Font)this.get(id);
    }

    public void removeFont(int id) {
        this.remove(id);
    }

    public static int getFontDescent(Font font) {
        try {
            Toolkit t = Toolkit.getDefaultToolkit();
            FontMetrics fm = t.getFontMetrics(font);
            return fm.getDescent();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getFontDescent(int id) {
        try {
            this.font = this.getFont(id);
            this.fm = t.getFontMetrics(this.font);
            return this.fm.getDescent();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getFontHeight(int id) {
        try {
            this.font = this.getFont(id);
            this.fm = t.getFontMetrics(this.font);
            return this.fm.getHeight() + this.fm.getDescent();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static int getFontHeight(Font font) {
        try {
            FontMetrics fm = null;
            fm = t.getFontMetrics(font);
            return fm.getHeight() + fm.getDescent();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getFontMaxWidth(int id) {
        try {
            this.font = this.getFont(id);
            this.fm = t.getFontMetrics(this.font);
            return this.fm.charWidth('W');
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getFontAverageWidth(int id) {
        try {
            this.font = this.getFont(id);
            this.fm = t.getFontMetrics(this.font);
            return this.fm.charWidth('V');
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getStringWidth(String sString, int id) {
        try {
            this.font = this.getFont(id);
            this.fm = t.getFontMetrics(this.font);
            return this.fm.stringWidth(sString);
        }
        catch (Exception exception) {
            return 0;
        }
    }
}

