/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.common;

import com.ibm.eNetwork.onDemand.common.gui.common.ImageCanvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;

public class ImageTextCanvas
extends ImageCanvas {
    Image img;
    String text;
    static final String copyright = "Copyright IBM Corporation 1997. All rights reserved.\nU.S. Government Users Restricted Rights - Use, duplication\nor disclosure restricted by GSA ADP Schedule Contract with\nIBM Corp.\n\n";

    public ImageTextCanvas(String text) {
        this.text = text;
    }

    public ImageTextCanvas(Image img) {
        this.img = img;
    }

    public ImageTextCanvas(Image img, String text) {
        this.img = img;
        this.text = text;
    }

    public void setText(String text) {
        this.text = text;
        this.invalidate();
    }

    public void draw(Graphics g) {
        Dimension d = this.getSize();
        if (this.img != null) {
            g.drawImage(this.img, 0, 0, d.width, d.height, 0, 0, this.img.getWidth(null), this.img.getHeight(null), Color.lightGray, this);
            if (this.text != null) {
                g.setColor(new Color(0xFFFFFF));
                g.setFont(new Font(this.getFont().getName(), 0, 24));
                FontMetrics fontMetrics = g.getFontMetrics();
                int x = (d.width - fontMetrics.stringWidth(this.text)) / 2;
                int y = (d.height + fontMetrics.getAscent()) / 2;
                g.drawString(this.text, x, y);
            }
        } else {
            g.clearRect(0, 0, d.width, d.height);
        }
    }
}

