/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.common;

import com.ibm.eNetwork.onDemand.common.gui.common.ColorsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.DrawableNode;
import com.ibm.eNetwork.onDemand.common.gui.common.FontsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.ImagesForCanvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class LeftAlignedNode
extends DrawableNode {
    protected int iVertSpace;
    protected int iHorzSpace;

    public LeftAlignedNode(String sText, DrawableNode dnPrev, ColorsForCanvas cfcColor, FontsForCanvas ffcFont, ImagesForCanvas ifcImage) {
        super(sText, dnPrev, cfcColor, ffcFont, ifcImage);
        this.calcSpaces();
    }

    public LeftAlignedNode(String sText, ColorsForCanvas cfcColor, FontsForCanvas ffcFont, ImagesForCanvas ifcImage) {
        super(sText, cfcColor, ffcFont, ifcImage);
        this.calcSpaces();
    }

    protected void calcSpaces() {
        this.iHorzSpace = this.ffcFont.getFontMaxWidth(0);
        this.iVertSpace = this.ffcFont.getFontDescent(0) / 2;
    }

    public void draw(Graphics g, Rectangle area) {
        Point pStart = new Point(area.x, area.y);
        this.setLocation(pStart);
        this.paintBackground(g, area);
        this.drawGraphic(g, area);
        this.drawCaption(this.cfcColor.getColor(1), g, area);
    }

    protected void drawGraphic(Graphics g, Rectangle area) {
        int iCenterOffset = this.getOffsetForCenter(2);
        Rectangle newArea = null;
        int iImageId = 0;
        newArea = new Rectangle(this.getGraphicX(area), this.getGraphicY(area, iCenterOffset), 0, 0);
        if (this.getSelected()) {
            iImageId = 1;
        }
        this.ifcImage.drawImage(iImageId, g, newArea);
    }

    protected int getGraphicX(Rectangle area) {
        return area.x + this.iHorzSpace;
    }

    protected int getGraphicY(Rectangle area, int iCenterOffset) {
        return iCenterOffset + area.y;
    }

    protected void drawCaption(Color cColor, Graphics g, Rectangle area) {
        int iCenterOffset = this.getOffsetForCenter(1);
        int iFontType = 0;
        if (this.getSelected()) {
            iFontType = 0;
        }
        g.setFont(this.ffcFont.getFont(iFontType));
        g.setColor(cColor);
        String sText = this.computeText(iFontType);
        g.drawString(sText, this.getCaptionX(area), this.getCaptionY(area, iCenterOffset));
    }

    protected String computeText(int iFontType) {
        try {
            int iWidth = this.getWidth() - this.ifcImage.getImageWidth(iFontType) - 2 * this.iHorzSpace;
            String sTemp = this.getText();
            int iStringWidth = this.ffcFont.getStringWidth(sTemp, iFontType);
            if (iStringWidth < iWidth) {
                return sTemp;
            }
            int iDiff = iStringWidth - iWidth;
            int iCharSize = this.ffcFont.getFontAverageWidth(iFontType);
            int iDecChars = (int)((float)iDiff / (float)iCharSize + 3.0f);
            int iSize = sTemp.length() - iDecChars - 1;
            if (iSize < 1) {
                return "";
            }
            return String.valueOf(sTemp.substring(0, iSize)) + "...";
        }
        catch (Exception exception) {
            return "";
        }
    }

    protected int getCaptionX(Rectangle area) {
        return this.iHorzSpace * 4 / 3 + area.x + this.ifcImage.getImageWidth(0);
    }

    protected int getCaptionY(Rectangle area, int iCenterOffset) {
        return area.y + this.getHeight() - this.iVertSpace - iCenterOffset - this.ffcFont.getFontDescent(0);
    }

    protected int getOffsetForCenter(int iItem) {
        int iDiffTI = 0;
        int iDiffTH = 0;
        int iDiffIH = 0;
        int iTextHeight = 0;
        int iImageHeight = 0;
        int iOffset = 0;
        int iFontType = 0;
        int iImageType = 0;
        if (this.getSelected()) {
            iFontType = 0;
            iImageType = 1;
        }
        iImageHeight = this.ifcImage.getImageHeight(iImageType);
        iTextHeight = this.ffcFont.getFontHeight(iFontType);
        iDiffTI = iTextHeight - iImageHeight;
        iDiffTH = this.getHeight() - iTextHeight;
        iDiffIH = this.getHeight() - iImageHeight;
        if (iItem == 1) {
            if (iDiffTI < 0) {
                iOffset = (iDiffTI *= -1) / 2;
                return iOffset += iDiffIH / 2;
            }
            return iOffset += iDiffTH / 2;
        }
        if (iItem == 2) {
            if (iDiffTI > 0) {
                iOffset = iDiffTI / 2;
                return iOffset += iDiffTH / 4 * 3;
            }
            return iOffset += iDiffIH / 2;
        }
        System.out.println("Error: unknow offset type");
        return 0;
    }

    public void committ() {
        this.calcSpaces();
        int width = 0;
        int height = 0;
        int iImageHeight = this.ifcImage.getImageHeight(0);
        int iTextHeight = this.ffcFont.getFontHeight(0);
        width += this.iHorzSpace * 5 / 2;
        width += this.ifcImage.getImageWidth(0);
        height = iImageHeight > iTextHeight ? (height += iImageHeight) : (height += iTextHeight);
        this.setSize(width += this.ffcFont.getStringWidth(this.getText(), 0), height += 2 * this.iVertSpace);
    }
}

