/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.common;

import com.ibm.eNetwork.onDemand.common.gui.common.ColorsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.FontsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.ImagesForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.NodeAttribute;
import com.ibm.eNetwork.onDemand.common.gui.common.StorageObject;
import java.awt.PopupMenu;
import java.util.Enumeration;

public abstract class Scheme
extends StorageObject {
    public static final int NO_PLACEMENT = -1;
    public static final int ALL_POSITIONS = -2;
    protected static final int COLORS = 1;
    protected static final int FONTS = 2;
    protected static final int IMAGES = 3;
    protected static final int POPUPMENUS = 4;
    protected static final int CONTROLERS = 5;

    public abstract boolean isValidPosition(int var1);

    public void setDefaults() {
    }

    public boolean isValidRange(int iNum) {
        return this.isValidPosition(iNum);
    }

    protected NodeAttribute getNode(int iPlacement) {
        return (NodeAttribute)this.get(iPlacement);
    }

    protected void addNode(NodeAttribute node, int iPlacement) {
        this.add(node, iPlacement);
    }

    protected void removeNode(int iPlacement) {
        this.remove(iPlacement);
    }

    public void setPopupMenu(int iPlacement, PopupMenu pop) {
        try {
            if (iPlacement == -2) {
                this.setAll(pop, 4);
                return;
            }
            NodeAttribute node = this.getNode(iPlacement);
            node.setPopupMenu(pop);
        }
        catch (Exception exception) {}
    }

    public PopupMenu getPopupMenu(int iPlacement) {
        try {
            NodeAttribute node = this.getNode(iPlacement);
            PopupMenu pop = node.getPopupMenu();
            return pop;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setColors(int iPlacement, ColorsForCanvas color) {
        try {
            if (iPlacement == -2) {
                this.setAll(color, 1);
                return;
            }
            NodeAttribute node = this.getNode(iPlacement);
            node.setColors(color);
        }
        catch (Exception exception) {}
    }

    public ColorsForCanvas getColors(int iPlacement) {
        try {
            NodeAttribute node = this.getNode(iPlacement);
            ColorsForCanvas color = node.getColors();
            return color;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setFonts(int iPlacement, FontsForCanvas font) {
        try {
            if (iPlacement == -2) {
                this.setAll(font, 2);
                return;
            }
            NodeAttribute node = this.getNode(iPlacement);
            node.setFonts(font);
        }
        catch (Exception exception) {}
    }

    public FontsForCanvas getFonts(int iPlacement) {
        try {
            NodeAttribute node = this.getNode(iPlacement);
            FontsForCanvas font = node.getFonts();
            return font;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setImages(int iPlacement, ImagesForCanvas images) {
        try {
            if (iPlacement == -2) {
                this.setAll(images, 3);
                return;
            }
            NodeAttribute node = this.getNode(iPlacement);
            node.setImage(images);
        }
        catch (Exception exception) {}
    }

    public ImagesForCanvas getImages(int iPlacement) {
        try {
            NodeAttribute node = this.getNode(iPlacement);
            ImagesForCanvas images = node.getImage();
            return images;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void registerPosition(int iPosition) {
        try {
            if (!this.isValidPosition(iPosition)) {
                System.err.println("Invalid position registered");
                return;
            }
            NodeAttribute node = new NodeAttribute();
            this.addNode(node, iPosition);
        }
        catch (Exception exception) {}
    }

    public void unregisterPosition(int iPosition) {
        try {
            if (!this.isValidPosition(iPosition)) {
                System.err.println("Invalid position unregistered");
                return;
            }
            this.removeNode(iPosition);
        }
        catch (Exception exception) {}
    }

    public String toString() {
        return "[unnamed scheme]";
    }

    protected void setAll(Object obj, int iType) {
        try {
            Enumeration enumeration = this.elements();
            NodeAttribute node = null;
            while (enumeration.hasMoreElements()) {
                node = (NodeAttribute)enumeration.nextElement();
                switch (iType) {
                    case 1: {
                        node.setColors((ColorsForCanvas)obj);
                        break;
                    }
                    case 2: {
                        node.setFonts((FontsForCanvas)obj);
                        break;
                    }
                    case 3: {
                        node.setImage((ImagesForCanvas)obj);
                        break;
                    }
                    case 4: {
                        node.setPopupMenu((PopupMenu)obj);
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public void dispose() {
        Enumeration enumeration = this.elements();
        Object o = null;
        while (enumeration.hasMoreElements()) {
            o = enumeration.nextElement();
            if (!(o instanceof StorageObject)) continue;
            ((StorageObject)o).dispose();
        }
        super.dispose();
    }
}

