/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.imageButton;

import com.ibm.eNetwork.onDemand.common.Timer;
import com.ibm.eNetwork.onDemand.common.gui.imageButton.ImageButtonPainter;
import com.ibm.eNetwork.onDemand.common.gui.tooltip.Tooltip;
import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class ImageButton
extends Canvas
implements MouseListener,
FocusListener,
KeyListener,
ComponentListener {
    public static final int IMAGE_AND_TEXT = 1;
    public static final int IMAGE_ONLY = 2;
    public static final int TEXT_ONLY = 3;
    public static final boolean FLAT_BUTTON = true;
    public static final boolean REGULAR_BUTTON = false;
    public static final boolean TRANSPARENT = true;
    public static final boolean OPAQUE = false;
    public static final int TEXT_SOUTH = 10;
    public static final int TEXT_NORTH = 11;
    public static final int TEXT_WEST = 12;
    public static final int TEXT_EAST = 13;
    protected static Timer timer = null;
    protected ImageButtonPainter ibpPainter;
    protected Tooltip tooltip;
    private Image imageOffscreen;
    private Graphics gOffscreen;
    protected int iViewMode;
    protected boolean boolFlatButton = true;
    protected boolean boolTransparent = false;
    protected String sLabel;
    protected String sTipString;
    protected String sActionCommand;
    protected boolean boolHighlighted = false;
    protected boolean boolSelected = false;
    protected boolean boolInitialized = false;
    protected boolean boolFocused = false;
    protected boolean boolEnabled = true;
    protected boolean boolMousePressed = false;
    protected boolean boolToolTipEnabled = true;
    protected boolean boolFocusTraversable = false;
    protected boolean boolFocusBoxEnabled = true;
    protected boolean boolTooltipWindowToFront = true;
    protected Dimension dMinSize;
    protected ActionListener actionListener;
    int iTooltipDelay;

    public ImageButton() {
        this(null, null, null, "", true, 3, 10, false, true);
    }

    public ImageButton(Image baseImage, Image highlightedImage, Image disabledImage, String sLabel, boolean boolFlatButton, int iViewMode, int iTextOrientation, boolean boolTransparent, boolean boolFocusTraversable) {
        this.setBackground(SystemColor.control);
        this.ibpPainter = new ImageButtonPainter(this, baseImage, highlightedImage, disabledImage, sLabel, boolFlatButton, iViewMode, iTextOrientation, boolTransparent);
        this.sLabel = sLabel;
        this.sActionCommand = sLabel;
        this.sTipString = sLabel;
        this.iViewMode = iViewMode;
        this.boolFocusTraversable = boolFocusTraversable;
        if (timer == null) {
            timer = new Timer(500);
        }
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.addComponentListener(this);
        this.iTooltipDelay = -1;
    }

    public ImageButton(Image baseImage, String sLabel) {
        this(baseImage, null, null, sLabel, true, 1, 10, false, true);
    }

    public ImageButton(String sLabel) {
        this(null, null, null, sLabel, true, 3, 10, false, true);
    }

    public ImageButton(Image image) {
        this(image, null, null, "", true, 2, 10, false, true);
    }

    public void setSettings(Image baseImage, Image highlightedImage, Image disabledImage, String sLabel, boolean boolFlatButton, int iViewMode, int iTextOrientation, boolean boolTransparent, boolean boolFocusTraversable) {
        this.ibpPainter.setSettings(this, baseImage, highlightedImage, disabledImage, sLabel, boolFlatButton, iViewMode, iTextOrientation, boolTransparent);
        this.sLabel = sLabel;
        this.sActionCommand = sLabel;
        this.sTipString = sLabel;
        this.iViewMode = iViewMode;
        this.boolFocusTraversable = boolFocusTraversable;
        this.boolInitialized = false;
    }

    public void setImages(Image baseImage, Image highlightedImage, Image disabledImage) {
        this.ibpPainter.setImages(baseImage, highlightedImage, disabledImage);
        this.boolInitialized = false;
        this.invalidate();
        this.repaint();
    }

    public Dimension commit() {
        if (this.dMinSize == null) {
            this.dMinSize = this.ibpPainter.computeMinimumSize();
        }
        this.setSize(this.dMinSize);
        return this.dMinSize;
    }

    public void setTextOrientation(int iTextOrientation) {
        this.ibpPainter.setTextOrientation(iTextOrientation);
        this.boolInitialized = false;
        this.invalidate();
        this.repaint();
    }

    public int getTextOrientation() {
        return this.ibpPainter.getTextOrientation();
    }

    protected void init() {
        Dimension dSize = this.getSize();
        Object g = null;
        if (this.tooltip == null) {
            this.tooltip = new Tooltip(this.getTopLevelParent(this), this.sTipString);
            this.tooltip.setEnabled(this.boolToolTipEnabled);
            timer.addTimerListener(this.tooltip);
            if (this.iTooltipDelay >= 0) {
                this.tooltip.setDelay(this.iTooltipDelay);
            }
            this.tooltip.setToFront(this.boolTooltipWindowToFront);
        }
        if (this.imageOffscreen != null) {
            this.imageOffscreen.flush();
            if (this.gOffscreen != null) {
                this.gOffscreen.dispose();
            }
            System.gc();
        }
        this.imageOffscreen = this.createImage(dSize.width, dSize.height);
        if (this.imageOffscreen != null) {
            this.gOffscreen = this.imageOffscreen.getGraphics();
        } else {
            System.err.println("Couldn't make base offscreen image");
        }
        this.boolInitialized = true;
    }

    public void setViewMode(int iViewMode) {
        this.iViewMode = iViewMode;
        this.ibpPainter.setViewMode(iViewMode);
        this.boolInitialized = false;
        this.invalidate();
    }

    public int getViewMode() {
        return this.ibpPainter.getViewMode();
    }

    public void setButtonType(boolean boolFlatButton) {
        this.boolFlatButton = boolFlatButton;
        this.ibpPainter.setButtonType(boolFlatButton);
        this.boolInitialized = false;
        this.invalidate();
    }

    public void setTooltipDelay(int halfSecs) {
        if (this.tooltip != null) {
            this.tooltip.setDelay(halfSecs);
        }
        this.iTooltipDelay = halfSecs;
    }

    public void setTooltipWindowToFront(boolean boolTooltipWindowToFront) {
        if (this.tooltip != null) {
            this.tooltip.setToFront(boolTooltipWindowToFront);
        }
        this.boolTooltipWindowToFront = boolTooltipWindowToFront;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        Dimension dSize = this.getSize();
        if (this.gOffscreen == null || !this.boolInitialized) {
            this.init();
        }
        if (this.isEnabled()) {
            if (this.boolSelected) {
                this.ibpPainter.drawSelectedButton(this.gOffscreen, dSize);
            } else if (this.boolHighlighted) {
                this.ibpPainter.drawHighlightedButton(this.gOffscreen, dSize);
            } else {
                this.ibpPainter.drawNormalButton(this.gOffscreen, dSize);
            }
        } else {
            this.ibpPainter.drawDisabledButton(this.gOffscreen, dSize);
        }
        if (this.boolFocused && this.boolFocusBoxEnabled) {
            this.gOffscreen.setColor(SystemColor.controlText);
            this.gOffscreen.drawRect(3, 3, dSize.width - 7, dSize.height - 7);
        }
        g.drawImage(this.imageOffscreen, 0, 0, this);
    }

    public void setFocusBoxEnabled(boolean enabled) {
        this.boolFocusBoxEnabled = enabled;
    }

    public String getTipString() {
        return this.sTipString;
    }

    public void setTipString(String newstring) {
        this.sTipString = newstring;
        if (this.tooltip != null) {
            this.tooltip.setLabel(newstring);
        }
    }

    public void setTipEnabled(boolean isEnabled) {
        this.boolToolTipEnabled = isEnabled;
        if (this.tooltip != null) {
            this.tooltip.setEnabled(isEnabled);
        }
    }

    public boolean getTipEnabled(boolean isEnabled) {
        return this.boolToolTipEnabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.boolEnabled == enabled) {
            return;
        }
        this.boolEnabled = enabled;
        super.setEnabled(enabled);
        if (this.boolInitialized) {
            this.repaint();
        }
    }

    public boolean isEnabled() {
        return this.boolEnabled;
    }

    public Dimension getMinimumSize() {
        if (this.dMinSize == null) {
            this.dMinSize = this.ibpPainter.computeMinimumSize();
        }
        return this.dMinSize;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    public void setLabel(String newlabel) {
        this.sLabel = newlabel;
        this.ibpPainter.setLabel(newlabel);
        if (this.boolInitialized) {
            this.init();
            this.repaint();
        }
    }

    public String getLabel() {
        return this.ibpPainter.getLabel();
    }

    public void setActionCommand(String newActionCommand) {
        this.sActionCommand = newActionCommand;
    }

    public String getActionCommand() {
        return this.sActionCommand;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (this.isEnabled() && this.contains(e.getX(), e.getY())) {
            this.boolMousePressed = true;
            this.requestFocus();
            this.boolSelected = true;
            if (this.tooltip != null) {
                this.tooltip.setFastDisplay(false);
                this.tooltip.hideTooltip();
            }
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.isEnabled()) {
            this.boolSelected = false;
            if (this.contains(e.getX(), e.getY()) && this.boolMousePressed && this.actionListener != null) {
                this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.sActionCommand));
            }
            this.repaint();
        }
        this.boolMousePressed = false;
    }

    public void mouseEntered(MouseEvent e) {
        if (!this.sTipString.equals("")) {
            Point pScreenLoc = this.getLocationOnScreen();
            int x = pScreenLoc.x + this.getSize().width / 2;
            int y = pScreenLoc.y + this.getSize().height + 2;
            if (this.tooltip == null) {
                this.tooltip = new Tooltip(this.getTopLevelParent(this), this.sTipString);
                this.tooltip.setEnabled(this.boolToolTipEnabled);
                timer.addTimerListener(this.tooltip);
            }
            this.tooltip.showAfterDelay(x, y);
        }
        if (this.isEnabled()) {
            if (this.boolMousePressed) {
                this.boolSelected = true;
            } else {
                this.boolHighlighted = true;
            }
            this.repaint();
        }
    }

    public void mouseExited(MouseEvent e) {
        if (this.tooltip != null) {
            this.tooltip.hideTooltip();
        }
        if (this.isEnabled()) {
            this.boolHighlighted = false;
            this.boolSelected = false;
            this.repaint();
        }
    }

    public void componentResized(ComponentEvent e) {
        if (this.boolInitialized) {
            this.init();
            this.repaint();
        }
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (this.isEnabled() && (e.getKeyCode() == 10 || e.getKeyCode() == 32)) {
            this.requestFocus();
            this.boolSelected = true;
            if (this.tooltip != null) {
                this.tooltip.hideTooltip();
                this.tooltip.setFastDisplay(false);
            }
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.sActionCommand));
            }
            this.repaint();
        }
    }

    public void keyReleased(KeyEvent e) {
        if (this.isEnabled() && (e.getKeyCode() == 10 || e.getKeyCode() == 32)) {
            this.boolSelected = false;
            this.repaint();
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void focusGained(FocusEvent e) {
        this.boolFocused = true;
        this.repaint();
    }

    public void focusLost(FocusEvent e) {
        if (this.tooltip != null) {
            this.tooltip.hideTooltip();
        }
        this.boolFocused = false;
        this.boolHighlighted = false;
        this.boolSelected = false;
        this.repaint();
    }

    public boolean isFocusTraversable() {
        return this.boolFocusTraversable;
    }

    private Frame getTopLevelParent(Component comp) {
        Component c = comp;
        while (c.getParent() != null) {
            c = c.getParent();
        }
        if (c instanceof Frame) {
            return (Frame)c;
        }
        return null;
    }

    public Insets getInsets() {
        return this.ibpPainter.getInsets();
    }

    public void finalize() throws Throwable {
        if (this.imageOffscreen != null) {
            this.imageOffscreen.flush();
        }
        if (this.gOffscreen != null) {
            this.gOffscreen.dispose();
        }
        this.ibpPainter.finalize();
        if (this.tooltip != null) {
            timer.removeTimerListener(this.tooltip);
            this.tooltip.finalize();
        }
        System.gc();
        super.finalize();
    }
}

