/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.imageButton;

import com.ibm.eNetwork.onDemand.common.gui.imageButton.SetDarkColorsToColor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.image.FilteredImageSource;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;

public class ImageButtonPainter {
    public static final int IMAGE_AND_TEXT = 1;
    public static final int IMAGE_ONLY = 2;
    public static final int TEXT_ONLY = 3;
    public static final int TEXT_SOUTH = 10;
    public static final int TEXT_NORTH = 11;
    public static final int TEXT_WEST = 12;
    public static final int TEXT_EAST = 13;
    protected static final int NORMAL = 21;
    protected static final int HIGHLIGHTED = 22;
    protected static final int DISABLED = 23;
    protected static final int SELECTED = 24;
    Component component;
    Image normalImage;
    Image highlightedImage;
    Image disabledImage;
    String sLabel;
    boolean boolFlatButton = false;
    boolean boolTransparent = false;
    boolean boolCreatedDisabledImage = false;
    int iViewMode;
    int iTextOrientation;

    public ImageButtonPainter(Component component, Image normalImage, Image highlightedImage, Image disabledImage, String sLabel, boolean boolFlatButton, int iViewMode, int iTextOrientation, boolean boolTransparent) {
        this.component = component;
        this.normalImage = normalImage;
        this.highlightedImage = highlightedImage != null ? highlightedImage : normalImage;
        this.disabledImage = disabledImage != null ? disabledImage : this.createDisabledImage(normalImage);
        this.boolFlatButton = boolFlatButton;
        this.sLabel = sLabel;
        this.iViewMode = iViewMode;
        this.iTextOrientation = iTextOrientation;
    }

    public void setSettings(Component component, Image normalImage, Image highlightedImage, Image disabledImage, String sLabel, boolean boolFlatButton, int iViewMode, int iTextOrientation, boolean boolTransparent) {
        this.component = component;
        this.normalImage = normalImage;
        this.highlightedImage = highlightedImage != null ? highlightedImage : normalImage;
        this.disabledImage = disabledImage != null ? disabledImage : this.createDisabledImage(normalImage);
        this.boolFlatButton = boolFlatButton;
        this.sLabel = sLabel;
        this.iViewMode = iViewMode;
        this.iTextOrientation = iTextOrientation;
    }

    public void setImages(Image normalImage, Image highlightedImage, Image disabledImage) {
        this.normalImage = normalImage;
        this.highlightedImage = highlightedImage != null ? highlightedImage : normalImage;
        this.disabledImage = disabledImage != null ? disabledImage : this.createDisabledImage(normalImage);
    }

    public void setButtonType(boolean boolFlatButton) {
        this.boolFlatButton = boolFlatButton;
    }

    public void setLabel(String newlabel) {
        this.sLabel = newlabel;
    }

    public String getLabel() {
        return this.sLabel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void drawNormalButton(Graphics g, Dimension dSize) {
        if (!this.boolTransparent) {
            g.setColor(SystemColor.control);
            g.fillRect(0, 0, dSize.width, dSize.height);
        }
        if (!this.boolFlatButton) {
            g.setColor(SystemColor.controlHighlight);
            g.drawLine(0, 0, 0, dSize.height - 1);
            g.drawLine(0, 0, dSize.width - 1, 0);
            g.setColor(SystemColor.controlLtHighlight);
            g.drawLine(1, 1, dSize.width - 2, 1);
            g.drawLine(1, 1, 1, dSize.height - 2);
            g.setColor(SystemColor.controlDkShadow);
            g.drawLine(0, dSize.height - 1, dSize.width - 1, dSize.height - 1);
            g.drawLine(dSize.width - 1, 0, dSize.width - 1, dSize.height - 1);
            g.setColor(SystemColor.controlShadow);
            g.drawLine(1, dSize.height - 2, dSize.width - 2, dSize.height - 2);
            g.drawLine(dSize.width - 2, dSize.height - 2, dSize.width - 2, 1);
        }
        switch (this.iViewMode) {
            case 1: {
                switch (this.iTextOrientation) {
                    case 12: {
                        this.drawWestTextImageButton(g, new Rectangle(4, 4, dSize.width - 8, dSize.height - 8), this.normalImage, this.sLabel, 21);
                        return;
                    }
                    case 13: {
                        this.drawEastTextImageButton(g, new Rectangle(4, 4, dSize.width - 8, dSize.height - 8), this.normalImage, this.sLabel, 21);
                        return;
                    }
                    case 10: {
                        this.drawSouthTextImageButton(g, new Rectangle(4, 4, dSize.width - 8, dSize.height - 8), this.normalImage, this.sLabel, 21);
                        return;
                    }
                    case 11: {
                        this.drawNorthTextImageButton(g, new Rectangle(4, 4, dSize.width - 8, dSize.height - 8), this.normalImage, this.sLabel, 21);
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            case 3: {
                FontMetrics fontMetrics = g.getFontMetrics();
                int iStringWidth = fontMetrics.stringWidth(this.sLabel);
                g.setColor(SystemColor.controlText);
                int y = (dSize.height + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
                int x = (dSize.width - iStringWidth) / 2;
                g.drawString(this.sLabel, x, y);
                return;
            }
            case 2: {
                int x = (dSize.width - 10 - this.normalImage.getWidth(this.component)) / 2 + 5;
                int y = (dSize.height - 10 - this.normalImage.getHeight(this.component)) / 2 + 5;
                g.drawImage(this.normalImage, x, y, this.component);
                return;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void drawHighlightedButton(Graphics g, Dimension dSize) {
        if (!this.boolTransparent) {
            g.setColor(SystemColor.control);
            g.fillRect(0, 0, dSize.width, dSize.height);
        }
        g.setColor(SystemColor.controlHighlight);
        g.drawLine(0, 0, 0, dSize.height - 1);
        g.drawLine(0, 0, dSize.width - 1, 0);
        g.setColor(SystemColor.controlLtHighlight);
        g.drawLine(1, 1, dSize.width - 2, 1);
        g.drawLine(1, 1, 1, dSize.height - 2);
        g.setColor(SystemColor.controlDkShadow);
        g.drawLine(0, dSize.height - 1, dSize.width - 1, dSize.height - 1);
        g.drawLine(dSize.width - 1, 0, dSize.width - 1, dSize.height - 1);
        g.setColor(SystemColor.controlShadow);
        g.drawLine(1, dSize.height - 2, dSize.width - 2, dSize.height - 2);
        g.drawLine(dSize.width - 2, dSize.height - 2, dSize.width - 2, 1);
        switch (this.iViewMode) {
            case 1: {
                switch (this.iTextOrientation) {
                    case 12: {
                        this.drawWestTextImageButton(g, new Rectangle(4, 4, dSize.width - 8, dSize.height - 8), this.highlightedImage, this.sLabel, 22);
                        return;
                    }
                    case 13: {
                        this.drawEastTextImageButton(g, new Rectangle(4, 4, dSize.width - 8, dSize.height - 8), this.highlightedImage, this.sLabel, 22);
                        return;
                    }
                    case 10: {
                        this.drawSouthTextImageButton(g, new Rectangle(4, 4, dSize.width - 8, dSize.height - 8), this.highlightedImage, this.sLabel, 22);
                        return;
                    }
                    case 11: {
                        this.drawNorthTextImageButton(g, new Rectangle(4, 4, dSize.width - 8, dSize.height - 8), this.highlightedImage, this.sLabel, 22);
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            case 3: {
                FontMetrics fontMetrics = g.getFontMetrics();
                int iStringWidth = fontMetrics.stringWidth(this.sLabel);
                g.setColor(SystemColor.controlText);
                int y = (dSize.height + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
                int x = (dSize.width - iStringWidth) / 2;
                g.drawString(this.sLabel, x, y);
                return;
            }
            case 2: {
                int x = (dSize.width - 10 - this.highlightedImage.getWidth(this.component)) / 2 + 5;
                int y = (dSize.height - 10 - this.highlightedImage.getHeight(this.component)) / 2 + 5;
                g.drawImage(this.highlightedImage, x, y, this.component);
                return;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void drawDisabledButton(Graphics g, Dimension dSize) {
        if (!this.boolTransparent) {
            g.setColor(SystemColor.control);
            g.fillRect(0, 0, dSize.width, dSize.height);
        }
        if (!this.boolFlatButton) {
            g.setColor(SystemColor.controlHighlight);
            g.drawLine(0, 0, 0, dSize.height - 1);
            g.drawLine(0, 0, dSize.width - 1, 0);
            g.setColor(SystemColor.controlLtHighlight);
            g.drawLine(1, 1, dSize.width - 2, 1);
            g.drawLine(1, 1, 1, dSize.height - 2);
            g.setColor(SystemColor.controlDkShadow);
            g.drawLine(0, dSize.height - 1, dSize.width - 1, dSize.height - 1);
            g.drawLine(dSize.width - 1, 0, dSize.width - 1, dSize.height - 1);
            g.setColor(SystemColor.controlShadow);
            g.drawLine(1, dSize.height - 2, dSize.width - 2, dSize.height - 2);
            g.drawLine(dSize.width - 2, dSize.height - 2, dSize.width - 2, 1);
        }
        switch (this.iViewMode) {
            case 1: {
                switch (this.iTextOrientation) {
                    case 12: {
                        this.drawWestTextImageButton(g, new Rectangle(4, 4, dSize.width - 8, dSize.height - 8), this.disabledImage, this.sLabel, 23);
                        return;
                    }
                    case 13: {
                        this.drawEastTextImageButton(g, new Rectangle(4, 4, dSize.width - 8, dSize.height - 8), this.disabledImage, this.sLabel, 23);
                        return;
                    }
                    case 10: {
                        this.drawSouthTextImageButton(g, new Rectangle(4, 4, dSize.width - 8, dSize.height - 8), this.disabledImage, this.sLabel, 23);
                        return;
                    }
                    case 11: {
                        this.drawNorthTextImageButton(g, new Rectangle(4, 4, dSize.width - 8, dSize.height - 8), this.disabledImage, this.sLabel, 23);
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            case 3: {
                FontMetrics fontMetrics = g.getFontMetrics();
                int iStringWidth = fontMetrics.stringWidth(this.sLabel);
                int y = (dSize.height + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
                int x = (dSize.width - iStringWidth) / 2;
                g.setColor(SystemColor.controlLtHighlight);
                g.drawString(this.sLabel, x + 1, y + 1);
                g.setColor(SystemColor.controlShadow);
                g.drawString(this.sLabel, x, y);
                return;
            }
            case 2: {
                int x = (dSize.width - 10 - this.disabledImage.getWidth(this.component)) / 2 + 5;
                int y = (dSize.height - 10 - this.disabledImage.getHeight(this.component)) / 2 + 5;
                g.drawImage(this.disabledImage, x, y, this.component);
                return;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void drawSelectedButton(Graphics g, Dimension dSize) {
        if (!this.boolTransparent) {
            g.setColor(SystemColor.control);
            g.fillRect(0, 0, dSize.width, dSize.height);
        }
        g.setColor(SystemColor.controlShadow);
        g.drawLine(0, 0, 0, dSize.height - 1);
        g.drawLine(0, 0, dSize.width - 1, 0);
        g.setColor(SystemColor.controlDkShadow);
        g.drawLine(1, 1, dSize.width - 2, 1);
        g.drawLine(1, 1, 1, dSize.height - 2);
        g.setColor(SystemColor.controlHighlight);
        g.drawLine(0, dSize.height - 1, dSize.width - 1, dSize.height - 1);
        g.drawLine(dSize.width - 1, dSize.height - 1, dSize.width - 1, 0);
        g.setColor(SystemColor.controlLtHighlight);
        g.drawLine(1, dSize.height - 2, dSize.width - 2, dSize.height - 2);
        g.drawLine(dSize.width - 2, dSize.height - 2, dSize.width - 2, 1);
        switch (this.iViewMode) {
            case 1: {
                switch (this.iTextOrientation) {
                    case 12: {
                        this.drawWestTextImageButton(g, new Rectangle(4, 4, dSize.width - 8, dSize.height - 8), this.highlightedImage, this.sLabel, 24);
                        return;
                    }
                    case 13: {
                        this.drawEastTextImageButton(g, new Rectangle(4, 4, dSize.width - 8, dSize.height - 8), this.highlightedImage, this.sLabel, 24);
                        return;
                    }
                    case 10: {
                        this.drawSouthTextImageButton(g, new Rectangle(4, 4, dSize.width - 8, dSize.height - 8), this.highlightedImage, this.sLabel, 24);
                        return;
                    }
                    case 11: {
                        this.drawNorthTextImageButton(g, new Rectangle(4, 4, dSize.width - 8, dSize.height - 8), this.highlightedImage, this.sLabel, 24);
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            case 3: {
                FontMetrics fontMetrics = g.getFontMetrics();
                int iStringWidth = fontMetrics.stringWidth(this.sLabel);
                g.setColor(SystemColor.controlText);
                int y = (dSize.height + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
                int x = (dSize.width - iStringWidth) / 2;
                g.drawString(this.sLabel, x + 2, y + 2);
                return;
            }
            case 2: {
                int x = (dSize.width - 10 - this.highlightedImage.getWidth(this.component)) / 2 + 4;
                int y = (dSize.height - 10 - this.highlightedImage.getHeight(this.component)) / 2 + 4;
                g.drawImage(this.highlightedImage, x + 2, y + 2, this.component);
                return;
            }
        }
    }

    public int getTextOrientation() {
        return this.iTextOrientation;
    }

    public void setTextOrientation(int newTextOrientation) {
        this.iTextOrientation = newTextOrientation;
    }

    public int getViewMode() {
        return this.iViewMode;
    }

    public void setViewMode(int newViewMode) {
        this.iViewMode = newViewMode;
    }

    private Image createDisabledImage(Image normalImage) {
        if (normalImage == null) {
            return null;
        }
        Image newImage = null;
        try {
            PixelGrabber pg = new PixelGrabber(normalImage, 0, 0, -1, -1, true);
            if (pg.grabPixels()) {
                int h = pg.getHeight();
                int w = pg.getWidth();
                int[] pixels = (int[])pg.getPixels();
                int y = 0;
                while (y < h) {
                    int x = 0;
                    while (x < w) {
                        if ((x + y) % 2 == 0) {
                            pixels[w * y + x] = pixels[w * y + x] & 0xFFFFFF;
                        }
                        ++x;
                    }
                    ++y;
                }
                newImage = this.component.createImage(new MemoryImageSource(w, h, pixels, 0, w));
                MediaTracker mt = new MediaTracker(this.component);
                mt.addImage(newImage, 1);
                mt.waitForID(1);
            }
        }
        catch (Exception e) {
            System.err.println("ImageButtonPainter.createDisabledImage: " + e);
            newImage = null;
        }
        this.boolCreatedDisabledImage = true;
        return newImage;
    }

    public static Image createEmbossedDisabledImage(Component component, Image normalImage) {
        if (normalImage == null) {
            return null;
        }
        Image newImage = null;
        try {
            newImage = component.createImage(normalImage.getWidth(component) + 1, normalImage.getHeight(component) + 1);
            Graphics gNewImage = newImage.getGraphics();
            gNewImage.setColor(SystemColor.control);
            gNewImage.fillRect(0, 0, normalImage.getWidth(component) + 1, normalImage.getHeight(component) + 1);
            Image darkImage = component.createImage(new FilteredImageSource(normalImage.getSource(), new SetDarkColorsToColor(SystemColor.controlShadow)));
            Image lightImage = component.createImage(new FilteredImageSource(normalImage.getSource(), new SetDarkColorsToColor(SystemColor.controlLtHighlight)));
            MediaTracker mt = new MediaTracker(component);
            mt.addImage(darkImage, 1);
            mt.addImage(lightImage, 1);
            mt.waitForID(1);
            gNewImage.drawImage(lightImage, 1, 1, component);
            gNewImage.drawImage(darkImage, 0, 0, component);
        }
        catch (Exception e) {
            System.err.println("ImageButtonPainter.createEmbossedDisabledImage() : " + e);
            newImage = null;
        }
        return newImage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Dimension computeMinimumSize() {
        Dimension dMinSize = new Dimension(0, 0);
        switch (this.iViewMode) {
            case 1: {
                switch (this.iTextOrientation) {
                    case 10: 
                    case 11: {
                        FontMetrics fontMetrics = this.component.getFontMetrics(this.component.getFont());
                        dMinSize.width = Math.max(fontMetrics.stringWidth(this.sLabel), this.normalImage.getWidth(this.component)) + 14;
                        dMinSize.height = this.normalImage.getHeight(this.component) + fontMetrics.getHeight() + 16;
                        return dMinSize;
                    }
                    case 12: 
                    case 13: {
                        FontMetrics fontMetrics = this.component.getFontMetrics(this.component.getFont());
                        dMinSize.width = fontMetrics.stringWidth(this.sLabel) + this.normalImage.getWidth(this.component) + 2 + 14;
                        dMinSize.height = Math.max(this.normalImage.getHeight(this.component), fontMetrics.getHeight()) + 16;
                        return dMinSize;
                    }
                    default: {
                        return dMinSize;
                    }
                }
            }
            case 3: {
                FontMetrics fontMetrics = this.component.getFontMetrics(this.component.getFont());
                dMinSize.width = fontMetrics.stringWidth(this.sLabel) + 12;
                dMinSize.height = fontMetrics.getHeight() + 8;
                return dMinSize;
            }
            case 2: {
                dMinSize.width = this.normalImage.getWidth(this.component) + 10;
                dMinSize.height = this.normalImage.getHeight(this.component) + 10;
                return dMinSize;
            }
        }
        return dMinSize;
    }

    protected void drawWestTextImageButton(Graphics g, Rectangle rBounds, Image image, String sText, int iStatus) {
        FontMetrics fontMetrics = g.getFontMetrics();
        int iStringWidth = fontMetrics.stringWidth(sText);
        Dimension dTextAndImage = new Dimension();
        dTextAndImage.width = iStringWidth + image.getWidth(this.component) + 2;
        dTextAndImage.height = Math.max(fontMetrics.getHeight(), image.getHeight(this.component));
        int x = rBounds.x + (rBounds.width - dTextAndImage.width) / 2;
        int y = rBounds.y + (rBounds.height + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
        if (iStatus == 24) {
            ++x;
            ++y;
        }
        if (iStatus == 23) {
            g.setColor(SystemColor.controlLtHighlight);
            g.drawString(sText, x + 1, y + 1);
            g.setColor(SystemColor.controlShadow);
            g.drawString(sText, x, y);
        } else {
            g.setColor(SystemColor.controlText);
            g.drawString(sText, x, y);
        }
        x = rBounds.x + (rBounds.width - dTextAndImage.width) / 2 + iStringWidth + 2;
        y = rBounds.y + (rBounds.height - image.getHeight(this.component)) / 2;
        if (iStatus == 24) {
            ++x;
            ++y;
        }
        g.drawImage(image, x, y, this.component);
    }

    protected void drawEastTextImageButton(Graphics g, Rectangle rBounds, Image image, String sText, int iStatus) {
        FontMetrics fontMetrics = g.getFontMetrics();
        int iStringWidth = fontMetrics.stringWidth(sText);
        Dimension dTextAndImage = new Dimension();
        dTextAndImage.width = iStringWidth + image.getWidth(this.component) + 2;
        dTextAndImage.height = Math.max(fontMetrics.getHeight(), image.getHeight(this.component));
        int x = rBounds.x + (rBounds.width - dTextAndImage.width) / 2;
        int y = rBounds.y + (rBounds.height - image.getHeight(this.component)) / 2;
        if (iStatus == 24) {
            ++x;
            ++y;
        }
        g.drawImage(image, x, y, this.component);
        x = rBounds.x + (rBounds.width - dTextAndImage.width) / 2 + image.getWidth(this.component) + 2;
        y = rBounds.y + (rBounds.height + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
        if (iStatus == 24) {
            ++x;
            ++y;
        }
        if (iStatus == 23) {
            g.setColor(SystemColor.controlLtHighlight);
            g.drawString(sText, x + 1, y + 1);
            g.setColor(SystemColor.controlShadow);
            g.drawString(sText, x, y);
        } else {
            g.setColor(SystemColor.controlText);
            g.drawString(sText, x, y);
        }
    }

    protected void drawSouthTextImageButton(Graphics g, Rectangle rBounds, Image image, String sText, int iStatus) {
        FontMetrics fontMetrics = g.getFontMetrics();
        int iStringWidth = fontMetrics.stringWidth(this.sLabel);
        int x = rBounds.x + rBounds.width / 2 - iStringWidth / 2;
        int y = rBounds.y + rBounds.height - 4;
        if (iStatus == 24) {
            ++x;
            ++y;
        }
        if (iStatus == 23) {
            g.setColor(SystemColor.controlLtHighlight);
            g.drawString(sText, x + 1, y + 1);
            g.setColor(SystemColor.controlShadow);
            g.drawString(sText, x, y);
        } else {
            g.setColor(SystemColor.controlText);
            g.drawString(sText, x, y);
        }
        x = rBounds.x + rBounds.width / 2 - image.getWidth(this.component) / 2;
        y = rBounds.y + (rBounds.height - fontMetrics.getHeight()) / 2 - image.getHeight(this.component) / 2;
        if (iStatus == 24) {
            ++x;
            ++y;
        }
        g.drawImage(image, x, y, this.component);
    }

    protected void drawNorthTextImageButton(Graphics g, Rectangle rBounds, Image image, String sText, int iStatus) {
        FontMetrics fontMetrics = g.getFontMetrics();
        int iStringWidth = fontMetrics.stringWidth(this.sLabel);
        int x = rBounds.x + rBounds.width / 2 - iStringWidth / 2;
        int y = rBounds.y + fontMetrics.getAscent();
        if (iStatus == 24) {
            ++x;
            ++y;
        }
        if (iStatus == 23) {
            g.setColor(SystemColor.controlLtHighlight);
            g.drawString(sText, x + 1, y + 1);
            g.setColor(SystemColor.controlShadow);
            g.drawString(sText, x, y);
        } else {
            g.setColor(SystemColor.controlText);
            g.drawString(sText, x, y);
        }
        x = rBounds.x + rBounds.width / 2 - image.getWidth(this.component) / 2;
        y = rBounds.y + fontMetrics.getHeight() + 2 + (rBounds.height - (rBounds.y + fontMetrics.getHeight() + 2)) / 2 - image.getHeight(this.component) / 2;
        if (iStatus == 24) {
            ++x;
            ++y;
        }
        g.drawImage(image, x, y, this.component);
    }

    public Insets getInsets() {
        return new Insets(5, 5, 5, 5);
    }

    public void finalize() {
        if (this.boolCreatedDisabledImage) {
            this.disabledImage.flush();
        }
    }
}

