/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.jvcScrollbar;

import com.ibm.eNetwork.onDemand.common.gui.common.Controler;
import com.ibm.eNetwork.onDemand.common.gui.common.ExtendedCanvas;
import com.ibm.eNetwork.onDemand.common.gui.imageButton.ImageButton;
import com.ibm.eNetwork.onDemand.common.gui.jvcScrollbar.JVCAdjustmentEvent;
import com.ibm.eNetwork.onDemand.common.gui.jvcScrollbar.JVCScrollbar;
import com.ibm.eNetwork.onDemand.common.gui.jvcScrollbar.JVCScrollbarCanvas;
import java.awt.AWTEvent;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;

public class JVCScrollbarControler
extends Controler
implements MouseListener,
FocusListener,
ActionListener,
MouseMotionListener {
    protected JVCScrollbar sb;
    protected JVCScrollbarCanvas sbc;
    protected ImageButton bTop;
    protected ImageButton bBottom;

    public JVCScrollbarControler(JVCScrollbar sb) {
        this.sb = sb;
    }

    public void register(ExtendedCanvas ec) {
        try {
            JVCScrollbarCanvas sbc = (JVCScrollbarCanvas)ec;
            sbc.addMouseListener(this);
            sbc.addMouseMotionListener(this);
            sbc.addFocusListener(this);
            this.sbc = sbc;
        }
        catch (Exception exception) {}
    }

    public void unregister(ExtendedCanvas ec) {
        try {
            JVCScrollbarCanvas sbc = (JVCScrollbarCanvas)ec;
            sbc.removeMouseListener(this);
            sbc.removeMouseMotionListener(this);
            sbc.removeFocusListener(this);
            this.sbc = null;
        }
        catch (Exception exception) {}
    }

    public void registerButtons(ImageButton bTop, ImageButton bBottom) {
        try {
            bTop.addActionListener(this);
            bBottom.addActionListener(this);
            this.bTop = bTop;
            this.bBottom = bBottom;
        }
        catch (Exception exception) {}
    }

    public void unregisterButtons(ImageButton bTop, ImageButton bBottom) {
        try {
            bTop.removeActionListener(this);
            bBottom.removeActionListener(this);
            this.bTop = null;
            this.bBottom = null;
        }
        catch (Exception exception) {}
    }

    public void mouseReleased(MouseEvent e) {
        try {
            this.sbc.requestFocus();
            Point p = e.getPoint();
            boolean bSendEvent = this.sbc.dragSlider(p);
            if (bSendEvent) {
                this.createEvent(JVCAdjustmentEvent.LAST_TRACK, this.sbc.getValue());
            }
            this.sbc.setDragging(false);
        }
        catch (Exception exception) {}
    }

    public void mouseEntered(MouseEvent e) {
        try {
            if (this.bAutoFocus) {
                this.sbc.requestFocus();
            }
        }
        catch (Exception exception) {}
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        try {
            Point point = e.getPoint();
            int iPos = this.sbc.getMouseToSliderPos(point);
            switch (iPos) {
                case 2: {
                    this.sbc.setValue(-4);
                    this.createEvent(3, this.sbc.getValue());
                    return;
                }
                case 1: {
                    this.sbc.setValue(-3);
                    this.createEvent(4, this.sbc.getValue());
                    return;
                }
                case 3: {
                    this.sbc.setDragging(true);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }

    protected boolean isMyEvent(AWTEvent e) {
        try {
            if (e instanceof JVCAdjustmentEvent) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    protected boolean sendEvent(AWTEvent e) {
        try {
            Enumeration enumeration = this.hListeners.elements();
            JVCAdjustmentEvent ae = (JVCAdjustmentEvent)e;
            if (enumeration.hasMoreElements()) {
                AdjustmentListener listener = (AdjustmentListener)enumeration.nextElement();
                return ae.sendEvent(listener);
            }
        }
        catch (Exception exception) {}
        return true;
    }

    protected boolean createEvent(int iType, int iValue) {
        try {
            JVCAdjustmentEvent ae = new JVCAdjustmentEvent(this.sb, 0, iType, iValue);
            return this.postEvent(ae);
        }
        catch (Exception exception) {
            return true;
        }
    }

    public void actionPerformed(ActionEvent e) {
        try {
            ImageButton b = (ImageButton)e.getSource();
            if (b == this.bTop) {
                this.sbc.setValue(-2);
                this.createEvent(2, this.sbc.getValue());
            }
            if (b == this.bBottom) {
                this.sbc.setValue(-1);
                this.createEvent(1, this.sbc.getValue());
            }
        }
        catch (Exception exception) {}
    }

    public void mouseDragged(MouseEvent e) {
        try {
            Point p = e.getPoint();
            boolean bSendEvent = this.sbc.dragSlider(p);
            if (bSendEvent) {
                this.createEvent(5, this.sbc.getValue());
            }
        }
        catch (Exception exception) {}
    }

    public void mouseMoved(MouseEvent e) {
    }
}

