/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.jvcScrollbar;

import com.ibm.eNetwork.onDemand.common.gui.imageButton.ImageButton;
import com.ibm.eNetwork.onDemand.common.gui.jvcScrollbar.JVCScrollbarCanvas;
import com.ibm.eNetwork.onDemand.common.gui.jvcScrollbar.orientations;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Hashtable;

public class JVCScrollbarLayout
implements LayoutManager,
orientations {
    protected Hashtable hash = new Hashtable();
    protected int iOrientation = 1;
    public static final String SCROLLBAR_CANVAS = "sbc";
    public static final String TOP_BUTTON = "bTop";
    public static final String BOTTOM_BUTTON = "bBottom";

    public JVCScrollbarLayout(int iOrientation) {
        this.iOrientation = iOrientation;
    }

    public void addLayoutComponent(String name, Component comp) {
        this.hash.put(name, comp);
    }

    public void removeLayoutComponent(Component comp) {
        this.hash.remove(comp);
    }

    public Dimension preferredLayoutSize(Container parent) {
        return parent.getSize();
    }

    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(50, 50);
    }

    public void layoutContainer(Container parent) {
        try {
            Dimension d = parent.getSize();
            ImageButton bOne = (ImageButton)this.hash.get(TOP_BUTTON);
            ImageButton bTwo = (ImageButton)this.hash.get(BOTTOM_BUTTON);
            JVCScrollbarCanvas sbc = (JVCScrollbarCanvas)this.hash.get(SCROLLBAR_CANVAS);
            this.positionTopImageButton(bOne, d);
            this.positionBottomImageButton(bTwo, d);
            this.positionJVCScrollbarCanvas(sbc, bOne, bTwo, d);
        }
        catch (Exception exception) {
            System.err.println(String.valueOf(this) + " layout error");
        }
    }

    protected void positionTopImageButton(ImageButton b, Dimension d) {
        if (this.iOrientation == 1) {
            b.setBounds(0, 0, d.width, d.width);
        } else {
            b.setBounds(0, 0, d.height, d.height);
        }
    }

    protected void positionBottomImageButton(ImageButton b, Dimension d) {
        if (this.iOrientation == 1) {
            b.setBounds(0, d.height - d.width, d.width, d.width);
        } else {
            b.setBounds(d.width - d.height, 0, d.height, d.height);
        }
    }

    protected void positionJVCScrollbarCanvas(JVCScrollbarCanvas sbc, ImageButton bOne, ImageButton bTwo, Dimension d) {
        if (this.iOrientation == 1) {
            sbc.setBounds(0, d.width, d.width, d.height - 2 * d.width);
        } else {
            sbc.setBounds(d.height, 0, d.width - 2 * d.height, d.height);
        }
    }

    public String toString() {
        return "JVCScrollbarLayout";
    }
}

