/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.splitterPanel;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Panel;
import java.awt.Point;

public class SplitterPanelLayout
implements LayoutManager,
LayoutManager2 {
    static final boolean DEBUG = false;
    Component firstComponent;
    Component secondComponent;
    Panel splitter;
    int nOrientation = 0;
    Point currentPosition;
    Point currentDelta = new Point(0, 0);

    protected SplitterPanelLayout() {
        this(0);
    }

    protected SplitterPanelLayout(int nOrientation) {
        this.setOrientation(nOrientation);
    }

    protected void setOrientation(int nOrientation) {
        this.nOrientation = nOrientation;
    }

    public void addLayoutComponent(String name, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container parent) {
        return parent.getSize();
    }

    public Dimension minimumLayoutSize(Container parent) {
        return parent.getSize();
    }

    public void layoutContainer(Container parent) {
        Dimension dParent = parent.getSize();
        if (this.secondComponent == null) {
            if (this.firstComponent == null) {
                return;
            }
            this.firstComponent.setSize(dParent);
            this.firstComponent.setLocation(0, 0);
        } else if (this.nOrientation == 0) {
            this.layoutVertical(dParent);
        } else {
            this.layoutHorizontal(dParent);
        }
    }

    protected void layoutVertical(Dimension dParent) {
        Dimension d1 = this.firstComponent.getPreferredSize();
        Dimension d2 = this.secondComponent.getPreferredSize();
        Dimension d3 = this.splitter.getPreferredSize();
        if (dParent.width == 0 && dParent.height == 0) {
            return;
        }
        if (this.currentPosition == null) {
            int x = 0;
            if (d1.width + d2.width + d3.width <= dParent.width) {
                x = d1.width;
            } else {
                x = (int)((float)d1.width / (float)(d1.width + d2.width) * (float)dParent.width);
                x = Math.min(x, dParent.width - d3.width);
            }
            this.currentPosition = new Point(x, 0);
        } else {
            this.currentPosition.x += this.currentDelta.x;
            this.currentPosition.x = Math.min(this.currentPosition.x, dParent.width - d3.width);
        }
        this.firstComponent.setSize(this.currentPosition.x, dParent.height);
        this.firstComponent.setBounds(0, 0, this.currentPosition.x, dParent.height);
        this.firstComponent.invalidate();
        this.firstComponent.doLayout();
        this.splitter.setSize(d3.width, dParent.height);
        this.splitter.setLocation(this.currentPosition.x, 0);
        this.secondComponent.setSize(dParent.width - this.currentPosition.x - d3.width, dParent.height);
        this.secondComponent.setBounds(this.currentPosition.x + d3.width, 0, dParent.width - this.currentPosition.x - d3.width, dParent.height);
        this.secondComponent.invalidate();
        this.secondComponent.doLayout();
        this.currentDelta.x = 0;
        this.currentDelta.y = 0;
    }

    protected void layoutHorizontal(Dimension dParent) {
        Dimension d1 = this.firstComponent.getPreferredSize();
        Dimension d2 = this.secondComponent.getPreferredSize();
        Dimension d3 = this.splitter.getPreferredSize();
        if (this.currentPosition == null) {
            int y = 0;
            if (d1.height + d2.height + d3.height <= dParent.height) {
                y = d1.height;
            } else {
                y = (int)((float)d1.height / (float)(d1.height + d2.height) * (float)dParent.height);
                y = Math.min(y, dParent.height - d3.height);
            }
            this.currentPosition = new Point(0, y);
        } else {
            this.currentPosition.y += this.currentDelta.y;
            this.currentPosition.y = Math.min(this.currentPosition.y, dParent.height - d3.height);
        }
        this.firstComponent.setSize(dParent.width, this.currentPosition.y);
        this.firstComponent.setLocation(0, 0);
        this.splitter.setSize(dParent.width, d3.height);
        this.splitter.setLocation(0, this.currentPosition.y);
        this.secondComponent.setSize(dParent.width, dParent.height - this.currentPosition.y - d3.height);
        this.secondComponent.setLocation(0, this.currentPosition.y + d3.height);
        this.currentDelta.x = 0;
        this.currentDelta.y = 0;
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        if (this.splitter == null) {
            this.splitter = (Panel)comp;
        } else if (this.firstComponent == null) {
            this.firstComponent = comp;
        } else if (this.secondComponent == null) {
            this.secondComponent = comp;
        }
    }

    public Dimension maximumLayoutSize(Container parent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container parent) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container parent) {
        return 0.0f;
    }

    public void invalidateLayout(Container parent) {
    }

    public void splitterMoved(Point pDelta) {
        this.currentDelta = pDelta;
    }
}

