/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.statusBar;

import com.ibm.eNetwork.onDemand.common.gui.common.ColorsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.FontsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.ImagesForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.statusObject.StatusObjectCanvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;

public class StatusBarCanvas
extends StatusObjectCanvas
implements Runnable {
    protected Thread thread;
    protected String LEFT_BRAC = "[ ";
    protected String RIGHT_BRAC = " ]";
    protected String sLabel = "";
    protected boolean bThreadedPaint = true;
    protected boolean bPainting = false;

    public StatusBarCanvas(String sLabel, ColorsForCanvas cfcColor, FontsForCanvas ffcFont, ImagesForCanvas ifcImage) {
        this.copyAttribs(cfcColor, ffcFont, ifcImage);
        this.setAttribs();
        this.setLabel(sLabel);
        this.startThread();
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    this.repaint2();
                    if (!this.bThreadedPaint) break;
                    this.thread.suspend();
                }
                return;
            }
            catch (Exception exception) {
                System.out.println("StatusBar: paint exception caught");
                continue;
            }
            break;
        }
    }

    public void repaint() {
        try {
            if (this.bPainting) {
                return;
            }
            if (this.bThreadedPaint) {
                if (this.thread == null) {
                    this.startThread();
                }
                this.thread.resume();
            } else {
                if (this.thread != null) {
                    this.stopThread();
                }
                this.run();
            }
        }
        catch (Exception exception) {
            System.out.println("StatusBar: paint exception caught");
        }
    }

    public void draw(Graphics g) {
        try {
            this.bPainting = true;
            Dimension d = this.getSize();
            int iXoffset = (int)((float)d.width * this.fPercent) - 1;
            Rectangle area = new Rectangle(0, 0, d.width - 1, d.height - 1);
            g.setColor(this.cfcColor.getColor(2));
            g.fillRect(area.x, area.y, iXoffset, area.height);
            this.drawText(g, area);
            this.drawOutline(g, d);
            this.bPainting = false;
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public void setLabel(String sLabel) {
        this.sLabel = sLabel;
    }

    public void drawOutline(Graphics g, Dimension area) {
        SystemColor cBack = SystemColor.control;
        Color cLight = cBack.brighter();
        Color cMed = cBack.darker();
        Color cDark = cMed.darker();
        g.setColor(cLight);
        g.drawLine(0, 0, area.width, 0);
        g.drawLine(0, 0, 0, area.height);
        g.setColor(cMed);
        g.drawLine(1, area.height - 1, area.width - 1, area.height - 1);
        g.drawLine(area.width - 1, area.height - 1, area.width - 1, 1);
        g.setColor(cDark);
        g.drawLine(0, area.height, area.width, area.height);
        g.drawLine(area.width, area.height, area.width, 1);
    }

    public void drawText(Graphics g, Rectangle area) {
        String sTemp = String.valueOf(this.sLabel) + this.LEFT_BRAC + (int)(this.fPercent * 100.0f) + "%" + this.RIGHT_BRAC;
        int iWidth = this.ffcFont.getStringWidth(sTemp, 0);
        int iOffset = (area.height - this.ffcFont.getFontHeight(0)) / 2 + 3;
        g.setColor(this.cfcColor.getColor(1));
        g.drawString(sTemp, (area.width - iWidth) / 2, area.height - iOffset);
    }

    public void repaint2() {
        Graphics g = this.getGraphics();
        if (g == null) {
            super.repaint();
            return;
        }
        this.update(g);
    }

    public boolean getThreadedPaint() {
        return this.bThreadedPaint;
    }

    public void setThreadedPaint(boolean bThreadedPaint) {
        this.bThreadedPaint = bThreadedPaint;
    }

    protected void stopThread() {
        try {
            if (this.thread != null) {
                this.thread.stop();
                this.thread = null;
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    protected void startThread() {
        try {
            this.thread = new Thread(this);
            this.thread.setDaemon(true);
            this.thread.start();
            this.thread.suspend();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public boolean isFocusTraversable() {
        return false;
    }
}

