/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.tabView;

import com.ibm.eNetwork.onDemand.common.gui.common.ColorsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.FontsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.ImagesForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.LeftAlignedNode;
import com.ibm.eNetwork.onDemand.common.gui.tabView.Tab;
import com.ibm.eNetwork.onDemand.common.gui.tabView.TabCanvas;
import com.ibm.eNetwork.onDemand.common.gui.tabView.TopTab;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;

public class LtoRTabCanvas
extends TabCanvas {
    int iMaxHeight;

    public LtoRTabCanvas(ColorsForCanvas cfcColor, FontsForCanvas ffcFont, ImagesForCanvas ifcImage) {
        super(cfcColor, ffcFont, ifcImage);
    }

    protected Tab findTab(int x, int y) {
        Tab tabTemp = (Tab)this.lanCurrent;
        int iTotalX = 0;
        while (tabTemp != null) {
            if (x < (iTotalX += tabTemp.getWidth())) {
                return tabTemp;
            }
            tabTemp = (Tab)tabTemp.getNext();
        }
        return null;
    }

    public void draw(Graphics g) {
        int iX = 0;
        Rectangle r = null;
        Dimension dim = null;
        Dimension dimCanvas = this.getSize();
        LeftAlignedNode lanTemp = (LeftAlignedNode)this.lanCurrent;
        boolean iXoffset = false;
        int iOffset = 0;
        g.setColor(SystemColor.control);
        if (this.ifcImage.getImage(2) == null) {
            g.fillRect(0, 0, dimCanvas.width, dimCanvas.height);
        }
        this.bPageIsFull = true;
        while (lanTemp != null && iX < dimCanvas.width - lanTemp.getWidth()) {
            dim = lanTemp.getSize();
            r = new Rectangle(iX, 2, dim.width, dim.height);
            ((Tab)lanTemp).setTabPartiallyDisplayed(false);
            ((Tab)lanTemp).setFocus(this.bFocus);
            ((Tab)lanTemp).draw(g, r);
            iX += dim.width;
            this.lanCurrentEnd = lanTemp;
            lanTemp = (LeftAlignedNode)lanTemp.getNext();
        }
        if (lanTemp != null) {
            this.bPageIsFull = false;
            iOffset = dimCanvas.width - iX;
            dim = lanTemp.getSize();
            r = new Rectangle(iX, 2, dim.width, dim.height);
            ((Tab)lanTemp).setTabPartiallyDisplayed(true);
            ((Tab)lanTemp).draw(g, r);
        } else {
            g.setColor(SystemColor.control);
            if (this.lanTop instanceof TopTab) {
                g.fillRect(iX + 1, 0, dimCanvas.width - iX, dimCanvas.height);
                this.drawBottomLine(g, new Rectangle(iX + 1, 0, dimCanvas.width - iX, dimCanvas.height));
            } else {
                g.fillRect(iX + 1, 2, dimCanvas.width - iX, dimCanvas.height);
                this.drawTopLine(g, new Rectangle(iX + 1, 0, dimCanvas.width - iX, 0));
            }
        }
    }

    private void drawTopLine(Graphics g, Rectangle area) {
        SystemColor cBack = SystemColor.control;
        Color cDark = cBack.darker();
        g.setColor(cBack);
        g.drawLine(area.x, area.y, area.x + area.width, area.y);
        g.setColor(cDark);
        g.drawLine(area.x, area.y + 1, area.x + area.width, area.y + 1);
    }

    private void drawBottomLine(Graphics g, Rectangle area) {
        SystemColor cBack = SystemColor.control;
        Color cLight = cBack.brighter();
        g.setColor(cLight);
        g.drawLine(area.x, area.y + area.height - 2, area.x + area.width, area.y + area.height - 2);
        g.setColor(cBack);
        g.drawLine(area.x, area.y + area.height - 1, area.x + area.width, area.y + area.height - 1);
    }

    public void addNode(LeftAlignedNode lanNew, LeftAlignedNode lanPrev) {
        super.addNode(lanNew, lanPrev);
        if (lanNew != null && lanNew.getHeight() > this.iMaxHeight) {
            this.iMaxHeight = lanNew.getHeight();
        }
    }

    public void addNode(LeftAlignedNode lanNew) {
        super.addNode(lanNew);
        if (lanNew != null && lanNew.getHeight() > this.iMaxHeight) {
            this.iMaxHeight = lanNew.getHeight();
        }
    }

    public int getMaxHeight() {
        return this.iMaxHeight + 3;
    }

    public void committ() {
        Tab tabTemp = (Tab)this.lanTop;
        while (tabTemp != null) {
            tabTemp.setSize(tabTemp.getWidth(), this.iMaxHeight);
            tabTemp = (Tab)tabTemp.getNext();
        }
    }

    public int getMaxWidth() {
        return 0;
    }

    public int getOrientation() {
        return 1;
    }

    protected void shiftTabs(Tab tSelected) {
        this.moveToNextTab(false);
        Dimension dimCanvas = this.getSize();
        Dimension dim = null;
        LeftAlignedNode lanTemp = (LeftAlignedNode)this.lanCurrent;
        int iX = 0;
        while (lanTemp != null && iX < dimCanvas.width - lanTemp.getWidth()) {
            dim = lanTemp.getSize();
            ((Tab)lanTemp).setTabPartiallyDisplayed(false);
            iX += dim.width;
            lanTemp = (LeftAlignedNode)lanTemp.getNext();
        }
        if (lanTemp != null) {
            ((Tab)lanTemp).setTabPartiallyDisplayed(true);
        }
        this.selectTab(tSelected, 2);
    }
}

