/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.tabView;

import com.ibm.eNetwork.onDemand.common.gui.common.LeftAlignedNode;
import com.ibm.eNetwork.onDemand.common.gui.tabView.TabViewNode;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;

public abstract class Tab
extends LeftAlignedNode {
    protected boolean bIsPartial = false;
    protected boolean bFirst = false;
    protected boolean bLast = false;
    protected Color cBack;
    protected TabViewNode tvn;

    protected abstract void drawTabOutline(Graphics var1, Rectangle var2);

    public Tab(TabViewNode tvn) {
        super(tvn.getText(), tvn.getColors(), tvn.getFonts(), tvn.getImage());
        this.setTabViewNode(tvn);
    }

    public void draw(Graphics g, Rectangle area) {
        super.draw(g, area);
        this.drawTabOutline(g, area);
        this.drawOnFocus(g, area);
    }

    protected void drawOnFocus(Graphics g, Rectangle area) {
        if (this.hasFocus() && this.getSelected()) {
            g.setColor(SystemColor.controlDkShadow);
            g.drawRoundRect(area.x + (int)(0.5 * (double)this.iHorzSpace), area.y + (int)(1.5 * (double)this.iVertSpace), area.width - this.iHorzSpace, area.height - 3 * this.iVertSpace, 5, 5);
        }
    }

    public TabViewNode getTabViewNode() {
        return this.tvn;
    }

    public void setTabViewNode(TabViewNode tvn) {
        this.tvn = tvn;
    }

    public boolean getTabPartiallyDisplayed() {
        return this.bIsPartial;
    }

    public void setParentBackground(Color color) {
        this.cBack = color;
    }

    public void setTabPartiallyDisplayed(boolean bIsPartial) {
        this.bIsPartial = bIsPartial;
    }

    public void committ() {
        super.committ();
    }

    protected void calcSpaces() {
        this.iHorzSpace = 2;
        this.iVertSpace = this.ffcFont.getFontDescent(0) / 4;
    }

    protected void setFirst(boolean bFirst) {
        this.bFirst = bFirst;
    }

    protected void setLast(boolean bLast) {
        this.bLast = bLast;
    }
}

