/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.tabView;

import com.ibm.eNetwork.onDemand.common.gui.common.ColorsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.DrawableNode;
import com.ibm.eNetwork.onDemand.common.gui.common.DrawableObject;
import com.ibm.eNetwork.onDemand.common.gui.common.FontsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.ImagesForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.LeftAlignedNode;
import com.ibm.eNetwork.onDemand.common.gui.common.ViewCanvas;
import com.ibm.eNetwork.onDemand.common.gui.tabView.Tab;
import com.ibm.eNetwork.onDemand.common.gui.tabView.TabViewNode;
import com.ibm.eNetwork.onDemand.common.gui.tabView.TabsViewControler;
import java.awt.Graphics;

public abstract class TabCanvas
extends ViewCanvas {
    public final int LEFT_TO_RIGHT = 1;
    public final int TOP_TO_BOTTOM = 2;
    protected final int SHIFT = 1;
    protected final int NO_SHIFT = 2;
    protected boolean bPageIsFull = false;
    protected boolean bFocus = false;

    protected abstract Tab findTab(int var1, int var2);

    public abstract int getOrientation();

    abstract void shiftTabs(Tab var1);

    public TabCanvas(ColorsForCanvas cfcColor, FontsForCanvas ffcFont, ImagesForCanvas ifcImage) {
        this.copyAttribs(cfcColor, ffcFont, ifcImage);
        this.setAttribs();
    }

    public DrawableObject findOnMouseUp(int x, int y) {
        return this.findTab(x, y);
    }

    public DrawableObject findOnGotFocus() {
        return this.findSelectedTab();
    }

    public DrawableObject findCurrent() {
        return this.findSelectedTab();
    }

    public DrawableObject findOnMouseDown(int x, int y) {
        return this.findTab(x, y);
    }

    public DrawableObject findOnMouseMove(int x, int y) {
        return this.findTab(x, y);
    }

    public DrawableObject findOnKeyUp(int key) {
        return this.findSelectedTab();
    }

    public DrawableObject findOnKeyDown(int key) {
        return this.findSelectedTab();
    }

    protected void setStartingTab(Tab tabStart) {
        if (this.lanCurrent != null) {
            ((Tab)this.lanCurrent).setFirst(false);
        }
        if (tabStart != null) {
            this.lanCurrent = tabStart;
            ((Tab)this.lanCurrent).setFirst(true);
        }
    }

    protected Tab findSelectedTab() {
        Tab tabTemp = (Tab)this.lanTop;
        while (tabTemp != null) {
            if (tabTemp.getSelected()) {
                return tabTemp;
            }
            tabTemp = (Tab)tabTemp.getNext();
        }
        return null;
    }

    public void moveToNextTab(boolean bPaint) {
        Tab tabNext = (Tab)this.lanCurrent.getNext();
        if (!this.bPageIsFull) {
            if (tabNext != null) {
                this.setStartingTab(tabNext);
            }
            if (bPaint) {
                this.repaint();
            }
        }
    }

    public void moveToNextTab() {
        this.moveToNextTab(true);
    }

    public void moveToPrevTab() {
        Tab tabPrev = (Tab)this.lanCurrent.getPrev();
        if (tabPrev != null) {
            this.setStartingTab(tabPrev);
        }
        this.repaint();
    }

    public void selectNextTab() {
        if (this.lanSelected == null) {
            this.selectTab((Tab)this.lanTop);
        } else if (this.lanSelected.getNext() != null) {
            this.moveToNextTab();
            this.selectTab((Tab)this.lanSelected.getNext());
        }
    }

    public void selectPrevTab() {
        if (this.lanSelected == null) {
            this.selectTab((Tab)this.lanTop);
        } else if (this.lanSelected.getPrev() != null) {
            this.moveToPrevTab();
            this.selectTab((Tab)this.lanSelected.getPrev());
        }
    }

    public void selectTab(Tab tab) {
        this.selectTab(tab, 1);
    }

    public void selectTab(Tab tab, int iShift) {
        if (tab == null) {
            return;
        }
        if (this.lanSelected != null) {
            this.lanSelected.setSelected(false);
        }
        this.lanSelected = tab;
        this.lanSelected.setSelected(true);
        if (((Tab)this.lanSelected).getTabPartiallyDisplayed() && iShift == 1) {
            this.shiftTabs((Tab)this.lanSelected);
        } else {
            this.repaint();
        }
    }

    public void showTab(Tab tab) {
        if (tab != null) {
            this.setStartingTab(tab);
        }
    }

    public void selectTab(TabViewNode tvn) {
        Tab tabTemp = (Tab)this.lanTop;
        while (tabTemp != null) {
            if (tabTemp.getTabViewNode() == tvn) {
                this.setStartingTab(tabTemp);
                this.selectTab(tabTemp);
            }
            tabTemp = (Tab)tabTemp.getNext();
        }
    }

    public Tab findTab(TabViewNode tvn) {
        Tab tabTemp = (Tab)this.lanTop;
        while (tabTemp != null) {
            if (tabTemp.getTabViewNode() == tvn) {
                return tabTemp;
            }
            tabTemp = (Tab)tabTemp.getNext();
        }
        return null;
    }

    public void addNode(LeftAlignedNode lanNew, LeftAlignedNode lanPrev) {
        super.addNode(lanNew, lanPrev);
        if (this.lanCurrent == null) {
            this.setStartingTab((Tab)lanNew);
            this.selectTab((Tab)lanNew);
        }
    }

    public void addNode(LeftAlignedNode lanNew) {
        super.addNode(lanNew);
        if (this.lanCurrent == null) {
            this.setStartingTab((Tab)lanNew);
            this.selectTab((Tab)lanNew);
        }
    }

    public void deleteNode(LeftAlignedNode lanDel) {
        if (lanDel == this.lanSelected) {
            if (this.lanSelected.getNext() != null) {
                this.selectTab((Tab)this.lanSelected.getNext());
            } else {
                this.selectTab((Tab)this.lanSelected.getPrev());
            }
        }
        if (this.lanTop == lanDel && this.lanTop == this.lanCurrent) {
            this.lanCurrent = this.lanTop = (LeftAlignedNode)this.lanTop.getNext();
            this.setStartingTab((Tab)this.lanCurrent);
            if (this.lanCurrent == null && this.lanCurrent != this.lanSelected) {
                this.repaint();
            }
        } else if (lanDel == this.lanTop) {
            this.lanTop = (LeftAlignedNode)this.lanTop.getNext();
            if (this.lanTop != this.lanSelected) {
                this.repaint();
            }
        } else if (lanDel == this.lanCurrent) {
            this.lanCurrent = (LeftAlignedNode)lanDel.getNext();
            if (this.lanCurrent == null) {
                this.lanCurrent = (LeftAlignedNode)lanDel.getPrev();
            }
            this.setStartingTab((Tab)this.lanCurrent);
        }
        super.deleteNode(lanDel);
    }

    public void setFocus(boolean bFocus) {
        this.bFocus = bFocus;
    }

    public boolean getFocus() {
        return this.bFocus;
    }

    public DrawableNode findHeadNode() {
        return this.lanCurrent;
    }

    public DrawableNode findEndNode() {
        return this.lanCurrentEnd;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.con != null) {
            ((TabsViewControler)this.con).scrollbarEnablementCheck();
        }
    }
}

