/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.tabView;

import com.ibm.eNetwork.onDemand.common.gui.tabView.CardView;
import com.ibm.eNetwork.onDemand.common.gui.tabView.TabView;
import com.ibm.eNetwork.onDemand.common.gui.tabView.TabsView;
import com.ibm.eNetwork.onDemand.common.gui.tabView.tabOrientation;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Hashtable;

public class TabViewLayout
implements LayoutManager,
tabOrientation {
    protected TabsView tv;
    protected CardView cv;
    protected Hashtable hash = new Hashtable();
    protected static final int XOFFSET = 10;
    protected static final int YOFFSET = 10;
    public static final String TABS_VIEW = "tv";
    public static final String CARD_VIEW = "cv";

    public void addLayoutComponent(String name, Component comp) {
        this.hash.put(name, comp);
    }

    public void removeLayoutComponent(Component comp) {
        this.hash.remove(comp);
    }

    public Dimension preferredLayoutSize(Container parent) {
        return parent.getSize();
    }

    public Dimension minimumLayoutSize(Container parent) {
        if (parent instanceof TabView) {
            return ((TabView)parent).getMinSize();
        }
        return new Dimension(50, 50);
    }

    public void layoutContainer(Container parent) {
        boolean iIndex = false;
        Dimension d = parent.getSize();
        TabView tabView = (TabView)parent;
        this.tv = (TabsView)this.hash.get(TABS_VIEW);
        this.cv = (CardView)this.hash.get(CARD_VIEW);
        switch (tabView.getOrientation()) {
            case 1: {
                this.resizeForTop(d.width, d.height);
                break;
            }
            case 8: {
                this.resizeForRight(d.width, d.height);
                break;
            }
            case 4: {
                this.resizeForLeft(d.width, d.height);
                break;
            }
            default: {
                this.resizeForBottom(d.width, d.height);
            }
        }
    }

    protected void resizeForBottom(int width, int height) {
        int itvHeight = this.tv.getMaxHeight();
        Dimension dimCv = new Dimension(width, height - itvHeight + 2);
        this.cv.setSize(dimCv);
        this.tv.setSize(width - 20, itvHeight);
        this.tv.setLocation(10, dimCv.height - 2);
    }

    protected void resizeForTop(int width, int height) {
        int itvHeight = this.tv.getMaxHeight();
        Dimension dimCv = new Dimension(width, height - itvHeight + 2);
        this.cv.setSize(dimCv);
        this.cv.setLocation(0, itvHeight - 2);
        this.tv.setSize(width - 20, itvHeight);
        this.tv.setLocation(10, 0);
    }

    protected void resizeForRight(int width, int height) {
        int itvWidth = this.tv.getMaxWidth();
        Dimension dimCv = new Dimension(width - itvWidth + 2, height);
        this.cv.setSize(dimCv);
        this.cv.setLocation(0, 0);
        this.tv.setSize(itvWidth, height - 20);
        this.tv.setLocation(width - itvWidth, 10);
    }

    protected void resizeForLeft(int width, int height) {
        int itvWidth = this.tv.getMaxWidth();
        Dimension dimCv = new Dimension(width - itvWidth, height);
        this.cv.setSize(dimCv);
        this.cv.setLocation(itvWidth, 0);
        this.tv.setSize(itvWidth, height - 20);
        this.tv.setLocation(0, 10);
    }

    public String toString() {
        return "TabViewLayout";
    }
}

