/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.tabView;

import com.ibm.eNetwork.onDemand.common.gui.common.ColorsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.FontsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.ImagesForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.LeftAlignedNode;
import com.ibm.eNetwork.onDemand.common.gui.tabView.RightTab;
import com.ibm.eNetwork.onDemand.common.gui.tabView.Tab;
import com.ibm.eNetwork.onDemand.common.gui.tabView.TabCanvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;

public class TtoBTabCanvas
extends TabCanvas {
    protected int iMaxWidth;
    protected int iMaxHeight;

    public TtoBTabCanvas(ColorsForCanvas cfcColor, FontsForCanvas ffcFont, ImagesForCanvas ifcImage) {
        super(cfcColor, ffcFont, ifcImage);
    }

    protected Tab findTab(int x, int y) {
        Tab tabTemp = (Tab)this.lanCurrent;
        int iTotalY = 0;
        while (tabTemp != null) {
            if (y < (iTotalY += tabTemp.getHeight())) {
                return tabTemp;
            }
            tabTemp = (Tab)tabTemp.getNext();
        }
        return null;
    }

    public void draw(Graphics g) {
        int iY = 0;
        Rectangle r = null;
        Dimension dim = null;
        Dimension dimCanvas = this.getSize();
        LeftAlignedNode lanTemp = (LeftAlignedNode)this.lanCurrent;
        boolean iXoffset = false;
        int iOffset = 0;
        g.setColor(this.cfcColor.getColor(0));
        if (this.ifcImage.getImage(2) == null) {
            g.fillRect(0, 0, dimCanvas.width, dimCanvas.height);
        }
        this.bPageIsFull = true;
        if (this.lanCurrentEnd != null) {
            ((Tab)this.lanCurrentEnd).setLast(false);
        }
        do {
            dim = lanTemp.getSize();
            r = new Rectangle(2, iY + 2, dim.width, dim.height);
            ((Tab)lanTemp).setTabPartiallyDisplayed(false);
            ((Tab)lanTemp).setFocus(this.bFocus);
            ((Tab)lanTemp).draw(g, r);
            this.lanCurrentEnd = lanTemp;
        } while ((lanTemp = (LeftAlignedNode)lanTemp.getNext()) != null && (iY += dim.height) + lanTemp.getHeight() < dimCanvas.height);
        if (this.lanCurrentEnd != null) {
            ((Tab)this.lanCurrentEnd).setLast(true);
        }
        if (lanTemp != null) {
            this.bPageIsFull = false;
            iOffset = dimCanvas.height - iY;
            dim = lanTemp.getSize();
            r = new Rectangle(2, iY, dim.width, dim.height);
            ((Tab)lanTemp).setTabPartiallyDisplayed(true);
            ((Tab)lanTemp).draw(g, r);
        } else {
            g.setColor(this.cfcColor.getColor(0));
            if (this.lanTop instanceof RightTab) {
                g.fillRect(0, iY + 4, dimCanvas.width, dimCanvas.height - iY);
                this.drawLeftLine(g, new Rectangle(0, iY + 4, 2, dimCanvas.height - iY));
            } else {
                g.fillRect(0, iY + 2, dimCanvas.width, dimCanvas.height - iY);
                this.drawRightLine(g, new Rectangle(dimCanvas.width, iY + 1, 0, dimCanvas.height - iY));
            }
        }
    }

    private void drawRightLine(Graphics g, Rectangle area) {
        SystemColor cBack = SystemColor.control;
        g.setColor(cBack);
        g.drawLine(area.x, area.y, area.x, area.y + area.height);
        g.setColor(cBack.darker());
        g.drawLine(area.x + 1, area.y, area.x + 1, area.y + area.height);
    }

    private void drawLeftLine(Graphics g, Rectangle area) {
        SystemColor cBack = SystemColor.control;
        g.setColor(cBack);
        g.drawLine(area.x, area.y, area.x, area.y + area.height);
        g.setColor(cBack.darker());
        g.drawLine(area.x + 1, area.y, area.x + 1, area.y + area.height);
    }

    public void addNode(LeftAlignedNode lanNew, LeftAlignedNode lanPrev) {
        super.addNode(lanNew, lanPrev);
        if (lanNew != null) {
            if (lanNew.getWidth() > this.iMaxWidth) {
                this.iMaxWidth = lanNew.getWidth();
            }
            if (lanNew.getHeight() > this.iMaxHeight) {
                this.iMaxHeight = lanNew.getHeight();
            }
        }
    }

    public void addNode(LeftAlignedNode lanNew) {
        super.addNode(lanNew);
        if (lanNew != null) {
            if (lanNew.getWidth() > this.iMaxWidth) {
                this.iMaxWidth = lanNew.getWidth();
            }
            if (lanNew.getHeight() > this.iMaxHeight) {
                this.iMaxHeight = lanNew.getHeight();
            }
        }
    }

    public int getMaxWidth() {
        return this.iMaxWidth + 3;
    }

    public int getMaxHeight() {
        return this.iMaxHeight + 3;
    }

    public void committ() {
        Tab tabTemp = (Tab)this.lanTop;
        while (tabTemp != null) {
            tabTemp.setSize(this.iMaxWidth, this.iMaxHeight);
            tabTemp = (Tab)tabTemp.getNext();
        }
    }

    public int getOrientation() {
        return 2;
    }

    public void shiftTabs(Tab tSelected) {
        this.moveToNextTab(false);
        Dimension dimCanvas = this.getSize();
        Dimension dim = null;
        LeftAlignedNode lanTemp = (LeftAlignedNode)this.lanCurrent;
        int iY = 0;
        do {
            dim = lanTemp.getSize();
            ((Tab)lanTemp).setTabPartiallyDisplayed(false);
        } while ((lanTemp = (LeftAlignedNode)lanTemp.getNext()) != null && (iY += dim.height) + lanTemp.getHeight() < dimCanvas.height);
        if (lanTemp != null) {
            ((Tab)lanTemp).setTabPartiallyDisplayed(true);
        }
        this.selectTab(tSelected, 2);
    }
}

