/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.treeView;

import com.ibm.eNetwork.onDemand.common.gui.treeView.TreeViewCanvas;
import com.ibm.eNetwork.onDemand.common.gui.treeView.ableToUseDragManager;
import com.ibm.eNetwork.onDemand.common.gui.treeView.addableToTreeView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

public class DragManager {
    protected Vector vViews = new Vector(2, 2);
    protected Vector vClients = new Vector(2, 2);
    protected Vector vPositions;
    protected static final int DRAW_GHOST = 0;
    protected static final int DRAG_DROP = 1;
    protected addableToTreeView attvNode;
    protected TreeViewCanvas tvLastDest;
    protected static DragManager dm = null;

    protected DragManager() {
    }

    public static DragManager getDragManager() {
        if (dm == null) {
            dm = new DragManager();
        }
        return dm;
    }

    public void registerView(TreeViewCanvas tv, ableToUseDragManager client) {
        this.vViews.addElement(tv);
        this.vClients.addElement(client);
    }

    public void unregisterView(TreeViewCanvas tv, ableToUseDragManager client) {
        this.vViews.removeElement(tv);
        this.vViews.removeElement(client);
    }

    public void startDrag(TreeViewCanvas tv, addableToTreeView attvNode) {
        this.findAbsolutePositions();
        this.attvNode = attvNode;
    }

    public void stopDrag(TreeViewCanvas tv, Point p) {
        TreeViewCanvas tvDest = this.findTarget(tv, p);
        int iIndex = this.vViews.indexOf(tv);
        ableToUseDragManager client = (ableToUseDragManager)this.vClients.elementAt(iIndex);
        if (tvDest != null) {
            boolean bSuccess = this.callbackClient(tv, tvDest, p, 1);
            client.dropAccomplished(bSuccess, this.attvNode);
        } else {
            client.dropAccomplished(false, this.attvNode);
        }
        this.vPositions.removeAllElements();
    }

    public void drag(TreeViewCanvas tv, Point p) {
        TreeViewCanvas tvDest = this.findTarget(tv, p);
        if (tvDest != this.tvLastDest) {
            if (this.tvLastDest != null) {
                this.callbackClient(tv, this.tvLastDest, new Point(0, 0), 0);
            }
            this.tvLastDest = tvDest;
        }
        if (tvDest != null) {
            this.callbackClient(tv, tvDest, p, 0);
        }
    }

    protected boolean callbackClient(TreeViewCanvas tvSource, TreeViewCanvas tvDest, Point p, int iCallback) {
        int iIndex = this.vViews.indexOf(tvDest);
        ableToUseDragManager client = (ableToUseDragManager)this.vClients.elementAt(iIndex);
        Point pDest = this.findCachedPosition(tvDest);
        Point pSource = this.findCachedPosition(tvSource);
        pSource.x += p.x;
        pSource.y += p.y;
        pDest.x = pSource.x - pDest.x;
        pDest.y = pSource.y - pDest.y;
        if (iCallback == 0) {
            client.drawGhostAt(pDest);
            return false;
        }
        return client.droppedAt(pDest, this.attvNode);
    }

    protected Point findCachedPosition(TreeViewCanvas tv) {
        int iIndex = this.vViews.indexOf(tv);
        Rectangle r = (Rectangle)this.vPositions.elementAt(iIndex);
        Point p = new Point(r.x, r.y);
        return p;
    }

    protected TreeViewCanvas findTarget(TreeViewCanvas tv, Point p) {
        Enumeration enumeration = this.vPositions.elements();
        Point pAbsolute = this.findCachedPosition(tv);
        pAbsolute.x += p.x;
        pAbsolute.y += p.y;
        int iIndex = 0;
        Rectangle r = null;
        TreeViewCanvas tvTemp = null;
        while (enumeration.hasMoreElements()) {
            r = (Rectangle)enumeration.nextElement();
            if (pAbsolute.x >= r.x && pAbsolute.x <= r.x + r.width && pAbsolute.y >= r.y && pAbsolute.y <= r.y + r.height && (tvTemp = (TreeViewCanvas)this.vViews.elementAt(iIndex)) != tv) {
                return tvTemp;
            }
            ++iIndex;
        }
        return null;
    }

    protected void findAbsolutePositions() {
        this.vPositions = new Vector();
        Enumeration enumeration = this.vViews.elements();
        TreeViewCanvas tv = null;
        Point p = null;
        Dimension d = null;
        Rectangle rect = null;
        while (enumeration.hasMoreElements()) {
            tv = (TreeViewCanvas)enumeration.nextElement();
            p = this.findAbsolutePosition(tv);
            d = tv.getSize();
            rect = new Rectangle(p.x, p.y, d.width, d.height);
            this.vPositions.addElement(rect);
        }
    }

    protected Point findAbsolutePosition(Component c) {
        Component comp = c;
        if (c == null) {
            return null;
        }
        Point p = new Point(0, 0);
        Point pTemp = null;
        do {
            pTemp = c.getLocation();
            p.x += pTemp.x;
            p.y += pTemp.y;
        } while ((c = c.getParent()) != null);
        return p;
    }
}

