/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.treeView;

import com.ibm.eNetwork.onDemand.common.gui.common.ColorsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.ExtendedPanel;
import com.ibm.eNetwork.onDemand.common.gui.common.FontsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.ImagesForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.dbCanvasImageIndexMap;
import com.ibm.eNetwork.onDemand.common.gui.jvcScrollbar.JVCScrollbar;
import com.ibm.eNetwork.onDemand.common.gui.treeView.CommitTypes;
import com.ibm.eNetwork.onDemand.common.gui.treeView.TreeViewCanvas;
import com.ibm.eNetwork.onDemand.common.gui.treeView.TreeViewControler;
import com.ibm.eNetwork.onDemand.common.gui.treeView.TreeViewEventListener;
import com.ibm.eNetwork.onDemand.common.gui.treeView.TreeViewLayout;
import com.ibm.eNetwork.onDemand.common.gui.treeView.TreeViewNode;
import com.ibm.eNetwork.onDemand.common.gui.treeView.ableToUseTreeViewCanvas;
import com.ibm.eNetwork.onDemand.common.gui.treeView.addableToTreeView;
import com.ibm.eNetwork.onDemand.common.gui.treeView.treeViewDragManager;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.PopupMenu;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import java.util.Vector;

public class TreeView
extends ExtendedPanel
implements ableToUseTreeViewCanvas,
dbCanvasImageIndexMap,
CommitTypes {
    protected JVCScrollbar sbHorz;
    protected JVCScrollbar sbVert;
    protected TreeViewControler tvcCon;
    protected TreeViewCanvas tvc;
    protected TreeViewLayout tvl;
    protected Dimension dimView = new Dimension(100, 100);
    protected addableToTreeView attvRoot;
    protected boolean bLastCommitt = true;
    protected PopupMenu pop;
    protected PopupMenu popMulti;

    public TreeView(addableToTreeView attvRoot, Dimension dimView, ColorsForCanvas cfcColor, FontsForCanvas ffcFont, ImagesForCanvas ifcImage, Image iPlus, Image iMinus) {
        this.attvRoot = attvRoot;
        this.dimView = dimView;
        this.copyAttribs(cfcColor, ffcFont, ifcImage);
        this.setAttribs();
        this.setLayoutManager();
        this.sbVert = new JVCScrollbar(1, 1, 10, 1, 100);
        this.sbVert.committ();
        this.add("sbVert", this.sbVert);
        this.sbHorz = new JVCScrollbar(0, 1, 10, 1, 100);
        this.sbHorz.committ();
        this.add("sbHorz", this.sbHorz);
        this.tvc = this.createTreeViewCanvas(attvRoot, cfcColor, ffcFont, ifcImage);
        this.tvc.setImages(iPlus, iMinus);
        this.add("tvc", this.tvc);
        this.tvcCon.registerScrollbars(this.sbHorz, this.sbVert);
    }

    public addableToTreeView getRootNode() {
        return this.attvRoot;
    }

    protected void setLayoutManager() {
        TreeViewLayout tvl = new TreeViewLayout();
        this.setLayout(tvl);
        tvl.setPreferredSize(this.dimView);
    }

    public Dimension getMinSize() {
        return this.dimView;
    }

    public void empty() {
        this.tvc.empty();
    }

    protected TreeViewCanvas createTreeViewCanvas(addableToTreeView attvRoot, ColorsForCanvas cfcColor, FontsForCanvas ffcFont, ImagesForCanvas ifcImage) {
        TreeViewCanvas tvc = new TreeViewCanvas(this, attvRoot, cfcColor, ffcFont, ifcImage);
        this.tvcCon = this.createTreeViewControler();
        tvc.setControler(this.tvcCon);
        return tvc;
    }

    protected TreeViewControler createTreeViewControler() {
        return new TreeViewControler(this);
    }

    public void commit(int iCommitType) {
        this.tvc.commit(iCommitType);
    }

    public void commit(boolean bNumNodesChanged) {
        this.committ(bNumNodesChanged);
    }

    public void commit() {
        this.committ();
    }

    public void committ(boolean bNumNodesChanged) {
        this.tvc.committ(bNumNodesChanged);
    }

    public void committ() {
        this.tvc.committ();
    }

    public void numNodesChanged(int iNewNum) {
        try {
            this.sbVert.setMaximum(iNewNum);
        }
        catch (Exception exception) {}
    }

    public void offscreenWidth(int iWidthOffscreen) {
        try {
            Dimension d = this.getSize();
            this.sbHorz.setMaximum(iWidthOffscreen);
            this.sbHorz.setBlockIncrement(d.width - iWidthOffscreen);
        }
        catch (Exception exception) {}
    }

    public void currentNodePos(int iPos) {
        try {
            this.sbVert.setValue(iPos);
        }
        catch (Exception exception) {}
    }

    public void setNodeLineDrawing(boolean bDrawNodeLines) {
        this.tvc.setNodeLineDrawing(bDrawNodeLines);
    }

    public addableToTreeView findSelectedTreeViewNode() {
        try {
            TreeViewNode tvn = this.tvc.findSelectedTreeViewNode();
            return tvn.getAddableToTreeView();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Vector findSelectedTreeViewNodes() {
        try {
            Vector v = this.tvc.findSelectedTreeViewNodes();
            if (v == null) {
                return null;
            }
            TreeViewNode tvn = null;
            Vector<addableToTreeView> v2 = new Vector<addableToTreeView>(v.size());
            Enumeration enumeration = v.elements();
            while (enumeration.hasMoreElements()) {
                tvn = (TreeViewNode)enumeration.nextElement();
                v2.addElement(tvn.getAddableToTreeView());
            }
            return v2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString() {
        return "TreeView [root=" + this.attvRoot.getText() + "]";
    }

    public void showTreeViewNode(addableToTreeView attvNode) {
        if (attvNode == null) {
            return;
        }
        this.tvc.showNode(attvNode);
    }

    public void selectTreeViewNode(addableToTreeView attvNode) {
        if (attvNode == null) {
            return;
        }
        this.tvc.selectNode(attvNode);
    }

    public void unSelectTreeViewNode() {
        this.tvc.selectNode((addableToTreeView)null);
    }

    public void expandTreeViewNode(addableToTreeView attvNode, boolean bExpanded, boolean bCommitt) {
        if (attvNode == null) {
            return;
        }
        this.tvc.expandNode(attvNode, bExpanded, bCommitt);
    }

    public void setAutoFocus(boolean bAutoFocus) {
        this.tvcCon.setAutoFocus(bAutoFocus);
    }

    public void expandAllNodes() {
        this.tvc.expandAllNodes(true);
    }

    public void collapseAllNodes() {
        this.tvc.expandAllNodes(false);
    }

    public void addTreeViewEventListener(TreeViewEventListener listener) {
        this.tvcCon.addListener(listener);
    }

    public void removeTreeViewEventListener(TreeViewEventListener listener) {
        this.tvcCon.removeListener(listener);
    }

    public void setPopupMenu(PopupMenu pop) {
        this.pop = pop;
    }

    public PopupMenu getPopupMenu() {
        return this.pop;
    }

    public void setMultiSelect(boolean bMulitSelect) {
        this.tvc.setMultiSelect(bMulitSelect);
        this.tvcCon.setMultiSelect(bMulitSelect);
    }

    public void setMultiPopupMenu(PopupMenu popMulti) {
        this.popMulti = popMulti;
    }

    public PopupMenu getMultiPopupMenu() {
        return this.popMulti;
    }

    public void setTreeViewDragManager(treeViewDragManager manager) {
        this.tvcCon.setDragManager(manager);
    }

    public void dispose() {
        try {
            this.finalize();
            Runtime.getRuntime().runFinalization();
        }
        catch (Throwable t) {
            System.err.println(t);
        }
    }

    public void finalize() throws Throwable {
        this.sbHorz.dispose();
        this.sbVert.dispose();
        this.sbHorz = null;
        this.sbVert = null;
        if (this.tvcCon != null) {
            this.tvcCon.dispose();
        }
        if (this.tvc != null) {
            this.tvc.dispose();
        }
        if (this.tvl != null) {
            this.tvl.dispose();
        }
        this.tvcCon = null;
        this.tvc = null;
        this.dimView = null;
        this.attvRoot = null;
        this.pop = null;
        this.popMulti = null;
        super.finalize();
    }

    public void addKeyListener(KeyListener kl) {
        this.tvc.addKeyListener(kl);
    }

    public void removeKeyListener(KeyListener kl) {
        this.tvc.removeKeyListener(kl);
    }
}

