/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.images;

import com.ibm.eNetwork.onDemand.common.images.ClientImageNames;
import com.ibm.eNetwork.onDemand.common.images.ImageLoader;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ClientImageLoader
extends ImageLoader
implements ClientImageNames {
    public static final boolean DEBUG = false;
    public static final boolean ASSERT = false;
    protected static Hashtable hashGlobal = new Hashtable();

    public ClientImageLoader(Component c) {
        super(c);
    }

    public Image getImage(String filename) {
        return super.getImage(this.getClass(), filename);
    }

    public Image getImageFromFilename(String filename) {
        return super.getImage(filename);
    }

    public Vector getImages(Vector vsFilenames) {
        return super.getImages(this.getClass(), vsFilenames);
    }

    public Vector getImagesFromFilenames(Vector vFilenames) {
        return super.getImages(vFilenames);
    }

    protected Object get(URL urlMediaFile) {
        Image image = null;
        if (urlMediaFile != null && (image = (Image)this.hashtable.get(urlMediaFile)) == null) {
            ImageCounter imgCounter = (ImageCounter)hashGlobal.get(urlMediaFile);
            if (imgCounter == null) {
                Toolkit t = Toolkit.getDefaultToolkit();
                image = t.getImage(urlMediaFile);
                if (image != null) {
                    imgCounter = new ImageCounter(image);
                    hashGlobal.put(urlMediaFile, imgCounter);
                }
            } else {
                image = imgCounter.getImage();
            }
            if (image != null) {
                imgCounter.increment();
                this.hashtable.put(urlMediaFile, image);
            }
        }
        return image;
    }

    public void flushImages() {
        Enumeration e = this.hashtable.keys();
        while (e.hasMoreElements()) {
            URL url = (URL)e.nextElement();
            if (url == null) continue;
            Image img = this.removeImage(url);
            ImageCounter imgCounter = (ImageCounter)hashGlobal.get(url);
            if (imgCounter == null || imgCounter.decrement() > 0) continue;
            hashGlobal.remove(url);
        }
    }

    public class ImageCounter {
        int nCount;
        Image image;

        public ImageCounter(Image image) {
            ClientImageLoader.this = ClientImageLoader.this;
            this.image = image;
        }

        public synchronized void increment() {
            ++this.nCount;
        }

        public synchronized int decrement() {
            --this.nCount;
            return this.nCount;
        }

        public int getCount() {
            return this.nCount;
        }

        public Image getImage() {
            return this.image;
        }
    }
}

