/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.images;

import com.ibm.eNetwork.onDemand.common.ResourceLoader;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public class ImageLoader
extends ResourceLoader {
    protected Component component;

    public ImageLoader(Component c) {
        this.component = c;
    }

    protected Object get(URL urlMediaFile) {
        Image image = null;
        if (this.hashtable.containsKey(urlMediaFile)) {
            image = (Image)this.hashtable.get(urlMediaFile);
        } else {
            Toolkit t = Toolkit.getDefaultToolkit();
            image = t.getImage(urlMediaFile);
            this.hashtable.put(urlMediaFile, image);
        }
        return image;
    }

    protected boolean trackImage(Image image) {
        try {
            MediaTracker mt = new MediaTracker(this.component);
            mt.addImage(image, 1);
            mt.waitForID(1);
            return !mt.isErrorID(1);
        }
        catch (Exception e) {
            System.err.println("ImageLoader.trackImage: " + e);
            return false;
        }
    }

    public Image getImage(String filename) {
        return this.getImage(this.getURLofResource(null, filename));
    }

    public Image getImage(Class c, String filename) {
        return this.getImage(this.getURLofResource(c, filename));
    }

    public Vector getImages(Vector vsFilenames) {
        return this.getImages(null, vsFilenames);
    }

    public Vector getImages(Class c, Vector vsFilenames) {
        Vector<Object> vImages = new Vector<Object>();
        if (vsFilenames.isEmpty()) {
            return null;
        }
        Enumeration e = vsFilenames.elements();
        while (e.hasMoreElements()) {
            vImages.addElement(this.get(this.getURLofResource(c, (String)e.nextElement())));
        }
        MediaTracker mt = new MediaTracker(this.component);
        e = vImages.elements();
        while (e.hasMoreElements()) {
            mt.addImage((Image)e.nextElement(), 1);
        }
        try {
            mt.waitForID(1);
        }
        catch (InterruptedException ie) {
            System.err.println("ImageLoader.loadImages(): " + ie);
            return vImages;
        }
        if (mt.isErrorID(1)) {
            System.err.println("There was an error loading images from the vector: " + vsFilenames);
        }
        return vImages;
    }

    public Image getImage(URL url) {
        Image image = (Image)this.get(url);
        if (!this.trackImage(image)) {
            System.err.println("ImageLoader.get: there was an error loading file from URL " + url);
            this.removeImage(url);
            return null;
        }
        return image;
    }

    public Image removeImage(String filename) {
        return (Image)this.removeFromBuffer(this.getURLofResource(null, filename));
    }

    public Image removeImage(URL url) {
        return (Image)this.removeFromBuffer(url);
    }
}

