/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.netdiver.app;

import COM.ibm.netdiver.app.NdActionListener;
import COM.ibm.netdiver.app.NdActions;
import COM.ibm.netdiver.browser.LocalAppletSecurityParameters;
import COM.ibm.netdiver.browser.NdSecurityManager;
import COM.ibm.netdiver.browser.RemoteAppletSecurityParameters;
import COM.ibm.netdiver.browser.SecurityParameters;
import COM.ibm.netdiver.gui.GridBagUtil;
import COM.ibm.netdiver.util.MessageResourceBundle;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class SecurityDialog
extends Dialog
implements WindowListener,
NdActions {
    String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
    private SecurityDialogElement[] checks;
    private Panel checkboxPanel;
    private Panel buttonPanel;
    private Button okButton;
    private Button cancelButton;
    private MessageResourceBundle rb = MessageResourceBundle.getResource("COM.ibm.netdiver.app.res.SecurityDialogMessage");

    public SecurityDialog(Frame frame) {
        super(frame, false);
        this.setTitle(this.rb.getFixedString("T_APPLETSECURITY", "Applet Security Setting"));
        this.addWindowListener(this);
        this.checks = new SecurityDialogElement[22];
        this.checks[0] = new SecurityDialogElement(14, this.rb.getFixedString("CHK_R_LOCALFILE", "Read local file"));
        this.checks[1] = new SecurityDialogElement(18, this.rb.getFixedString("CHK_W_LOCALFILE", "Write local file"));
        this.checks[2] = new SecurityDialogElement(4, this.rb.getFixedString("CHK_D_LOCALFILE", "Delete local file"));
        this.checks[3] = new SecurityDialogElement(11, this.rb.getFixedString("CHK_R_ALLSYSPROPERTIES", "Read all system properties"));
        this.checks[4] = new SecurityDialogElement(2, this.rb.getFixedString("CHK_3RDHOSTPORT", "Connect to port on 3rd host"));
        this.checks[5] = new SecurityDialogElement(7, this.rb.getFixedString("CHK_L_DYNAMICLIB", "Load dynamic library"));
        this.checks[6] = new SecurityDialogElement(6, this.rb.getFixedString("CHK_CALLSYSEXIT", "Call System.exit()"));
        this.checks[7] = new SecurityDialogElement(16, this.rb.getFixedString("CHK_W_POPUPWIN", "Create a popup window without a warning"));
        this.checks[8] = new SecurityDialogElement(0, this.rb.getFixedString("CHK_ACCEPT", "Accept a socket connection"));
        this.checks[9] = new SecurityDialogElement(1, this.rb.getFixedString("CHK_ACCESS", "Modify the thread/thread group argument"));
        this.checks[10] = new SecurityDialogElement(19, this.rb.getFixedString("CHK_A_EVTQUEUE", "Access to the AWT event queue"));
        this.checks[11] = new SecurityDialogElement(3, this.rb.getFixedString("CHK_CLASSLOADER", "Create a new class loader"));
        this.checks[12] = new SecurityDialogElement(5, this.rb.getFixedString("CHK_EXEC", "Create a subprocess"));
        this.checks[13] = new SecurityDialogElement(8, this.rb.getFixedString("CHK_LISTEN", "Wait for a connection request"));
        this.checks[14] = new SecurityDialogElement(20, this.rb.getFixedString("CHK_A_MEMBER", "Access members"));
        this.checks[15] = new SecurityDialogElement(21, this.rb.getFixedString("CHK_MULTICAST", "Use IP multicast"));
        this.checks[16] = new SecurityDialogElement(9, this.rb.getFixedString("CHK_A_PACKAGE", "Access the package"));
        this.checks[17] = new SecurityDialogElement(10, this.rb.getFixedString("CHK_DEF_PACKAGE", "Define classes in the package"));
        this.checks[18] = new SecurityDialogElement(22, this.rb.getFixedString("CHK_A_PRINTJOB", "Initiate a print job request"));
        this.checks[19] = new SecurityDialogElement(23, this.rb.getFixedString("CHK_A_SECURITY", "Operations for a security API action"));
        this.checks[20] = new SecurityDialogElement(15, this.rb.getFixedString("CHK_SET_FACTORY", "Set socket/stream handler factory"));
        this.checks[21] = new SecurityDialogElement(24, this.rb.getFixedString("CHK_A_CLIPBOARD", "Access to the system clipboard"));
        this.checkboxPanel = new Panel();
        this.checkboxPanel.setLayout(new GridBagLayout());
        int n = 0;
        while (n < this.checks.length) {
            GridBagUtil.constrain(this.checkboxPanel, this.checks[n].checkbox(), 0, n, 1, 1, 2, 18, 1.0, 0.0, 0, 0, 0, 0);
            ++n;
        }
        this.okButton = new Button(this.rb.getFixedString("B_OK", "Ok"));
        this.okButton.addActionListener(new NdActionListener("Ok", this));
        this.cancelButton = new Button(this.rb.getFixedString("B_CANCEL", "Cancel"));
        this.cancelButton.addActionListener(new NdActionListener("Cancel", this));
        this.buttonPanel = new Panel();
        this.buttonPanel.setLayout(new FlowLayout());
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        this.setLayout(new GridBagLayout());
        GridBagUtil.constrain(this, this.checkboxPanel, 0, 0, 1, 1, 2, 18, 1.0, 0.0, 0, 0, 0, 0);
        GridBagUtil.constrain(this, new Panel(), 0, 1, 1, 1, 1, 18, 1.0, 1.0, 0, 0, 0, 0);
        GridBagUtil.constrain(this, this.buttonPanel, 0, 2, 1, 1, 2, 18, 1.0, 0.0, 0, 0, 0, 0);
        this.pack();
        ((Component)this).setBounds(100, 100, 400, 600);
        this.refreshCheckbox();
    }

    public void implementActions(String string) {
        if (string.equals("Ok")) {
            this.setSecurityParameters();
            this.exit();
            return;
        }
        if (string.equals("Cancel")) {
            this.exit();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.exit();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    private void exit() {
        ((Component)this).setVisible(false);
        this.refreshCheckbox();
        this.getParent().requestFocus();
    }

    private void setSecurityParameters() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && securityManager instanceof NdSecurityManager) {
            int n = -1;
            RemoteAppletSecurityParameters remoteAppletSecurityParameters = new RemoteAppletSecurityParameters();
            int n2 = 0;
            while (n2 < this.checks.length) {
                remoteAppletSecurityParameters.setCheck(this.checks[n2].check(), this.checks[n2].checkbox().getState());
                if (this.checks[n2].check() == 4) {
                    n = n2;
                }
                ++n2;
            }
            ((NdSecurityManager)securityManager).setSecurityParameters(remoteAppletSecurityParameters);
            if (n != -1) {
                LocalAppletSecurityParameters localAppletSecurityParameters = new LocalAppletSecurityParameters();
                localAppletSecurityParameters.setCheck(this.checks[n].check(), this.checks[n].checkbox().getState());
                ((NdSecurityManager)securityManager).setSecurityParameters(localAppletSecurityParameters);
            }
        }
    }

    private void refreshCheckbox() {
        SecurityParameters securityParameters;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && securityManager instanceof NdSecurityManager && (securityParameters = ((NdSecurityManager)securityManager).getSecurityParameters(2)) != null) {
            int n = 0;
            while (n < this.checks.length) {
                this.checks[n].checkbox().setState(securityParameters.permit(this.checks[n].check()));
                ++n;
            }
        }
    }

    final class SecurityDialogElement {
        String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
        private int check;
        private String text;
        private Checkbox checkbox;

        public SecurityDialogElement(int n, String string) {
            SecurityDialog.this = SecurityDialog.this;
            this.check = n;
            this.text = string;
            this.checkbox = new Checkbox(string);
        }

        public int check() {
            return this.check;
        }

        public String text() {
            return this.text;
        }

        public Checkbox checkbox() {
            return this.checkbox;
        }
    }
}

