/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.netdiver.browser;

import COM.ibm.netdiver.browser.HTMLDocument;
import COM.ibm.netdiver.browser.HTMLDocumentWindow;
import COM.ibm.netdiver.gui.WebBrowserWindow;
import COM.ibm.netdiver.util.Vector;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;

public class BrowserHolder {
    String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
    private WebBrowserWindow rootbrowser;
    private HTMLDocument document;
    private Vector parts;
    private Vector borders;
    private WebBrowserWindow currentbrowser;
    private HTMLDocumentWindow currentclient;
    private HolderItem currentitem;
    private int updateIndex;
    private int levelcounter;
    private boolean fComposing = false;

    public BrowserHolder(WebBrowserWindow webBrowserWindow) {
        if (this.rootbrowser == null) {
            this.rootbrowser = webBrowserWindow;
        }
    }

    public WebBrowserWindow browser() {
        return this.rootbrowser;
    }

    public void setHTMLClient(WebBrowserWindow webBrowserWindow, HTMLDocumentWindow hTMLDocumentWindow, boolean bl) {
        if (this.levelcounter > 0) {
            return;
        }
        if (this.rootbrowser == webBrowserWindow) {
            this.currentitem = null;
            this.parts = new Vector();
            this.borders = new Vector();
            this.fComposing = true;
            this.rootbrowser.setScrolling(0);
        } else {
            this.unlinkChild(webBrowserWindow);
            if (bl) {
                this.fComposing = true;
            } else {
                this.restoreFrameAttrs(webBrowserWindow);
            }
        }
        this.currentbrowser = webBrowserWindow;
        this.currentclient = hTMLDocumentWindow;
    }

    public void setHTMLClient(WebBrowserWindow webBrowserWindow, HTMLDocumentWindow hTMLDocumentWindow, Rectangle rectangle) {
        this.currentitem.setHTMLClient(webBrowserWindow, hTMLDocumentWindow, rectangle);
    }

    public void restoreFrameAttrs(WebBrowserWindow webBrowserWindow) {
        if (this.parts == null) {
            return;
        }
        int n = 0;
        while (n < this.parts.size()) {
            ChildFrame childFrame = (ChildFrame)this.parts.elementAt(n);
            if (webBrowserWindow == childFrame.browser) {
                childFrame.restoreFrameAttrs();
            }
            ++n;
        }
    }

    public void unlinkChild(WebBrowserWindow webBrowserWindow) {
        if (this.parts == null || this.parts.size() == 0) {
            return;
        }
        Vector vector = new Vector();
        int n = 0;
        while (n < this.parts.size()) {
            ChildFrame childFrame = (ChildFrame)this.parts.elementAt(n);
            if (childFrame.topbrowser == webBrowserWindow) {
                if (childFrame.browser == webBrowserWindow) {
                    vector.addElement(childFrame);
                }
            } else {
                vector.addElement(childFrame);
            }
            ++n;
        }
        this.parts = vector;
    }

    public void beginNextLevel(WebBrowserWindow webBrowserWindow, HTMLDocument hTMLDocument, int n, boolean bl) {
        ++this.levelcounter;
        if (this.levelcounter == 1) {
            this.currentbrowser = webBrowserWindow;
            this.document = hTMLDocument;
            this.updateIndex = 0;
        }
        if (!this.fComposing) {
            return;
        }
        HolderItem holderItem = new HolderItem(n, bl);
        if (this.levelcounter > 1) {
            holderItem.parentframe = this.currentitem.getNextEmptyFrame();
            holderItem.previtem = this.currentitem;
        }
        this.currentitem = holderItem;
    }

    public void endCurrentLevel() {
        --this.levelcounter;
        if (this.fComposing) {
            this.currentitem = this.currentitem.previtem;
        }
        if (this.levelcounter == 0) {
            this.createBorderPanel();
            this.fComposing = false;
        }
    }

    public void addEmptyFrame(Rectangle rectangle, int n, int n2, int n3, int n4) {
        if (this.fComposing) {
            this.currentitem.addEmptyFrame(rectangle, n, n2, n3, n4);
            ++this.updateIndex;
            return;
        }
        this.updateFrame(rectangle);
        ++this.updateIndex;
        if (this.updateIndex == this.parts.size()) {
            this.updateIndex = 0;
            this.createBorderPanel();
            Rectangle rectangle2 = this.currentbrowser.getBounds();
            this.currentclient.redrawBackground(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        }
    }

    public void updateFrame(Rectangle rectangle) {
        if (this.parts == null) {
            return;
        }
        int n = 0;
        while (n < this.parts.size()) {
            ChildFrame childFrame = (ChildFrame)this.parts.elementAt(n);
            if (this.currentbrowser == childFrame.topbrowser && this.updateIndex == childFrame.ID) {
                childFrame.framerct = rectangle;
                childFrame.updateBorderRect();
                return;
            }
            ++n;
        }
    }

    public void setFrameAttrs(String string, int n, int n2, int n3, boolean bl) {
        this.currentitem.setFrameAttrs(string, n, n2, n3, bl);
    }

    public synchronized WebBrowserWindow getBrowserByName(String string, WebBrowserWindow webBrowserWindow) {
        if (string == null) {
            return null;
        }
        if (string.equals("_top")) {
            return this.rootbrowser;
        }
        if (string.equals("_self")) {
            return webBrowserWindow;
        }
        if (string.equals("_blank")) {
            return null;
        }
        if (this.parts == null) {
            return null;
        }
        WebBrowserWindow webBrowserWindow2 = null;
        if (!string.equals("_parent") && this.findBrowser(string, webBrowserWindow2 = this.findBrowser(string, null)) == null) {
            return webBrowserWindow2;
        }
        int n = 0;
        while (n < this.parts.size()) {
            ChildFrame childFrame = (ChildFrame)this.parts.elementAt(n);
            if (childFrame.browser == webBrowserWindow) {
                if (string.equals("_parent")) {
                    return childFrame.topbrowser;
                }
                return this.findBrowser(string, childFrame.topbrowser);
            }
            ++n;
        }
        return null;
    }

    public synchronized WebBrowserWindow findBrowser(String string, WebBrowserWindow webBrowserWindow) {
        boolean bl = webBrowserWindow == null;
        int n = 0;
        while (n < this.parts.size()) {
            ChildFrame childFrame = (ChildFrame)this.parts.elementAt(n);
            if (bl) {
                if (string.equals(childFrame.name)) {
                    return childFrame.browser;
                }
            } else if (webBrowserWindow == childFrame.browser) {
                bl = true;
            }
            ++n;
        }
        return null;
    }

    public synchronized WebBrowserWindow getBrowserByFrame(Rectangle rectangle) {
        if (this.parts == null) {
            return null;
        }
        int n = 0;
        while (n < this.parts.size()) {
            ChildFrame childFrame = (ChildFrame)this.parts.elementAt(n);
            if (rectangle.equals(childFrame.framerct)) {
                return childFrame.browser;
            }
            ++n;
        }
        return null;
    }

    public synchronized Rectangle InternalRect(WebBrowserWindow webBrowserWindow, Rectangle rectangle) {
        int n;
        Rectangle rectangle2 = rectangle;
        ChildFrame childFrame = null;
        boolean bl = false;
        if (this.parts != null) {
            n = 0;
            while (n < this.parts.size()) {
                childFrame = (ChildFrame)this.parts.elementAt(n);
                if (webBrowserWindow == childFrame.browser) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        if (bl) {
            n = childFrame.getLine(0);
            if (n > 0) {
                rectangle2.x += n / 2;
                rectangle2.width -= n / 2;
            }
            if ((n = childFrame.getLine(1)) > 0) {
                rectangle2.y += n / 2;
                rectangle2.height -= n / 2;
            }
            if ((n = childFrame.getLine(2)) > 0) {
                rectangle2.width -= n / 2;
            }
            if ((n = childFrame.getLine(3)) > 0) {
                rectangle2.height -= n / 2;
            }
        }
        return rectangle2;
    }

    public void createBorderPanel() {
        HTMLDocumentWindow hTMLDocumentWindow = null;
        Dimension dimension = this.currentbrowser.getSize();
        Image image = this.currentbrowser.createImage(dimension.width, dimension.height);
        if (image == null) {
            return;
        }
        Graphics graphics = image.getGraphics();
        if (graphics == null) {
            return;
        }
        graphics.setColor(Color.darkGray);
        int n = 0;
        while (n < this.borders.size()) {
            BorderItem borderItem = (BorderItem)this.borders.elementAt(n);
            if (borderItem != null && borderItem.visible) {
                Rectangle rectangle = borderItem.rect;
                hTMLDocumentWindow = borderItem.html;
                if (borderItem.vertical) {
                    graphics.fill3DRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
                } else {
                    graphics.fill3DRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
                }
                if (hTMLDocumentWindow != null) {
                    hTMLDocumentWindow.setBackgroundImage(image);
                }
            }
            ++n;
        }
    }

    class HolderItem {
        String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
        Vector childlist = new Vector();
        int border;
        boolean frameborder;
        HolderItem previtem;
        ChildFrame parentframe;
        private int index;

        public HolderItem(int n, boolean bl) {
            BrowserHolder.this = BrowserHolder.this;
            this.border = n;
            this.frameborder = bl;
            this.index = 0;
        }

        public void addEmptyFrame(Rectangle rectangle, int n, int n2, int n3, int n4) {
            ChildFrame childFrame = new ChildFrame(rectangle, this, n, n2, n3, n4);
            this.childlist.addElement(childFrame);
            BrowserHolder.this.parts.addElement(childFrame);
        }

        public synchronized void setHTMLClient(WebBrowserWindow webBrowserWindow, HTMLDocumentWindow hTMLDocumentWindow, Rectangle rectangle) {
            int n = 0;
            while (n < this.childlist.size()) {
                ChildFrame childFrame = (ChildFrame)this.childlist.elementAt(n);
                if (rectangle.equals(childFrame.framerct)) {
                    childFrame.setBrowser(webBrowserWindow, hTMLDocumentWindow);
                    this.index = n;
                    return;
                }
                ++n;
            }
        }

        public void setFrameAttrs(String string, int n, int n2, int n3, boolean bl) {
            ChildFrame childFrame = (ChildFrame)this.childlist.elementAt(this.index);
            if (childFrame != null) {
                childFrame.setFrameAttrs(string, n, n2, n3, bl);
            }
        }

        public synchronized ChildFrame getNextEmptyFrame() {
            int n = 0;
            while (n < this.childlist.size()) {
                ChildFrame childFrame = (ChildFrame)this.childlist.elementAt(n);
                if (childFrame.isEmpty()) {
                    return childFrame;
                }
                ++n;
            }
            return null;
        }
    }

    class ChildFrame {
        String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
        int ID;
        boolean fEmpty;
        Rectangle framerct;
        String name;
        WebBrowserWindow browser;
        WebBrowserWindow topbrowser;
        HTMLDocumentWindow html;
        HTMLDocumentWindow tophtml;
        int width;
        int height;
        int scroll;
        HolderItem parentitem;
        int[] side;
        boolean vertical;
        BorderItem borderitem;

        public ChildFrame(Rectangle rectangle, HolderItem holderItem, int n, int n2, int n3, int n4) {
            BrowserHolder.this = BrowserHolder.this;
            this.ID = BrowserHolder.this.updateIndex;
            this.fEmpty = true;
            this.framerct = rectangle;
            this.parentitem = holderItem;
            this.borderitem = null;
            this.topbrowser = BrowserHolder.this.currentbrowser;
            this.tophtml = BrowserHolder.this.currentclient;
            this.vertical = false;
            if (n3 > 0) {
                this.vertical = true;
            }
            this.side = new int[4];
            int n5 = this.parentitem.border;
            this.side[0] = n > 0 ? n5 : 0;
            this.side[1] = n2 > 0 ? n5 : 0;
            this.side[2] = n < n3 - 1 ? n5 : 0;
            this.side[3] = n2 < n4 - 1 ? n5 : 0;
            ChildFrame childFrame = this.parentitem.parentframe;
            if (childFrame != null) {
                int n6 = 0;
                while (n6 < 4) {
                    if (childFrame.getLine(n6) > 0) {
                        this.side[n6] = childFrame.getLine(n6);
                    }
                    ++n6;
                }
            }
            if (n3 > 0 && n3 - 1 > n && this.side[2] > 0) {
                Rectangle rectangle2 = new Rectangle(this.framerct.x + this.framerct.width - this.side[2] / 2, this.framerct.y, this.side[2], this.framerct.height);
                Vector vector = BrowserHolder.this.borders;
                BrowserHolder browserHolder2 = BrowserHolder.this;
                browserHolder2.getClass();
                this.borderitem = browserHolder2.new BorderItem(this.tophtml, rectangle2, this.parentitem.frameborder, true);
                vector.addElement(this.borderitem);
            }
            if (n4 > 0 && n4 - 1 > n2 && this.side[3] > 0) {
                Rectangle rectangle3 = new Rectangle(this.framerct.x, this.framerct.y + this.framerct.height - this.side[3] / 2, this.framerct.width, this.side[3]);
                Vector vector = BrowserHolder.this.borders;
                BrowserHolder browserHolder3 = BrowserHolder.this;
                browserHolder3.getClass();
                this.borderitem = browserHolder3.new BorderItem(this.tophtml, rectangle3, this.parentitem.frameborder, false);
                vector.addElement(this.borderitem);
            }
        }

        public void updateBorderRect() {
            if (this.borderitem == null) {
                return;
            }
            Rectangle rectangle = this.borderitem.vertical ? new Rectangle(this.framerct.x + this.framerct.width - this.side[2] / 2, this.framerct.y, this.side[2], this.framerct.height) : new Rectangle(this.framerct.x, this.framerct.y + this.framerct.height - this.side[3] / 2, this.framerct.width, this.side[3]);
            this.borderitem.rect = rectangle;
        }

        public void setFrameAttrs(String string, int n, int n2, int n3, boolean bl) {
            this.name = string;
            this.height = n2;
            this.width = n;
            this.scroll = n3;
            if (n2 != 10) {
                this.html.setTopMargin(n2);
                this.html.setBottomMargin(n2);
            }
            if (n != 20) {
                this.html.setLeftMargin(n);
                this.html.setRightMargin(n);
            }
            if (n3 != 0) {
                this.browser.setScrolling(n3);
            }
            if (!bl && this.borderitem != null) {
                this.borderitem.setNoResize();
            }
        }

        public void restoreFrameAttrs() {
            this.html.setTopMargin(this.height);
            this.html.setBottomMargin(this.height);
            this.html.setLeftMargin(this.width);
            this.html.setRightMargin(this.width);
            this.browser.setScrolling(this.scroll);
        }

        public void setBrowser(WebBrowserWindow webBrowserWindow, HTMLDocumentWindow hTMLDocumentWindow) {
            this.browser = webBrowserWindow;
            this.html = hTMLDocumentWindow;
            this.fEmpty = false;
        }

        public boolean isEmpty() {
            return this.fEmpty;
        }

        public int getLine(int n) {
            return this.side[n];
        }
    }

    class BorderItem {
        String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
        Rectangle rect;
        boolean visible;
        boolean vertical;
        boolean resize;
        HTMLDocumentWindow html;

        public BorderItem(HTMLDocumentWindow hTMLDocumentWindow, Rectangle rectangle, boolean bl, boolean bl2) {
            BrowserHolder.this = BrowserHolder.this;
            this.html = hTMLDocumentWindow;
            this.rect = rectangle;
            this.visible = bl;
            this.vertical = bl2;
            this.resize = true;
        }

        public void setNoResize() {
            this.resize = false;
        }
    }
}

