/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.netdiver.browser;

import COM.ibm.netdiver.browser.BrowserContext;
import COM.ibm.netdiver.browser.ConcreateAudioClip;
import COM.ibm.netdiver.browser.GenericAppletContext;
import COM.ibm.netdiver.browser.HTMLDocument;
import COM.ibm.netdiver.browser.HTMLLayout;
import COM.ibm.netdiver.browser.MapGlobalContext;
import COM.ibm.netdiver.browser.NdSecurityManager;
import COM.ibm.netdiver.browser.item.AppletItem;
import COM.ibm.netdiver.browser.item.FragmentItem;
import COM.ibm.netdiver.browser.tag.lib.AnchorContext;
import COM.ibm.netdiver.browser.tag.lib.ArchiveContext;
import COM.ibm.netdiver.browser.tag.lib.ImageContext;
import COM.ibm.netdiver.gui.Item;
import COM.ibm.netdiver.gui.ItemList;
import COM.ibm.netdiver.gui.ItemPane;
import COM.ibm.netdiver.gui.ItemPaneContainer;
import COM.ibm.netdiver.gui.LayoutClient;
import COM.ibm.netdiver.gui.LayoutException;
import COM.ibm.netdiver.gui.ScrollClient;
import COM.ibm.netdiver.gui.TextDrawingContext;
import COM.ibm.netdiver.gui.TextStyleContext;
import COM.ibm.netdiver.gui.Tracker;
import COM.ibm.netdiver.gui.TrackerClient;
import COM.ibm.netdiver.gui.WebBrowserWindow;
import COM.ibm.netdiver.gui.WebContent;
import COM.ibm.netdiver.gui.item.ComponentItem;
import COM.ibm.netdiver.gui.item.GraphicItem;
import COM.ibm.netdiver.gui.item.ImageItem;
import COM.ibm.netdiver.gui.item.OnLoadItem;
import COM.ibm.netdiver.net.MalformedURIException;
import COM.ibm.netdiver.net.URI;
import java.applet.AppletContext;
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.util.Enumeration;
import java.util.Vector;

public class HTMLDocumentWindow
extends ItemPaneContainer
implements TextDrawingContext,
WebContent,
ScrollClient,
TrackerClient {
    String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
    private HTMLDocument document;
    private TextStyleContext textStyleContext;
    private WebBrowserWindow browser;
    private GenericAppletContext appletContext;
    private ConcreateAudioClip audioClip;
    private Tracker tracker;
    private AnchorContext anchorContext;
    private Image background;
    private ItemList backgrounds;
    private Dimension onloadbgimage;
    private HTMLItemList itemList;
    private String linkFragment;

    public HTMLDocumentWindow(WebBrowserWindow webBrowserWindow) {
        this.browser = webBrowserWindow;
        this.appletContext = new GenericAppletContext(this);
        this.textStyleContext = new TextStyleContext(this);
        this.tracker = new Tracker(this);
        this.addMouseListener(this.tracker);
        this.addMouseMotionListener(this.tracker);
    }

    public AppletContext getAppletContext() {
        return this.appletContext;
    }

    public AudioClip getAudioClip() {
        if (this.audioClip == null) {
            this.audioClip = new ConcreateAudioClip();
        }
        return this.audioClip;
    }

    public WebBrowserWindow browser() {
        return this.browser;
    }

    public Image getBackgroundImage() {
        return this.background;
    }

    public void setBackgroundImage(Image image) {
        this.background = image;
    }

    private void clearBackgroundImage() {
        this.background = null;
        this.backgrounds = null;
    }

    private void layoutBackgroundImage(int n, int n2) {
        if (this.background != null) {
            this.backgrounds = new ItemList();
            int n3 = this.background.getWidth(this);
            int n4 = this.background.getHeight(this);
            if (n3 <= 0 || n4 <= 0) {
                this.onloadbgimage = new Dimension(n, n2);
                return;
            }
            this.onloadbgimage = null;
            try {
                int n5 = 0;
                while (n5 < n) {
                    int n6 = 0;
                    while (n6 < n2) {
                        ImageItem imageItem = new ImageItem(this.background, this);
                        this.backgrounds.addItem(imageItem);
                        imageItem.locate(n5, n6);
                        n6 += n4;
                    }
                    n5 += n3;
                }
                return;
            }
            catch (LayoutException layoutException) {
                return;
            }
        }
    }

    public synchronized Dimension layoutContents(Rectangle rectangle) {
        try {
            this.itemList = new HTMLItemList();
            Dimension dimension = this.layoutDocument(this.itemList, new Dimension(rectangle.width, -1), rectangle);
            this.setLogicalSize(dimension.width, dimension.height);
            if (!this.itemList.hasOnLoadItem()) {
                Enumeration enumeration = this.itemList.appletItems();
                while (enumeration.hasMoreElements()) {
                    ((AppletItem)enumeration.nextElement()).setInitializable();
                }
            }
            this.setItemList(this.itemList);
            return dimension;
        }
        catch (LayoutException layoutException) {
            return new Dimension(0, 0);
        }
    }

    private Dimension layoutDocument(LayoutClient layoutClient, Dimension dimension, Rectangle rectangle) throws LayoutException {
        Object object;
        Object object2;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && securityManager instanceof NdSecurityManager) {
            ((NdSecurityManager)securityManager).resetHostOriginatingApplet();
            object2 = System.getProperty("proxy.http");
            if (object2 != null) {
                try {
                    object = new URI((String)object2);
                    if (object != null) {
                        ((NdSecurityManager)securityManager).setHostOriginatingApplet(((URI)object).getHost());
                    }
                }
                catch (MalformedURIException malformedURIException) {}
            }
        }
        this.clearBackgroundImage();
        object2 = this;
        if (this.document == null) {
            return new Dimension(((ItemPane)object2).leftMargin() + ((ItemPane)object2).rightMargin(), ((ItemPane)object2).topMargin() + ((ItemPane)object2).bottomMargin());
        }
        if (this.document.isFrameContainer()) {
            ((ItemPane)object2).setEmptyMargin();
        } else if (this.browser == this.browser.holder().browser()) {
            ((ItemPane)object2).setDefaultMargin();
        }
        object = new Rectangle(((ItemPane)object2).leftMargin(), ((ItemPane)object2).topMargin(), dimension.width - ((ItemPane)object2).leftMargin() - ((ItemPane)object2).rightMargin(), dimension.height - ((ItemPane)object2).topMargin() - ((ItemPane)object2).bottomMargin());
        Dimension dimension2 = new Dimension(rectangle.width - ((ItemPane)object2).leftMargin() - ((ItemPane)object2).rightMargin(), rectangle.height - ((ItemPane)object2).topMargin() - ((ItemPane)object2).bottomMargin());
        HTMLLayout hTMLLayout = new HTMLLayout(layoutClient);
        this.appletContext.clear();
        this.anchorContext = new AnchorContext(this.document);
        ImageContext imageContext = new ImageContext(hTMLLayout);
        MapGlobalContext mapGlobalContext = new MapGlobalContext(layoutClient);
        ArchiveContext archiveContext = new ArchiveContext(this.document);
        hTMLLayout.pushContext(archiveContext);
        hTMLLayout.pushContext(mapGlobalContext);
        hTMLLayout.pushContext(this.anchorContext);
        hTMLLayout.pushContext(imageContext);
        hTMLLayout.pushContext(new BrowserContext(this, dimension2, this.browser.holder()));
        hTMLLayout.pushContext(new TextStyleContext(this.textStyleContext));
        hTMLLayout.layout(this.document.getRoot(), (Rectangle)object);
        mapGlobalContext.attachClickableToMap();
        Dimension dimension3 = new Dimension(hTMLLayout.width() + ((ItemPane)object2).rightMargin(), hTMLLayout.y() + ((ItemPane)object2).bottomMargin());
        this.layoutBackgroundImage(Math.max(dimension3.width, rectangle.width), Math.max(dimension3.height, rectangle.height));
        return dimension3;
    }

    public Enumeration trackingItems(Point point) {
        return this.items.elements(4, point);
    }

    public void componentResized(ComponentEvent componentEvent) {
        super.componentResized(componentEvent);
        this.browser.updateScrollbar();
    }

    public synchronized void setItemList(ItemList itemList) {
        this.tracker.release();
        super.setItemList(itemList);
    }

    public Rectangle redrawBackground(int n, int n2, int n3, int n4) {
        Rectangle rectangle = super.redrawBackground(n, n2, n3, n4);
        if (this.backgrounds != null) {
            Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            try {
                Enumeration enumeration = this.backgrounds.elements(1, rectangle);
                while (enumeration.hasMoreElements()) {
                    GraphicItem graphicItem = (GraphicItem)enumeration.nextElement();
                    graphicItem.draw(this);
                    rectangle2 = rectangle2.union(graphicItem);
                }
                return rectangle2;
            }
            catch (NullPointerException nullPointerException) {
            }
        }
        return rectangle;
    }

    public TextStyleContext textStyleContext() {
        return this.textStyleContext;
    }

    public synchronized void setContent(Object object) {
        if (object != null) {
            HTMLDocument hTMLDocument = this.document;
            this.document = (HTMLDocument)object;
            String string = this.document.getTitle() != null ? this.document.getTitle() : (hTMLDocument != null ? hTMLDocument.getNextTitle() : null);
            this.browser.wwwClient().setTitle(string != null ? string : "");
            this.initOffsets();
        }
    }

    public void refresh() {
        if (this.document == null) {
            return;
        }
        this.setForeground(this.document.getTextColor() != null ? this.document.getTextColor() : Color.black);
        this.setBackground(this.document.getBackgroundColor() != null ? this.document.getBackgroundColor() : Color.lightGray);
        this.browser.setBackground(this.getBackground());
        if (this.onloadbgimage != null) {
            this.layoutBackgroundImage(this.onloadbgimage.width, this.onloadbgimage.height);
        }
        if (this.linkFragment != null) {
            this.gotoFragment(this.linkFragment);
            return;
        }
        this.browser.updateScrollbar();
        this.redraw();
    }

    public void settle() {
        Enumeration enumeration = this.items.elements(2);
        while (enumeration.hasMoreElements()) {
            ((ComponentItem)enumeration.nextElement()).destroy();
        }
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return (n & 0xA0) == 0;
    }

    public void setLinkFragment(String string) {
        this.linkFragment = string;
    }

    public void gotoFragment(String string) {
        FragmentItem fragmentItem = this.anchorContext.getFragment(string);
        if (fragmentItem != null) {
            this.scrollToY(fragmentItem.y() - 5);
            this.browser.updateScrollbar();
            this.redraw();
        }
    }

    public void updateScrollbar() {
        this.browser.updateScrollbar();
    }

    public void setAnchorItem(LayoutClient layoutClient) {
        this.itemList.setAnchorItem(layoutClient);
    }

    public void setFragmentItem(LayoutClient layoutClient) {
        this.itemList.setFragmentItem(layoutClient);
    }

    final class HTMLItemList
    extends ItemList {
        String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
        private boolean hasOnLoadItem = false;
        private Vector appletItems = new Vector();
        private LayoutClient anchorItem;
        private LayoutClient fragmentItem;

        public void addItem(Item item) throws LayoutException {
            if (this.anchorItem != null) {
                this.anchorItem.addItem(item);
            }
            if (this.fragmentItem != null) {
                this.fragmentItem.addItem(item);
            }
            super.addItem(item);
            if (item instanceof OnLoadItem) {
                this.hasOnLoadItem = true;
                return;
            }
            if (item instanceof AppletItem) {
                this.appletItems.addElement(item);
            }
        }

        public Enumeration appletItems() {
            return this.appletItems.elements();
        }

        public boolean hasOnLoadItem() {
            return this.hasOnLoadItem;
        }

        public void setAnchorItem(LayoutClient layoutClient) {
            this.anchorItem = layoutClient;
        }

        public void setFragmentItem(LayoutClient layoutClient) {
            this.fragmentItem = layoutClient;
        }

        HTMLItemList() {
            HTMLDocumentWindow.this = HTMLDocumentWindow.this;
        }
    }
}

