/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.netdiver.browser;

import COM.ibm.netdiver.browser.SecurityParameters;
import COM.ibm.netdiver.net.GenericClassLoader;
import COM.ibm.netdiver.net.UserClient;
import COM.ibm.netdiver.util.MessageResourceBundle;
import java.io.FileDescriptor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;

public class NdSecurityManager
extends SecurityManager {
    String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
    private Vector params;
    private UserClient client;
    public static final int CATEGORY_STANDALONE = 0;
    public static final int CATEGORY_LOCALAPPLET = 1;
    public static final int CATEGORY_REMOTEAPPLET = 2;
    public static final int CHECK_Accept = 0;
    public static final int CHECK_Access = 1;
    public static final int CHECK_Connect = 2;
    public static final int CHECK_CreateClassLoader = 3;
    public static final int CHECK_Delete = 4;
    public static final int CHECK_Exec = 5;
    public static final int CHECK_Exit = 6;
    public static final int CHECK_Link = 7;
    public static final int CHECK_Listen = 8;
    public static final int CHECK_PackageAccess = 9;
    public static final int CHECK_PackageDefinition = 10;
    public static final int CHECK_PropertiesAccess = 11;
    public static final int CHECK_PropertyAccess = 12;
    public static final int CHECK_ReadFD = 13;
    public static final int CHECK_Read = 14;
    public static final int CHECK_SetFactory = 15;
    public static final int CHECK_TopLevelWindow = 16;
    public static final int CHECK_WriteFD = 17;
    public static final int CHECK_Write = 18;
    public static final int CHECK_AwtEventQueueAccess = 19;
    public static final int CHECK_MemberAccess = 20;
    public static final int CHECK_Multicast = 21;
    public static final int CHECK_PrintJobAccess = 22;
    public static final int CHECK_SecurityAccess = 23;
    public static final int CHECK_SystemClipboardAccess = 24;
    private MessageResourceBundle rb = MessageResourceBundle.getResource("COM.ibm.netdiver.app.res.SecurityDialogMessage");
    private String documentScheme;
    private Vector originatingHosts = new Vector();
    private Vector permittedLibraries = new Vector();

    public NdSecurityManager() {
        this.params = new Vector();
    }

    public void checkAccept(String string, int n) {
        if (!this.permit(0)) {
            this.setMessage(this.rb.getFixedString("CHK_ACCEPT", ""));
            throw new SecurityException();
        }
    }

    public void checkAccess(Thread thread) {
        if (!this.permit(1) && this.isRemoteApplet()) {
            Thread thread2 = Thread.currentThread();
            if (thread.getThreadGroup() != thread2.getThreadGroup()) {
                this.setMessage(this.rb.getFixedString("CHK_ACCESS", ""));
                throw new SecurityException();
            }
        }
    }

    public void checkAccess(ThreadGroup threadGroup) {
        Thread thread;
        if (!this.permit(1) && this.isRemoteApplet() && threadGroup != (thread = Thread.currentThread()).getThreadGroup()) {
            this.setMessage(this.rb.getFixedString("CHK_ACCESS", ""));
            throw new SecurityException();
        }
    }

    public void checkConnect(String string, int n) {
        this.checkConnect(string, n, null);
    }

    public void checkConnect(String string, int n, Object object) {
        this.inCheck = true;
        if (!this.permit(2) && this.isRemoteApplet() && this.is3rdHost(string)) {
            this.inCheck = false;
            this.setMessage(this.rb.getFixedString("CHK_3RDHOSTPORT", ""));
            throw new SecurityException();
        }
        this.inCheck = false;
    }

    public void checkCreateClassLoader() {
        if (!this.permit(3)) {
            this.setMessage(this.rb.getFixedString("CHK_CLASSLOADER", ""));
            throw new SecurityException();
        }
    }

    public void checkDelete(String string) {
        if (!this.permit(4)) {
            this.setMessage(this.rb.getFixedString("CHK_D_LOCALFILE", ""));
            throw new SecurityException();
        }
    }

    public void checkExec(String string) {
        if (!this.permit(5)) {
            this.setMessage(this.rb.getFixedString("CHK_EXEC", ""));
            throw new SecurityException();
        }
    }

    public void checkExit(int n) {
        if (!this.permit(6)) {
            this.setMessage(this.rb.getFixedString("CHK_CALLSYSEXIT", ""));
            throw new SecurityException();
        }
    }

    public void checkLink(String string) {
        if (!this.permit(7) && this.isRemoteApplet() && !this.permittedLibraries.contains(string)) {
            this.setMessage(this.rb.getFixedString("CHK_L_DYNAMICLIB", ""));
            throw new SecurityException();
        }
    }

    public void checkListen(int n) {
        if (!this.permit(8)) {
            this.setMessage(this.rb.getFixedString("CHK_LISTEN", ""));
            throw new SecurityException();
        }
    }

    public void checkPackageAccess(String string) {
        this.permit(9);
    }

    public void checkPackageDefinition(String string) {
        this.permit(10);
    }

    public void checkPropertiesAccess() {
        if (!this.permit(11)) {
            this.setMessage(this.rb.getFixedString("CHK_R_ALLSYSPROPERTIES", ""));
            throw new SecurityException();
        }
    }

    public void checkPropertyAccess(String string) {
        try {
            this.checkPropertiesAccess();
            return;
        }
        catch (SecurityException securityException) {
            if (!this.permit(12) && this.isRemoteApplet() && (string.equals("java.home") || string.equals("java.class.path") || string.equals("user.name") || string.equals("user.home") || string.equals("user.dir"))) {
                this.setMessage(this.rb.getFixedString("CHK_R_ALLSYSPROPERTIES", ""));
                throw new SecurityException();
            }
            return;
        }
    }

    public void checkRead(FileDescriptor fileDescriptor) {
        this.permit(13);
    }

    public void checkRead(String string) {
        this.checkRead(string, null);
    }

    public void checkRead(String string, Object object) {
        if (!this.permit(14)) {
            this.setMessage(this.rb.getFixedString("CHK_R_LOCALFILE", ""));
            throw new SecurityException();
        }
    }

    public void checkSetFactory() {
        if (!this.permit(15)) {
            this.setMessage(this.rb.getFixedString("CHK_SET_FACTORY", ""));
            throw new SecurityException();
        }
    }

    public boolean checkTopLevelWindow(Object object) {
        if (!this.permit(16)) {
            return !this.isRemoteApplet();
        }
        return true;
    }

    public void checkWrite(FileDescriptor fileDescriptor) {
        this.permit(17);
    }

    public void checkWrite(String string) {
        if (!this.permit(18)) {
            this.setMessage(this.rb.getFixedString("CHK_W_LOCALFILE", ""));
            throw new SecurityException();
        }
    }

    public void setSecurityParameters(SecurityParameters securityParameters) {
        if (this.isRemoteApplet()) {
            throw new SecurityException();
        }
        int n = this.indexOf(securityParameters.category());
        if (n != -1) {
            this.params.removeElementAt(n);
        }
        this.params.addElement(securityParameters);
    }

    public SecurityParameters getSecurityParameters(int n) {
        if (this.isRemoteApplet()) {
            throw new SecurityException();
        }
        return this.getSecurityParametersInternal(n);
    }

    public void setClient(UserClient userClient) {
        this.client = userClient;
    }

    private void setMessage(String string) {
        if (this.client == null || string == null) {
            return;
        }
        this.client.setStatus(string);
    }

    private SecurityParameters getSecurityParametersInternal(int n) {
        int n2 = 0;
        while (n2 < this.params.size()) {
            SecurityParameters securityParameters = (SecurityParameters)this.params.elementAt(n2);
            if (securityParameters.category() == n) {
                return securityParameters;
            }
            ++n2;
        }
        return null;
    }

    private boolean permit(int n) {
        SecurityParameters securityParameters = this.getSecurityParametersInternal(this.category());
        if (securityParameters != null) {
            return securityParameters.permit(n);
        }
        return true;
    }

    private int category() {
        if (this.inClassLoader() && this.currentClassLoader() instanceof GenericClassLoader) {
            if (this.documentScheme == null || !this.documentScheme.equals("file")) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    private boolean isRemoteApplet() {
        return this.category() == 2;
    }

    private boolean isLocalApplet() {
        return this.category() == 1;
    }

    private int indexOf(int n) {
        int n2 = 0;
        while (n2 < this.params.size()) {
            SecurityParameters securityParameters = (SecurityParameters)this.params.elementAt(n2);
            if (securityParameters.category() == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public void setDocumentScheme(String string) {
        if (this.isRemoteApplet()) {
            throw new SecurityException();
        }
        this.documentScheme = string != null ? string.toLowerCase() : null;
    }

    public void setHostOriginatingApplet(String string) {
        if (this.isRemoteApplet()) {
            throw new SecurityException();
        }
        if (string != null && !this.originatingHosts.contains(string)) {
            this.originatingHosts.addElement(string);
        }
    }

    public void resetHostOriginatingApplet() {
        if (this.isRemoteApplet()) {
            throw new SecurityException();
        }
        this.originatingHosts.removeAllElements();
    }

    public boolean is3rdHost(String string) {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return true;
        }
        Enumeration enumeration = this.originatingHosts.elements();
        while (enumeration.hasMoreElements()) {
            InetAddress inetAddress2 = null;
            String string2 = (String)enumeration.nextElement();
            try {
                inetAddress2 = InetAddress.getByName(string2);
            }
            catch (UnknownHostException unknownHostException) {
                continue;
            }
            if (!inetAddress.equals(inetAddress2)) continue;
            return false;
        }
        return true;
    }

    public void setPermittedLibrary(String string) {
        if (this.isRemoteApplet()) {
            throw new SecurityException();
        }
        if (string != null && !this.permittedLibraries.contains(string)) {
            this.permittedLibraries.addElement(string);
        }
    }

    private void printStringVector(Vector vector, String string) {
        System.out.println("");
        System.out.println("************************************************");
        if (string != null) {
            System.out.println(string);
            System.out.println("");
        }
        int n = 0;
        while (n < vector.size()) {
            System.out.println("[" + n + "]=" + (String)vector.elementAt(n));
            ++n;
        }
        System.out.println("************************************************");
    }
}

