/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.netdiver.browser;

import COM.ibm.netdiver.util.Vector;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;

public abstract class SecurityParameters {
    String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
    private int category;
    private Vector checks;
    private String file;
    private static final String CHECK_ID = "&%$#C:";
    private static final String VALUE_ID = "&%$#V:";
    private static final int VALUE_TRUE = 7;
    private static final int VALUE_FALSE = 4;
    private static final String PROPERTIES = "COM.ibm.netdiver.netdiver.props";

    public SecurityParameters(int n, String string) {
        this.category = n;
        this.checks = new Vector();
        if (System.getProperty(PROPERTIES) != null && string != null) {
            this.file = String.valueOf(System.getProperty(PROPERTIES)) + System.getProperty("file.separator") + string;
        }
        this.initialize();
    }

    public int category() {
        return this.category;
    }

    public boolean permit(int n) {
        int n2 = this.indexOf(n);
        if (n2 == -1) {
            return true;
        }
        return ((SecurityParameterElement)this.checks.elementAt(n2)).permit();
    }

    public void setCheck(int n, boolean bl) {
        int n2 = this.indexOf(n);
        if (n2 == -1) {
            this.checks.addElement(new SecurityParameterElement(n, bl));
            return;
        }
        ((SecurityParameterElement)this.checks.elementAt(n2)).changePermit(bl);
    }

    public void saveToFile() {
        if (this.file != null) {
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(this.file);
            }
            catch (IOException iOException) {
                return;
            }
            DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
            Enumeration enumeration = this.checks.elements();
            while (enumeration.hasMoreElements()) {
                SecurityParameterElement securityParameterElement = (SecurityParameterElement)enumeration.nextElement();
                if (securityParameterElement == null) continue;
                try {
                    dataOutputStream.writeUTF(CHECK_ID + securityParameterElement.check());
                    dataOutputStream.writeUTF(VALUE_ID + (securityParameterElement.permit() ? 7 : 4));
                }
                catch (IOException iOException) {
                    break;
                }
            }
            try {
                dataOutputStream.close();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    private int indexOf(int n) {
        int n2 = 0;
        while (n2 < this.checks.size()) {
            SecurityParameterElement securityParameterElement = (SecurityParameterElement)this.checks.elementAt(n2);
            if (securityParameterElement.check() == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    protected void initialize() {
        this.initializeDefault();
        if (this.file != null) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(this.file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return;
            }
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            while (true) {
                String string = null;
                String string2 = null;
                try {
                    string = dataInputStream.readUTF();
                    string2 = dataInputStream.readUTF();
                }
                catch (IOException iOException) {
                    break;
                }
                if (string == null || string2 == null || !string.startsWith(CHECK_ID) || !string2.startsWith(VALUE_ID)) break;
                int n = 0;
                boolean bl = false;
                try {
                    n = Integer.parseInt(string.substring(CHECK_ID.length()));
                    bl = Integer.parseInt(string2.substring(VALUE_ID.length())) == 7;
                }
                catch (NumberFormatException numberFormatException) {
                    break;
                }
                this.setCheck(n, bl);
            }
            try {
                dataInputStream.close();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    protected abstract void initializeDefault();

    final class SecurityParameterElement {
        String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
        private int check;
        private boolean permit;

        public SecurityParameterElement(int n, boolean bl) {
            SecurityParameters.this = SecurityParameters.this;
            this.check = n;
            this.permit = bl;
        }

        public int check() {
            return this.check;
        }

        public boolean permit() {
            return this.permit;
        }

        public void changePermit(boolean bl) {
            this.permit = bl;
        }
    }
}

