/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.netdiver.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

public class BarLevelMeter
extends Canvas
implements Runnable {
    String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
    public static final int RED = 0;
    public static final int GREEN = 1;
    public static final int YELLOW = 2;
    private static final int UNIT = 2;
    private static final int CORE_WIDTH = 12;
    private static final int CORE_HEIGHT = 2;
    private static final int EDGE_WIDTH = 2;
    private static final int EDGE_HEIGHT = 2;
    private static final int WIDTH = 16;
    private static final int HEIGHT = 6;
    private static final int X_GAP = 2;
    private static final int Y_GAP = 2;
    private static final int X_MARGIN = 1;
    private static final int Y_MARGIN = 1;
    private static final int X_OQUPATION = 18;
    private static final int Y_OQUPATION = 8;
    private static final Color[][] colors = new Color[][]{{new Color(255, 0, 0), new Color(128, 0, 0)}, {new Color(0, 255, 0), new Color(0, 255, 0)}, {new Color(255, 255, 0), new Color(128, 128, 0)}};
    private static final int DEFAULT_NUM_DEVIDE = 5;
    private static final int DEFAULT_INTERVAL = 250;
    private int color_id;
    private int num_devide;
    private int interval;
    private int position;
    private boolean plus;
    private boolean running;

    public BarLevelMeter(int n, int n2, int n3) {
        this.color_id = n > 2 ? 2 : (n < 0 ? 0 : n);
        this.num_devide = n2 > 1 ? n2 : 5;
        this.interval = n3;
        this.position = 0;
        this.plus = true;
        this.running = false;
    }

    public BarLevelMeter() {
        this(0, 5, 250);
    }

    public void movePosition() {
        if (this.position == 0) {
            this.plus = true;
        }
        if (this.position == this.num_devide - 1) {
            this.plus = false;
        }
        this.position = this.plus ? ++this.position : --this.position;
        this.paint(this.getGraphics());
    }

    public void start() {
        this.running = true;
        this.notifyFor();
    }

    public void stop() {
        this.running = false;
    }

    public Dimension getMinimumSize() {
        return new Dimension(22, 12);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void paint(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        Dimension dimension = this.getSize();
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        int n = dimension.width / this.num_devide - 4;
        int n2 = dimension.width / this.num_devide * this.position;
        int n3 = (dimension.height - 6) / 2;
        graphics.setColor(colors[this.color_id][1]);
        graphics.fillRect(n2, n3, n, 6);
        graphics.setColor(colors[this.color_id][0]);
        graphics.fillRect(n2 + 2, n3 + 2, n - 4, 2);
    }

    public void update(Graphics graphics) {
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            this.processNext();
        }
    }

    private void processNext() {
        if (!this.running) {
            this.waitFor();
        }
        this.movePosition();
    }

    private synchronized void waitFor() {
        try {
            this.wait();
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    private synchronized void notifyFor() {
        this.notify();
    }
}

