/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.netdiver.gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;

public abstract class DoubleBufferingPanel
extends Panel
implements ComponentListener {
    String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
    private Image graphicBuffer;
    private Graphics graphics;
    private int offsetX;
    private int offsetY;
    protected Dimension physicalSize = new Dimension();
    protected Dimension logicalSize = new Dimension();
    private RedrawClerk clerk = new RedrawClerk(this);
    private ScrollClerk scroller;

    public DoubleBufferingPanel() {
        Thread thread = new Thread(this.clerk);
        thread.setPriority(4);
        thread.start();
        this.scroller = new ScrollClerk(this);
        thread = new Thread(this.scroller);
        thread.setPriority(4);
        thread.start();
        this.addComponentListener(this);
    }

    public abstract int dx();

    public abstract int dy();

    public abstract void updateScrollbar();

    public synchronized abstract void redraw(int var1, int var2, int var3, int var4);

    public void redraw() {
        this.clerk.redraw(new Rectangle(0, 0, this.physicalSize.width, this.physicalSize.height));
    }

    public void drawBuffer() {
        Graphics graphics = this.getGraphics();
        if (this.graphicBuffer != null && graphics != null) {
            graphics.drawImage(this.graphicBuffer, 0, 0, this);
        }
    }

    public void resetGraphicBuffer(int n, int n2) {
        this.graphics = null;
        this.graphicBuffer = null;
        if (n > 0 && n2 > 0) {
            this.graphicBuffer = this.createImage(n, n2);
        }
        if (this.graphicBuffer != null) {
            this.graphics = this.graphicBuffer.getGraphics();
        }
        this.physicalSize = this.getSize();
        this.notifyForGraphicBuffer();
    }

    private synchronized void waitForGraphicBuffer() {
        try {
            this.wait();
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    private synchronized void notifyForGraphicBuffer() {
        this.notify();
    }

    public void initOffsets() {
        this.offsetY = 0;
        this.offsetX = 0;
    }

    protected synchronized void scrollToX(int n) {
        this.scroll(n - this.offsetX, 0);
    }

    protected synchronized void scrollToY(int n) {
        this.scroll(0, n - this.offsetY);
    }

    protected synchronized void scroll(int n, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = n4 = this.physicalSize.width;
        int n10 = n3 = this.physicalSize.height;
        if (n < 0) {
            if (this.offsetX + n < 0) {
                n = -this.offsetX;
            }
            n6 = 0;
            n8 = 0;
            n9 = -n;
            n4 = this.physicalSize.width + n;
        } else if (n > 0) {
            if (this.offsetX + n + this.physicalSize.width > this.logicalSize.width) {
                n = this.logicalSize.width - this.offsetX - this.physicalSize.width;
            }
            n6 = n;
            n9 = this.physicalSize.width;
            n8 = n4 = this.physicalSize.width - n;
        }
        if (n2 < 0) {
            if (this.offsetY + n2 < 0) {
                n2 = -this.offsetY;
            }
            n5 = 0;
            n7 = 0;
            n10 = -n2;
            n3 = this.physicalSize.height + n2;
        } else if (n2 > 0) {
            if (this.offsetY + n2 + this.physicalSize.height > this.logicalSize.height) {
                n2 = this.logicalSize.height - this.offsetY - this.physicalSize.height;
            }
            n5 = n2;
            n10 = this.physicalSize.height;
            n7 = n3 = this.physicalSize.height - n2;
        }
        if (this.physicalSize.width >= this.logicalSize.width) {
            n = 0;
        }
        if (this.physicalSize.height >= this.logicalSize.height) {
            n2 = 0;
        }
        this.offsetX += n;
        this.offsetY += n2;
        this.clerk.scroll(-n, -n2);
        this.moveArea(n6, n5, n4, n3, -n, -n2);
        this.clerk.redraw(new Rectangle(n8, n7, n9 - n8, n10 - n7));
        this.waitForRedrawComplete();
    }

    public void moveArea(int n, int n2, int n3, int n4, int n5, int n6) {
        try {
            this.graphics().copyArea(n, n2, n3, n4, n5, n6);
            return;
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
    }

    public synchronized void waitForRedrawComplete() {
        this.updateScrollbar();
        try {
            this.wait();
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public synchronized void notifyRedrawComplete() {
        this.notify();
    }

    public void paint(Graphics graphics) {
        this.drawBuffer();
    }

    public int physicalX(int n) {
        return n - this.offsetX;
    }

    public int physicalY(int n) {
        return n - this.offsetY;
    }

    public Graphics graphics() throws NullPointerException {
        if (this.graphics == null) {
            this.waitForGraphicBuffer();
            if (this.graphics == null) {
                throw new NullPointerException();
            }
        }
        return this.graphics;
    }

    public int width() {
        return this.physicalSize.width;
    }

    public int height() {
        return this.physicalSize.height;
    }

    public int logicalWidth() {
        return this.logicalSize.width;
    }

    public int logicalHeight() {
        return this.logicalSize.height;
    }

    public int logicalX(int n) {
        return n + this.offsetX;
    }

    public int logicalY(int n) {
        return n + this.offsetY;
    }

    public void resetHorizontalPosition() {
        this.offsetX = 0;
    }

    public void resetVerticalPosition() {
        this.offsetY = 0;
    }

    public void setLogicalSize(int n, int n2) {
        this.logicalSize.width = n;
        this.logicalSize.height = n2;
    }

    public void setLogicalWidth(int n) {
        this.logicalSize.width = n;
    }

    public void setLogicalHeight(int n) {
        this.logicalSize.height = n;
    }

    public void handleScrollEvent(AdjustmentEvent adjustmentEvent) {
        this.scroller.handleScrollEvent(adjustmentEvent);
    }

    public void componentResized(ComponentEvent componentEvent) {
        Dimension dimension = componentEvent.getComponent().getSize();
        if (this.physicalSize.width == dimension.width && this.physicalSize.height == dimension.height) {
            return;
        }
        this.clerk.resize(dimension.width, dimension.height);
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    class RedrawClerk
    implements Runnable {
        String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
        Rectangle uprct;
        DoubleBufferingPanel client;
        boolean terminated = false;
        boolean requestExist = false;

        RedrawClerk(DoubleBufferingPanel doubleBufferingPanel2) {
            DoubleBufferingPanel.this = DoubleBufferingPanel.this;
            this.client = doubleBufferingPanel2;
        }

        public void redraw(Rectangle rectangle) {
            this.uprct = rectangle;
            this.notifyForRedraw();
        }

        public void scroll(int n, int n2) {
            if (this.uprct != null) {
                this.uprct.translate(n, n2);
            }
        }

        public void resize(int n, int n2) {
            this.client.resetGraphicBuffer(n, n2);
            this.uprct = null;
            this.redraw(new Rectangle(0, 0, n, n2));
        }

        private synchronized void waitForRedraw() {
            if (!this.requestExist) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.requestExist = false;
        }

        private synchronized void notifyForRedraw() {
            this.requestExist = true;
            this.notify();
        }

        public void run() {
            while (!this.terminated) {
                this.waitForRedraw();
                if (this.uprct != null) {
                    this.client.redraw(this.uprct.x, this.uprct.y, this.uprct.width, this.uprct.height);
                    this.client.drawBuffer();
                }
                this.client.notifyRedrawComplete();
            }
        }
    }

    class ScrollClerk
    implements Runnable {
        String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
        DoubleBufferingPanel client;
        boolean terminated;
        boolean requestExist;
        AdjustmentEvent evt;

        ScrollClerk(DoubleBufferingPanel doubleBufferingPanel2) {
            DoubleBufferingPanel.this = DoubleBufferingPanel.this;
            this.client = doubleBufferingPanel2;
        }

        public void handleScrollEvent(AdjustmentEvent adjustmentEvent) {
            this.evt = adjustmentEvent;
            this.notifyForScroll();
        }

        public void handleHorizontalScrollEvent(AdjustmentEvent adjustmentEvent) {
            switch (adjustmentEvent.getAdjustmentType()) {
                case 1: {
                    this.client.scroll(DoubleBufferingPanel.this.dx(), 0);
                    return;
                }
                case 2: {
                    this.client.scroll(-DoubleBufferingPanel.this.dx(), 0);
                    return;
                }
                case 4: {
                    this.client.scroll(DoubleBufferingPanel.this.width(), 0);
                    return;
                }
                case 3: {
                    this.client.scroll(-DoubleBufferingPanel.this.width(), 0);
                    return;
                }
                case 5: {
                    this.client.scrollToX(adjustmentEvent.getValue());
                    return;
                }
            }
        }

        public void handleVerticalScrollEvent(AdjustmentEvent adjustmentEvent) {
            switch (adjustmentEvent.getAdjustmentType()) {
                case 1: {
                    this.client.scroll(0, DoubleBufferingPanel.this.dy());
                    return;
                }
                case 2: {
                    this.client.scroll(0, -DoubleBufferingPanel.this.dy());
                    return;
                }
                case 4: {
                    this.client.scroll(0, DoubleBufferingPanel.this.height());
                    return;
                }
                case 3: {
                    this.client.scroll(0, -DoubleBufferingPanel.this.height());
                    return;
                }
                case 5: {
                    this.client.scrollToY(adjustmentEvent.getValue());
                    return;
                }
            }
        }

        private synchronized void waitForScroll() {
            if (!this.requestExist) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.requestExist = false;
        }

        private synchronized void notifyForScroll() {
            this.requestExist = true;
            this.notify();
        }

        public void run() {
            while (!this.terminated) {
                this.waitForScroll();
                if (this.evt.getAdjustable().getOrientation() == 0) {
                    this.handleHorizontalScrollEvent(this.evt);
                    continue;
                }
                this.handleVerticalScrollEvent(this.evt);
            }
        }
    }
}

