/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.netdiver.gui;

import COM.ibm.netdiver.gui.DoubleBufferingPanel;
import COM.ibm.netdiver.gui.ScrollClient;
import COM.ibm.netdiver.gui.WebContent;
import COM.ibm.netdiver.mm.image.ImageData;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;

public class ImagePane
extends DoubleBufferingPanel
implements WebContent,
ScrollClient,
Runnable {
    String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
    private Image image;
    private Image[] images;
    private int columnWidth = 20;
    private int rowHeight = 20;
    private Thread animatorThread;
    private int index;
    private static final int INTERVAL = 200;

    public ImagePane() {
        this.setBackground(Color.lightGray);
    }

    public void setContent(Object object) {
        ImageData imageData;
        if (object != null && object instanceof ImageData && (imageData = (ImageData)object).status() == 3) {
            if (imageData.isAnimated()) {
                this.images = imageData.createAnimatedImages(this);
                this.index = 0;
                this.animatorThread = null;
                this.image = this.images[0];
                this.play();
            } else {
                this.image = imageData.createImage(this);
            }
            this.setBounds(0, 0, this.image.getWidth(this), this.image.getHeight(this));
        }
    }

    public void refresh() {
        this.repaint();
    }

    public void settle() {
        this.stop();
        this.image = null;
        this.images = null;
    }

    public int topMargin() {
        return 0;
    }

    public int bottomMargin() {
        return 0;
    }

    public int leftMargin() {
        return 0;
    }

    public int rightMargin() {
        return 0;
    }

    public int dx() {
        return this.columnWidth;
    }

    public int dy() {
        return this.rowHeight;
    }

    public void updateScrollbar() {
    }

    public void handleScrollEvent(AdjustmentEvent adjustmentEvent) {
        super.handleScrollEvent(adjustmentEvent);
    }

    public synchronized void redraw(int n, int n2, int n3, int n4) {
        try {
            if (this.image != null) {
                this.graphics().drawImage(this.image, this.physicalX(0), this.physicalY(0), this);
                return;
            }
        }
        catch (NullPointerException nullPointerException) {}
    }

    public Dimension layoutContents(Rectangle rectangle) {
        return new Dimension(this.image.getWidth(this), this.image.getHeight(this));
    }

    public void play() {
        if (this.animatorThread == null) {
            this.animatorThread = new Thread(this);
            this.animatorThread.start();
        }
    }

    public void stop() {
        if (this.animatorThread != null && this.animatorThread.isAlive()) {
            this.animatorThread.stop();
        }
        this.animatorThread = null;
    }

    public void run() {
        while (true) {
            if (this.index >= this.images.length) {
                this.index = 0;
            }
            this.setImage(this.images[this.index++]);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    private void setImage(Image image) {
        if (image != null) {
            this.image = image;
        }
        this.redraw(0, 0, 0, 0);
        this.paint(this.graphics());
    }
}

