/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.netdiver.gui;

import COM.ibm.netdiver.gml.SGMLLayout;
import COM.ibm.netdiver.gml.SGMLText;
import COM.ibm.netdiver.gui.Layout;
import COM.ibm.netdiver.gui.LayoutException;
import COM.ibm.netdiver.gui.TextStyle;
import COM.ibm.netdiver.gui.TextStyleContext;
import COM.ibm.netdiver.gui.item.TextItem;
import COM.ibm.netdiver.util.ArrayCharacterIterator;
import COM.ibm.netdiver.util.Char;
import COM.ibm.netdiver.util.CharBuffer;
import java.awt.FontMetrics;
import java.text.BreakIterator;
import java.text.CharacterIterator;

public class LayoutableText
extends SGMLText {
    String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
    private char[] text;
    private static final boolean nlssupport = true;

    public LayoutableText(String string) {
        int n = string.length();
        this.text = new char[n];
        if (n > 0) {
            string.getChars(0, n, this.text, 0);
        }
    }

    public LayoutableText(char[] cArray, int n, int n2) {
        int n3 = n2 - n;
        this.text = new char[n3];
        System.arraycopy(cArray, n, this.text, 0, n3);
    }

    public LayoutableText(CharBuffer charBuffer) {
        this.text = charBuffer.getBuffer();
    }

    public void layout(SGMLLayout sGMLLayout) throws LayoutException {
        this.layout((Layout)sGMLLayout);
    }

    public void layout(Layout layout) throws LayoutException {
        TextStyleContext textStyleContext = (TextStyleContext)layout.getContext(TextStyleContext.ID);
        if (textStyleContext == null) {
            return;
        }
        TextStyle textStyle = textStyleContext.style();
        FontMetrics fontMetrics = textStyleContext.fontMetrics();
        int n = 0;
        if (!layout.nowrap()) {
            while (true) {
                int n2;
                int n3 = layout.xAvailable();
                if (fontMetrics.charsWidth(this.text, n, this.text.length - n) <= n3) break;
                int n4 = n;
                int n5 = 0;
                int n6 = (this.text.length - n + 1) / 2;
                while (n6 >= 1) {
                    if (this.text.length > n4 + n6 && n5 + (n2 = fontMetrics.charsWidth(this.text, n4, n6)) <= n3) {
                        n5 += n2;
                        n4 += n6;
                    }
                    if (n6 == 1) break;
                    n6 = (n6 + 1) / 2;
                }
                n2 = 0;
                n4 = this.findLastNlsBreak(this.text, n, n4);
                if (n4 == n) {
                    n4 = this.findFirstNlsBreak(this.text, n4);
                    layout.newLine();
                    n2 = 1;
                }
                if (n4 > n) {
                    this.addTextItem(layout, textStyle, fontMetrics, this.text, n, n4);
                    if (n2 == 0) {
                        n4 = Char.skip_space(this.text, n4);
                    }
                    n = n4;
                    if (n2 != 0) continue;
                    layout.crlf();
                    continue;
                }
                if (n >= this.text.length) break;
                if (this.text[n] != ' ') continue;
                ++n;
            }
        }
        if (n < this.text.length) {
            this.addTextItem(layout, textStyle, fontMetrics, this.text, n, this.text.length);
        }
    }

    private void addTextItem(Layout layout, TextStyle textStyle, FontMetrics fontMetrics, char[] cArray, int n, int n2) throws LayoutException {
        if (cArray[n] == ' ' && layout.atTopOfLine()) {
            ++n;
        }
        if (n >= n2) {
            return;
        }
        String string = new String(cArray, n, n2 - n);
        layout.addItem(new TextItem(string, textStyle, fontMetrics.stringWidth(string), fontMetrics.getHeight()));
    }

    protected int findLastBreak(char[] cArray, int n, int n2) {
        TextBreaker textBreaker = new TextBreaker(cArray);
        ((BreakIterator)textBreaker).following(n2 - 1);
        int n3 = ((BreakIterator)textBreaker).previous();
        if (n3 > n) {
            return n2;
        }
        return n;
    }

    protected int findFirstBreak(char[] cArray, int n) {
        TextBreaker textBreaker = new TextBreaker(cArray);
        int n2 = ((BreakIterator)textBreaker).following(n);
        if (n2 < cArray.length && n2 >= 0) {
            return n2;
        }
        return n;
    }

    protected int findLastNlsBreak(char[] cArray, int n, int n2) {
        while (n2 > n && cArray[n2] != ' ') {
            if (this.isNlsBreakPoint(cArray[n2])) break;
            --n2;
        }
        if (n2 == n && cArray.length - n == 1) {
            n2 = cArray.length;
        }
        return n2;
    }

    protected int findFirstNlsBreak(char[] cArray, int n) {
        while (n < cArray.length && cArray[n] != ' ') {
            if (this.isNlsBreakPoint(cArray[n])) break;
            ++n;
        }
        return n;
    }

    protected boolean isNlsBreakPoint(char c) {
        Character c2 = new Character(c);
        int n = c2.hashCode();
        if (n < 4352) {
            return false;
        }
        if (n < 4608) {
            return true;
        }
        if (n < 12288) {
            return false;
        }
        if (c == '\u3002' || c == '\u3001' || c == '\uff1f' || c == '\uff09' || c == '\u300d') {
            return false;
        }
        if (n < 12704) {
            return true;
        }
        if (n < 12800) {
            return false;
        }
        if (n < 13312) {
            return true;
        }
        if (n < 19968) {
            return false;
        }
        if (n < 40870) {
            return true;
        }
        if (n < 44032) {
            return false;
        }
        if (n < 55204) {
            return true;
        }
        if (n < 63744) {
            return false;
        }
        if (n < 64256) {
            return true;
        }
        if (n < 65072) {
            return false;
        }
        if (n < 65104) {
            return true;
        }
        if (n < 65280) {
            return false;
        }
        return n < 65519;
    }

    public String toString() {
        return new String(this.text, 0, this.text.length);
    }

    final class TextBreaker
    extends BreakIterator {
        String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
        BreakIterator impl = BreakIterator.getWordInstance();

        TextBreaker(char[] cArray) {
            LayoutableText.this = LayoutableText.this;
            this.impl.setText(new ArrayCharacterIterator(cArray, 0, cArray.length));
        }

        public int first() {
            return this.impl.first();
        }

        public int last() {
            return this.impl.last();
        }

        public int next(int n) {
            return this.impl.next(n);
        }

        public int next() {
            return this.impl.next();
        }

        public int previous() {
            return this.impl.previous();
        }

        public int current() {
            return this.impl.current();
        }

        public int following(int n) {
            return this.impl.following(n);
        }

        public CharacterIterator getText() {
            return this.impl.getText();
        }

        public void setText(CharacterIterator characterIterator) {
            this.impl.setText(characterIterator);
        }
    }
}

