/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.netdiver.gui;

import java.awt.Font;

public class TextStyle {
    String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
    public static final int DEFAULT_FONT_STYLE = 0;
    public static final int DEFAULT_FONT_NAME_INDEX = 0;
    public static final int DEFAULT_FONT_SIZE_INDEX = 2;
    public static final int DEFAULT_FONT_SCRIPT = 0;
    public static final int FIXED_FONT_NAME_INDEX = 1;
    public static int[] FONTSIZE = new int[]{8, 12, 14, 16, 20, 24, 28, 34};
    public static String[] FONTNAME = new String[]{"Serif", "MonoSpaced", "Dialog"};
    public static final int NORMAL = 0;
    public static final int SUPERSCRIPT = 1;
    public static final int SUBSCRIPT = 2;
    protected int attribute;

    public TextStyle() {
        this.setFontStyle(0);
        this.setFontNameIndex(0);
        this.setFontSizeIndex(2);
        this.setScript(0);
    }

    public TextStyle(TextStyle textStyle) {
        this.attribute = textStyle.attribute;
    }

    public boolean equals(TextStyle textStyle) {
        return this.attribute == textStyle.attribute;
    }

    public final synchronized void setFontStyle(int n) {
        this.attribute = this.attribute & 0xFFFFFFF0 | n;
    }

    public final synchronized void setFontSizeIndex(int n) {
        this.attribute = this.attribute & 0xFFFFFF0F | n << 4;
    }

    public final synchronized void setFontNameIndex(int n) {
        this.attribute = this.attribute & 0xFFFFF0FF | n << 8;
    }

    public final synchronized void setScript(int n) {
        this.attribute = this.attribute & 0xFFFF0FFF | n << 12;
    }

    public final synchronized void setOption(int n) {
        this.attribute = this.attribute & 0xFFF0FFFF | n << 16;
    }

    public final int fontStyle() {
        return this.attribute & 0xF;
    }

    public final int fontSizeIndex() {
        return this.attribute >> 4 & 0xF;
    }

    public final int fontNameIndex() {
        return this.attribute >> 8 & 0xF;
    }

    public final int script() {
        return this.attribute >> 12 & 0xF;
    }

    public final int option() {
        return this.attribute >> 16 & 0xF;
    }

    public final boolean underline() {
        return (this.attribute & 0x100000) != 0;
    }

    public final boolean strike() {
        return (this.attribute & 0x200000) != 0;
    }

    public final boolean colored() {
        return (this.attribute & 0x400000) != 0;
    }

    public final void setUnderline(boolean bl) {
        this.attribute = this.attribute & 0xFFFEFFFF | (bl ? 0x100000 : 0);
    }

    public final void setStrike(boolean bl) {
        this.attribute = this.attribute & 0xFFFDFFFF | (bl ? 0x200000 : 0);
    }

    public final void setColored(boolean bl) {
        this.attribute = this.attribute & 0xFFFBFFFF | (bl ? 0x400000 : 0);
    }

    public String toString() {
        Font font = new Font(FONTNAME[this.fontNameIndex()], this.fontStyle(), FONTSIZE[this.fontSizeIndex()]);
        String string = "";
        if (this.script() != 0) {
            string = String.valueOf(string) + " script[" + this.script() + "]";
        }
        if (this.option() != 0) {
            string = String.valueOf(string) + " option[" + this.option() + "]";
        }
        if (this.underline()) {
            string = String.valueOf(string) + " underline";
        }
        if (this.strike()) {
            string = String.valueOf(string) + " strike";
        }
        return String.valueOf(font.toString()) + string;
    }
}

