/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.netdiver.gui.item;

import COM.ibm.netdiver.gui.ColoredTextStyle;
import COM.ibm.netdiver.gui.DrawingContext;
import COM.ibm.netdiver.gui.TextDrawingContext;
import COM.ibm.netdiver.gui.TextStyle;
import COM.ibm.netdiver.gui.item.GraphicItem;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class TextItem
extends GraphicItem {
    String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
    private TextStyle style;
    private String text;

    public TextItem(String string, TextStyle textStyle, int n, int n2) {
        super(-1, -1, n, n2);
        this.text = string;
        this.style = textStyle;
    }

    public TextItem(TextItem textItem, TextStyle textStyle) {
        super(textItem);
        this.text = textItem.text;
        this.style = textStyle;
    }

    public TextItem(TextItem textItem) {
        this(textItem, textItem.style);
    }

    public void draw(DrawingContext drawingContext) {
        this.draw(drawingContext, null);
    }

    public void draw(DrawingContext drawingContext, Graphics graphics) {
        if (drawingContext instanceof TextDrawingContext) {
            try {
                FontMetrics fontMetrics = ((TextDrawingContext)((Object)drawingContext)).textStyleContext().fontMetrics(this.style);
                if (graphics == null) {
                    graphics = drawingContext.graphics();
                    if (this.style.colored() && this.style instanceof ColoredTextStyle) {
                        graphics.setColor(((ColoredTextStyle)this.style).color());
                    } else {
                        graphics.setColor(drawingContext.getForeground());
                    }
                    graphics.setFont(fontMetrics.getFont());
                }
                int n = fontMetrics.getAscent();
                int n2 = drawingContext.physicalX(this.x);
                int n3 = drawingContext.physicalY(this.y);
                graphics.drawString(this.text, n2, n3 + n);
                if (this.style.underline()) {
                    graphics.drawLine(n2, n3 + n, n2 + this.width, n3 + n);
                }
                if (this.style.strike()) {
                    graphics.drawLine(n2, n3 + n * 2 / 3, n2 + this.width, n3 + n * 2 / 3);
                    return;
                }
            }
            catch (NullPointerException nullPointerException) {
                return;
            }
        }
    }

    public TextStyle style() {
        return this.style;
    }

    public void setStyle(TextStyle textStyle) {
        this.style = textStyle;
    }

    public String toString() {
        return String.valueOf(super.toString()) + ": \"" + this.text + "\" " + this.style.toString();
    }
}

