/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.netdiver.mm;

import COM.ibm.netdiver.mm.MalformedContentTypeException;
import COM.ibm.netdiver.util.Char;
import java.util.Hashtable;

public final class ContentType {
    String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
    private String string;
    private int length;
    String primaryType;
    String subType;
    private static final String PT_audio = "audio";
    private static final String PT_image = "image";
    private static final String PT_text = "text";
    private static final String PT_www = "www";
    private static final String ST_basic = "basic";
    private static final String ST_bmp = "bmp";
    private static final String ST_gif = "gif";
    private static final String ST_html = "html";
    private static final String ST_jpeg = "jpeg";
    private static final String ST_mime = "mime";
    private static final String ST_plain = "plain";
    private static final String ST_x_wav = "x-wav";
    private static Hashtable predef = new Hashtable();

    public ContentType(String string) throws MalformedContentTypeException {
        this.string = string;
        this.length = string.length();
        this.parse(0);
    }

    public ContentType(String string, String string2) {
        this.primaryType = string;
        this.subType = string2;
    }

    public String getPrimaryTypeString() {
        return this.primaryType;
    }

    public String getSubTypeString() {
        return this.subType;
    }

    public String getContentTypeString() {
        return String.valueOf(this.getPrimaryTypeString()) + '/' + this.getSubTypeString();
    }

    public String toString() {
        return this.getContentTypeString();
    }

    private int advance(int n) {
        int n2 = n;
        while (n2 < this.length) {
            if (!Char.istoken(this.string.charAt(n2))) break;
            ++n2;
        }
        return n2;
    }

    private int parse(int n) throws MalformedContentTypeException {
        int n2 = this.advance(n);
        int n3 = this.advance(n2 + 1);
        if (n2 <= 0 || this.string.charAt(n2) != '/' || n3 <= n2 + 1) {
            throw new MalformedContentTypeException();
        }
        this.primaryType = this.string.substring(n, n2);
        this.subType = this.string.substring(n2 + 1, n3);
        return n2;
    }

    public static ContentType find(String string) {
        ContentType contentType = null;
        int n = string.lastIndexOf(46);
        if (n == -1) {
            n = string.lastIndexOf(47);
        }
        if (n > 0) {
            contentType = (ContentType)predef.get(string.substring(n + 1).toLowerCase());
        }
        return contentType;
    }

    static {
        predef.put("au", new ContentType(PT_audio, ST_basic));
        predef.put(ST_bmp, new ContentType(PT_image, ST_bmp));
        predef.put(ST_gif, new ContentType(PT_image, ST_gif));
        predef.put("htm", new ContentType(PT_text, ST_html));
        predef.put(ST_html, new ContentType(PT_text, ST_html));
        predef.put(ST_jpeg, new ContentType(PT_image, ST_jpeg));
        predef.put("jpg", new ContentType(PT_image, ST_jpeg));
        predef.put(ST_mime, new ContentType(PT_www, ST_mime));
        predef.put("txt", new ContentType(PT_text, ST_plain));
        predef.put("wav", new ContentType(PT_audio, ST_x_wav));
    }
}

